/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.TintAwareDrawable;
import carbon.drawable.AlphaDrawable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;

public class VectorDrawable
extends Drawable
implements AlphaDrawable,
TintAwareDrawable {
    private VectorDrawableState state;
    private Bitmap bitmap;
    private static SparseArray<SVG> cache = new SparseArray();
    private boolean mutated = false;

    public static void clearCache() {
        cache.clear();
    }

    public VectorDrawable(VectorDrawableState state) {
        this.state = state;
        this.setBounds(0, 0, state.intWidth, state.intHeight);
    }

    public VectorDrawable(SVG svg, int intWidth, int intHeight) {
        this.state = new VectorDrawableState(svg, intWidth, intHeight);
        this.setBounds(0, 0, this.state.intWidth, this.state.intHeight);
    }

    public VectorDrawable(Resources res, int resId) {
        if (resId == 0) {
            return;
        }
        try {
            SVG svg = (SVG)cache.get(resId);
            if (svg == null) {
                svg = SVG.getFromResource((Resources)res, (int)resId);
                cache.put(resId, (Object)svg);
            }
            float density = res.getDisplayMetrics().density;
            float width = svg.getDocumentViewBox().width();
            float height = svg.getDocumentViewBox().height();
            int intWidth = (int)(width * density);
            int intHeight = (int)(height * density);
            this.state = new VectorDrawableState(svg, intWidth, intHeight);
            this.setBounds(0, 0, this.state.intWidth, this.state.intHeight);
        }
        catch (SVGParseException sVGParseException) {
            // empty catch block
        }
    }

    public void setBounds(int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        if (this.state.svg == null || width == 0 || height == 0 || this.bitmap != null && this.bitmap.getWidth() == width && this.bitmap.getHeight() == height) {
            return;
        }
        this.state.svg.setDocumentWidth((float)width);
        this.state.svg.setDocumentHeight((float)height);
        this.bitmap = null;
        super.setBounds(left, top, right, bottom);
    }

    public void draw(@NonNull Canvas canvas) {
        int width = this.getBounds().width();
        int height = this.getBounds().height();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.bitmap == null) {
            this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.state.svg.renderToCanvas(new Canvas(this.bitmap));
        }
        this.updateTint();
        canvas.drawBitmap(this.bitmap, (float)this.getBounds().left, (float)this.getBounds().top, this.state.paint);
    }

    public void setAlpha(int alpha) {
        this.state.paint.setAlpha(alpha);
    }

    @Override
    public int getAlpha() {
        return this.state.paint.getAlpha();
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(@NonNull int[] stateSet) {
        boolean result = super.setState(stateSet);
        this.updateTint();
        return result;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.state.colorFilter = colorFilter;
        this.state.tint = null;
        this.state.tintMode = null;
    }

    public void setTint(int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setTintList(@Nullable ColorStateList tint) {
        this.state.colorFilter = null;
        this.state.tint = tint;
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.state.colorFilter = null;
        this.state.tintMode = tintMode;
    }

    public void updateTint() {
        if (this.state.colorFilter != null) {
            this.state.paint.setColorFilter(this.state.colorFilter);
        } else if (this.state.tint != null && this.state.tintMode != null) {
            this.state.paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.state.tint.getColorForState(this.getState(), this.state.tint.getDefaultColor()), this.state.tintMode));
        } else {
            this.state.paint.setColorFilter(null);
        }
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.state.intWidth;
    }

    public int getIntrinsicHeight() {
        return this.state.intHeight;
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    @NonNull
    public Drawable mutate() {
        if (!this.mutated) {
            this.state = new VectorDrawableState(this.state);
            this.mutated = true;
        }
        return this;
    }

    private static class VectorDrawableState
    extends Drawable.ConstantState {
        SVG svg;
        private Paint paint = new Paint(3);
        int intWidth;
        int intHeight;
        public ColorFilter colorFilter;
        public ColorStateList tint;
        public PorterDuff.Mode tintMode = PorterDuff.Mode.SRC_IN;

        public VectorDrawableState(SVG svg, int intWidth, int intHeight) {
            this.svg = svg;
            this.intWidth = intWidth;
            this.intHeight = intHeight;
        }

        public VectorDrawableState(VectorDrawableState state) {
            this.svg = state.svg;
            this.intWidth = state.intWidth;
            this.intHeight = state.intHeight;
            this.paint = state.paint;
            this.colorFilter = state.colorFilter;
            this.tint = state.tint;
            this.tintMode = state.tintMode;
        }

        @NonNull
        public Drawable newDrawable() {
            return new VectorDrawable(this);
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

