/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Build;
import android.util.Log;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import java.lang.reflect.Method;

class DrawableReflectiveUtils {
    private static final String TAG = "DrawableReflectiveUtils";
    private static SimpleArrayMap<String, Method> sCachedMethods = new SimpleArrayMap();
    private static final ColorFilterLruCache COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};

    DrawableReflectiveUtils() {
    }

    public static <T> T tryInvoke(Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        try {
            Method method = (Method)sCachedMethods.get((Object)methodName);
            if (method != null) {
                return (T)method.invoke(target, args);
            }
            method = target.getClass().getDeclaredMethod(methodName, argTypes);
            sCachedMethods.put((Object)methodName, (Object)method);
            return (T)method.invoke(target, args);
        }
        catch (Exception pokemon) {
            Log.e((String)TAG, (String)("Unable to invoke " + methodName + " on " + target), (Throwable)pokemon);
            return null;
        }
    }

    public static PorterDuffColorFilter setColor(PorterDuffColorFilter cf, int color2, PorterDuff.Mode mode) {
        if (Build.VERSION.SDK_INT < 21) {
            PorterDuffColorFilter filter = COLOR_FILTER_CACHE.get(color2, mode);
            if (filter == null) {
                filter = new PorterDuffColorFilter(color2, mode);
                COLOR_FILTER_CACHE.put(color2, mode, filter);
            }
            return filter;
        }
        DrawableReflectiveUtils.tryInvoke(cf, "setColor", INT_ARG, color2);
        return cf;
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color2, mode));
        }

        PorterDuffColorFilter put(int color2, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color2, mode), filter);
        }

        private static int generateCacheKey(int color2, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color2;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }
}

