/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.GravityCompat;
import carbon.R;
import carbon.drawable.ripple.LollipopDrawable;
import carbon.drawable.ripple.LollipopDrawablesCompat;
import carbon.drawable.ripple.TypedArrayCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends LollipopDrawable
implements Drawable.Callback {
    public static final int PADDING_MODE_NEST = 0;
    public static final int PADDING_MODE_STACK = 1;
    private static final int UNDEFINED_INSET = Integer.MIN_VALUE;
    LayerState mLayerState;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpOutRect = new Rect();
    private final Rect mTmpContainer = new Rect();
    private Rect mHotspotBounds;
    private boolean mMutated;

    public LayerDrawable(@NonNull Drawable[] layers) {
        this(layers, null);
    }

    LayerDrawable(@NonNull Drawable[] layers, @Nullable LayerState state) {
        this(state, null);
        if (layers == null) {
            throw new IllegalArgumentException("layers must be non-null");
        }
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            r[i] = new ChildDrawable();
            r[i].mDrawable = layers[i];
            layers[i].setCallback((Drawable.Callback)this);
            this.mLayerState.mChildrenChangingConfigurations |= layers[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
        this.refreshPadding();
    }

    LayerDrawable() {
        this((LayerState)null, null);
    }

    LayerDrawable(@Nullable LayerState state, @Nullable Resources res) {
        this.mLayerState = this.createConstantState(state, res);
        if (this.mLayerState.mNum > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
    }

    LayerState createConstantState(@Nullable LayerState state, @Nullable Resources res) {
        return new LayerState(state, this, res);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateLayers(r, parser, attrs, theme);
        this.ensurePadding();
        this.refreshPadding();
    }

    private void updateStateFromTypedArray(TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChangingConfigurations |= TypedArrayCompat.getChangingConfigurations(a);
        state.mThemeAttrs = TypedArrayCompat.extractThemeAttrs(a);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.LayerDrawable_android_opacity) {
                state.mOpacityOverride = a.getInt(attr2, state.mOpacityOverride);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingTop) {
                state.mPaddingTop = a.getDimensionPixelOffset(attr2, state.mPaddingTop);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingBottom) {
                state.mPaddingBottom = a.getDimensionPixelOffset(attr2, state.mPaddingBottom);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingLeft) {
                state.mPaddingLeft = a.getDimensionPixelOffset(attr2, state.mPaddingLeft);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingRight) {
                state.mPaddingRight = a.getDimensionPixelOffset(attr2, state.mPaddingRight);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingStart) {
                state.mPaddingStart = a.getDimensionPixelOffset(attr2, state.mPaddingStart);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_paddingEnd) {
                state.mPaddingEnd = a.getDimensionPixelOffset(attr2, state.mPaddingEnd);
                continue;
            }
            if (attr2 == R.styleable.LayerDrawable_android_autoMirrored) {
                state.mAutoMirrored = a.getBoolean(attr2, state.mAutoMirrored);
                continue;
            }
            if (attr2 != R.styleable.LayerDrawable_android_paddingMode) continue;
            state.mPaddingMode = a.getInteger(attr2, state.mPaddingMode);
        }
    }

    private void inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            ChildDrawable layer = new ChildDrawable();
            TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawableItem);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null && (layer.mThemeAttrs == null || layer.mThemeAttrs[R.styleable.LayerDrawableItem_android_drawable] == 0)) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
                }
                layer.mDrawable = LollipopDrawablesCompat.createFromXmlInner(r, parser, attrs, theme);
            }
            if (layer.mDrawable != null) {
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
                layer.mDrawable.setCallback((Drawable.Callback)this);
            }
            this.addLayer(layer);
        }
    }

    private void updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= TypedArrayCompat.getChangingConfigurations(a);
        layer.mThemeAttrs = TypedArrayCompat.extractThemeAttrs(a);
        layer.mInsetL = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_left, layer.mInsetL);
        layer.mInsetT = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_top, layer.mInsetT);
        layer.mInsetR = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_right, layer.mInsetR);
        layer.mInsetB = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_bottom, layer.mInsetB);
        layer.mInsetS = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_start, layer.mInsetS);
        layer.mInsetE = a.getDimensionPixelOffset(R.styleable.LayerDrawableItem_android_end, layer.mInsetE);
        layer.mWidth = a.getDimensionPixelSize(R.styleable.LayerDrawableItem_android_width, layer.mWidth);
        layer.mHeight = a.getDimensionPixelSize(R.styleable.LayerDrawableItem_android_height, layer.mHeight);
        layer.mGravity = a.getInteger(R.styleable.LayerDrawableItem_android_gravity, layer.mGravity);
        layer.mId = a.getResourceId(R.styleable.LayerDrawableItem_android_id, layer.mId);
        Drawable dr = a.getDrawable(R.styleable.LayerDrawableItem_android_drawable);
        if (dr != null) {
            layer.mDrawable = dr;
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        ChildDrawable[] array = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable layer = array[i];
            Drawable d = layer.mDrawable;
            if (d == null || !LollipopDrawablesCompat.canApplyTheme(d)) continue;
            LollipopDrawablesCompat.applyTheme(d, t);
            state.mChildrenChangingConfigurations |= d.getChangingConfigurations();
        }
        this.ensurePadding();
    }

    @Override
    public boolean canApplyTheme() {
        return this.mLayerState != null && this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    int addLayer(ChildDrawable layer) {
        LayerState st = this.mLayerState;
        int i = st.mNum;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                System.arraycopy(st.mChildren, 0, nu, 0, i);
            }
            st.mChildren = nu;
        }
        st.mChildren[i] = layer;
        ++st.mNum;
        st.invalidateCache();
        return i;
    }

    ChildDrawable addLayer(Drawable dr, int[] themeAttrs, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable = this.createLayer(dr);
        childDrawable.mId = id2;
        childDrawable.mThemeAttrs = themeAttrs;
        if (Build.VERSION.SDK_INT >= 19) {
            childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        }
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        this.addLayer(childDrawable);
        this.mLayerState.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
        dr.setCallback((Drawable.Callback)this);
        return childDrawable;
    }

    private ChildDrawable createLayer(Drawable dr) {
        ChildDrawable layer = new ChildDrawable();
        layer.mDrawable = dr;
        return layer;
    }

    public int addLayer(Drawable dr) {
        ChildDrawable layer = this.createLayer(dr);
        int index = this.addLayer(layer);
        this.ensurePadding();
        this.refreshChildPadding(index, layer);
        return index;
    }

    public Drawable findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    public void setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    public int getId(int index) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mId;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        int index = this.findIndexByLayerId(id2);
        if (index < 0) {
            return false;
        }
        this.setDrawable(index, drawable2);
        return true;
    }

    public int findIndexByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable childDrawable = layers[i];
            if (childDrawable.mId != id2) continue;
            return i;
        }
        return -1;
    }

    public void setDrawable(int index, Drawable drawable2) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        ChildDrawable childDrawable = layers[index];
        if (childDrawable.mDrawable != null) {
            if (drawable2 != null) {
                Rect bounds = childDrawable.mDrawable.getBounds();
                drawable2.setBounds(bounds);
            }
            childDrawable.mDrawable.setCallback(null);
        }
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
        childDrawable.mDrawable = drawable2;
        this.mLayerState.invalidateCache();
        this.refreshChildPadding(index, childDrawable);
    }

    public Drawable getDrawable(int index) {
        if (index >= this.mLayerState.mNum) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mDrawable;
    }

    public void setLayerSize(int index, int w, int h) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
        childDrawable.mHeight = h;
    }

    public void setLayerWidth(int index, int w) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
    }

    public int getLayerWidth(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mWidth;
    }

    public void setLayerHeight(int index, int h) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mHeight = h;
    }

    public int getLayerHeight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mHeight;
    }

    public void setLayerGravity(int index, int gravity) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mGravity = gravity;
    }

    public int getLayerGravity(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mGravity;
    }

    public void setLayerInset(int index, int l, int t, int r, int b) {
        this.setLayerInsetInternal(index, l, t, r, b, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void setLayerInsetRelative(int index, int s, int t, int e, int b) {
        this.setLayerInsetInternal(index, 0, t, 0, b, s, e);
    }

    public void setLayerInsetLeft(int index, int l) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
    }

    public int getLayerInsetLeft(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetL;
    }

    public void setLayerInsetRight(int index, int r) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetR = r;
    }

    public int getLayerInsetRight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetR;
    }

    public void setLayerInsetTop(int index, int t) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetT = t;
    }

    public int getLayerInsetTop(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetT;
    }

    public void setLayerInsetBottom(int index, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetB = b;
    }

    public int getLayerInsetBottom(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetB;
    }

    public void setLayerInsetStart(int index, int s) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetS = s;
    }

    public int getLayerInsetStart(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetS;
    }

    public void setLayerInsetEnd(int index, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetE = e;
    }

    public int getLayerInsetEnd(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetE;
    }

    private void setLayerInsetInternal(int index, int l, int t, int r, int b, int s, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
        childDrawable.mInsetT = t;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
        childDrawable.mInsetS = s;
        childDrawable.mInsetE = e;
    }

    public void setPaddingMode(int mode) {
        if (this.mLayerState.mPaddingMode != mode) {
            this.mLayerState.mPaddingMode = mode;
        }
    }

    public int getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    public void draw(Canvas canvas) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.draw(canvas);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.getChangingConfigurations();
    }

    public boolean getPadding(Rect padding) {
        int paddingRight;
        int paddingLeft;
        int paddingRtlRight;
        int paddingRtlLeft;
        LayerState layerState = this.mLayerState;
        if (layerState.mPaddingMode == 0) {
            this.computeNestedPadding(padding);
        } else {
            this.computeStackedPadding(padding);
        }
        if (layerState.mPaddingTop >= 0) {
            padding.top = layerState.mPaddingTop;
        }
        if (layerState.mPaddingBottom >= 0) {
            padding.bottom = layerState.mPaddingBottom;
        }
        if (Build.VERSION.SDK_INT >= 23 && this.getLayoutDirection() == 1) {
            paddingRtlLeft = layerState.mPaddingEnd;
            paddingRtlRight = layerState.mPaddingStart;
        } else {
            paddingRtlLeft = layerState.mPaddingStart;
            paddingRtlRight = layerState.mPaddingEnd;
        }
        int n = paddingLeft = paddingRtlLeft >= 0 ? paddingRtlLeft : layerState.mPaddingLeft;
        if (paddingLeft >= 0) {
            padding.left = paddingLeft;
        }
        int n2 = paddingRight = paddingRtlRight >= 0 ? paddingRtlRight : layerState.mPaddingRight;
        if (paddingRight >= 0) {
            padding.right = paddingRight;
        }
        return padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingLeft = left;
        layerState.mPaddingTop = top;
        layerState.mPaddingRight = right;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingStart = -1;
        layerState.mPaddingEnd = -1;
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingStart = start;
        layerState.mPaddingTop = top;
        layerState.mPaddingEnd = end;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingLeft = -1;
        layerState.mPaddingRight = -1;
    }

    public int getLeftPadding() {
        return this.mLayerState.mPaddingLeft;
    }

    public int getRightPadding() {
        return this.mLayerState.mPaddingRight;
    }

    public int getStartPadding() {
        return this.mLayerState.mPaddingStart;
    }

    public int getEndPadding() {
        return this.mLayerState.mPaddingEnd;
    }

    public int getTopPadding() {
        return this.mLayerState.mPaddingTop;
    }

    public int getBottomPadding() {
        return this.mLayerState.mPaddingBottom;
    }

    private void computeNestedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
    }

    private void computeStackedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
            padding.left = Math.max(padding.left, this.mPaddingL[i]);
            padding.top = Math.max(padding.top, this.mPaddingT[i]);
            padding.right = Math.max(padding.right, this.mPaddingR[i]);
            padding.bottom = Math.max(padding.bottom, this.mPaddingB[i]);
        }
    }

    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void setHotspot(float x, float y) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            DrawableCompat.setHotspot((Drawable)dr, (float)x, (float)y);
        }
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            DrawableCompat.setHotspotBounds((Drawable)dr, (int)left, (int)top, (int)right, (int)bottom);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setVisible(visible, restart);
        }
        return changed;
    }

    public void setDither(boolean dither) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setDither(dither);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setAlpha(alpha);
        }
    }

    @Override
    @TargetApi(value=19)
    public int getAlpha() {
        Drawable dr = this.getFirstNonNullDrawable();
        if (dr != null) {
            return dr.getAlpha();
        }
        return super.getAlpha();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setColorFilter(colorFilter);
        }
    }

    @Override
    @TargetApi(value=21)
    public void setTintList(ColorStateList tint) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setTintList(tint);
        }
    }

    @Override
    @TargetApi(value=21)
    public void setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setTintMode(tintMode);
        }
    }

    private Drawable getFirstNonNullDrawable() {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            return dr;
        }
        return null;
    }

    public void setOpacity(int opacity) {
        this.mLayerState.mOpacityOverride = opacity;
    }

    public int getOpacity() {
        if (this.mLayerState.mOpacityOverride != 0) {
            return this.mLayerState.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    @TargetApi(value=19)
    public void setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setAutoMirrored(mirrored);
        }
    }

    public boolean isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null || !dr.isStateful() || !dr.setState(state)) continue;
            this.refreshChildPadding(i, array[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    protected boolean onLevelChange(int level) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null || !dr.setLevel(level)) continue;
            this.refreshChildPadding(i, array[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    protected void onBoundsChange(Rect bounds) {
        this.updateLayerBounds(bounds);
    }

    private void updateLayerBounds(Rect bounds) {
        int padL = 0;
        int padT = 0;
        int padR = 0;
        int padB = 0;
        Rect outRect = this.mTmpOutRect;
        int layoutDirection = 0;
        if (Build.VERSION.SDK_INT >= 23) {
            layoutDirection = this.getLayoutDirection();
        }
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            int insetR;
            int insetL;
            ChildDrawable r = array[i];
            Drawable d = r.mDrawable;
            if (d == null) continue;
            Rect container = this.mTmpContainer;
            container.set(d.getBounds());
            if (layoutDirection == 1) {
                insetL = r.mInsetE == Integer.MIN_VALUE ? r.mInsetL : r.mInsetE;
                insetR = r.mInsetS == Integer.MIN_VALUE ? r.mInsetR : r.mInsetS;
            } else {
                insetL = r.mInsetS == Integer.MIN_VALUE ? r.mInsetL : r.mInsetS;
                insetR = r.mInsetE == Integer.MIN_VALUE ? r.mInsetR : r.mInsetE;
            }
            container.set(bounds.left + insetL + padL, bounds.top + r.mInsetT + padT, bounds.right - insetR - padR, bounds.bottom - r.mInsetB - padB);
            int gravity = LayerDrawable.resolveGravity(r.mGravity, r.mWidth, r.mHeight, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            int w = r.mWidth < 0 ? d.getIntrinsicWidth() : r.mWidth;
            int h = r.mHeight < 0 ? d.getIntrinsicHeight() : r.mHeight;
            GravityCompat.apply((int)gravity, (int)w, (int)h, (Rect)container, (Rect)outRect, (int)layoutDirection);
            d.setBounds(outRect);
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
    }

    private static int resolveGravity(int gravity, int width, int height, int intrinsicWidth, int intrinsicHeight) {
        if (!Gravity.isHorizontal((int)gravity)) {
            gravity = width < 0 ? (gravity |= 7) : (gravity |= 0x800003);
        }
        if (!Gravity.isVertical((int)gravity)) {
            gravity = height < 0 ? (gravity |= 0x70) : (gravity |= 0x30);
        }
        if (width < 0 && intrinsicWidth < 0) {
            gravity |= 7;
        }
        if (height < 0 && intrinsicHeight < 0) {
            gravity |= 0x70;
        }
        return gravity;
    }

    public int getIntrinsicWidth() {
        int width = -1;
        int padL = 0;
        int padR = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            int insetR;
            int insetL;
            ChildDrawable r = array[i];
            if (r.mDrawable == null) continue;
            int layoutDirection = 0;
            if (Build.VERSION.SDK_INT >= 23) {
                layoutDirection = this.getLayoutDirection();
            }
            if (layoutDirection == 1) {
                insetL = r.mInsetE == Integer.MIN_VALUE ? r.mInsetL : r.mInsetE;
                insetR = r.mInsetS == Integer.MIN_VALUE ? r.mInsetR : r.mInsetS;
            } else {
                insetL = r.mInsetS == Integer.MIN_VALUE ? r.mInsetL : r.mInsetS;
                insetR = r.mInsetE == Integer.MIN_VALUE ? r.mInsetR : r.mInsetE;
            }
            int minWidth = r.mWidth < 0 ? r.mDrawable.getIntrinsicWidth() : r.mWidth;
            int w = minWidth + insetL + insetR + padL + padR;
            if (w > width) {
                width = w;
            }
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    public int getIntrinsicHeight() {
        int height = -1;
        int padT = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array[i];
            if (r.mDrawable == null) continue;
            int minHeight = r.mHeight < 0 ? r.mDrawable.getIntrinsicHeight() : r.mHeight;
            int h = minHeight + r.mInsetT + r.mInsetB + padT + padB;
            if (h > height) {
                height = h;
            }
            if (!nest) continue;
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private boolean refreshChildPadding(int i, ChildDrawable r) {
        if (r.mDrawable != null) {
            Rect rect = this.mTmpRect;
            r.mDrawable.getPadding(rect);
            if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
                this.mPaddingL[i] = rect.left;
                this.mPaddingT[i] = rect.top;
                this.mPaddingR[i] = rect.right;
                this.mPaddingB[i] = rect.bottom;
                return true;
            }
        }
        return false;
    }

    void ensurePadding() {
        int N = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    void refreshPadding() {
        int N = this.mLayerState.mNum;
        ChildDrawable[] array = this.mLayerState.mChildren;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
        }
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] array = this.mLayerState.mChildren;
            int N = this.mLayerState.mNum;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null) continue;
                dr.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null || Build.VERSION.SDK_INT < 23) continue;
            changed |= dr.setLayoutDirection(layoutDirection);
        }
        this.updateLayerBounds(this.getBounds());
        return changed;
    }

    static TypedArray obtainAttributes(Resources res, Resources.Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    static class LayerState
    extends Drawable.ConstantState {
        int mNum;
        ChildDrawable[] mChildren;
        int[] mThemeAttrs;
        int mPaddingTop = -1;
        int mPaddingBottom = -1;
        int mPaddingLeft = -1;
        int mPaddingRight = -1;
        int mPaddingStart = -1;
        int mPaddingEnd = -1;
        int mOpacityOverride = 0;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity;
        private int mOpacity;
        private boolean mHaveIsStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored = false;
        private int mPaddingMode = 0;

        LayerState(LayerState orig, LayerDrawable owner, Resources res) {
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNum = N = orig.mNum;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveIsStateful = orig.mHaveIsStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mPaddingMode = orig.mPaddingMode;
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mPaddingTop = orig.mPaddingTop;
                this.mPaddingBottom = orig.mPaddingBottom;
                this.mPaddingLeft = orig.mPaddingLeft;
                this.mPaddingRight = orig.mPaddingRight;
                this.mPaddingStart = orig.mPaddingStart;
                this.mPaddingEnd = orig.mPaddingEnd;
                this.mOpacityOverride = orig.mOpacityOverride;
            } else {
                this.mNum = 0;
                this.mChildren = null;
            }
        }

        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                ChildDrawable layer = array[i];
                if (!layer.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        public Drawable newDrawable() {
            return new LayerDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new LayerDrawable(this, res);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public final int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array = this.mChildren;
            int N = this.mNum;
            int firstIndex = -1;
            for (int i = 0; i < N; ++i) {
                if (array[i].mDrawable == null) continue;
                firstIndex = i;
                break;
            }
            int op = firstIndex >= 0 ? array[firstIndex].mDrawable.getOpacity() : -2;
            for (int i = firstIndex + 1; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null) continue;
                op = Drawable.resolveOpacity((int)op, (int)dr.getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        public final boolean isStateful() {
            if (this.mHaveIsStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array = this.mChildren;
            int N = this.mNum;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null || !dr.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mHaveIsStateful = true;
            return isStateful;
        }

        public final boolean canConstantState() {
            ChildDrawable[] array = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null || dr.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        public void invalidateCache() {
            this.mHaveOpacity = false;
            this.mHaveIsStateful = false;
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mInsetS = Integer.MIN_VALUE;
        public int mInsetE = Integer.MIN_VALUE;
        public int mWidth = -1;
        public int mHeight = -1;
        public int mGravity = 0;
        public int mId = -1;

        ChildDrawable() {
        }

        ChildDrawable(ChildDrawable orig, LayerDrawable owner, Resources res) {
            Drawable clone;
            Drawable dr = orig.mDrawable;
            if (dr != null) {
                Drawable.ConstantState cs = dr.getConstantState();
                clone = res != null ? cs.newDrawable(res) : cs.newDrawable();
                clone.setCallback((Drawable.Callback)owner);
                if (Build.VERSION.SDK_INT >= 23) {
                    clone.setLayoutDirection(dr.getLayoutDirection());
                }
                clone.setBounds(dr.getBounds());
                clone.setLevel(dr.getLevel());
            } else {
                clone = null;
            }
            this.mDrawable = clone;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mInsetL = orig.mInsetL;
            this.mInsetT = orig.mInsetT;
            this.mInsetR = orig.mInsetR;
            this.mInsetB = orig.mInsetB;
            this.mInsetS = orig.mInsetS;
            this.mInsetE = orig.mInsetE;
            this.mWidth = orig.mWidth;
            this.mHeight = orig.mHeight;
            this.mGravity = orig.mGravity;
            this.mId = orig.mId;
        }

        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawable != null && LollipopDrawablesCompat.canApplyTheme(this.mDrawable);
        }
    }
}

