/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Property;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import carbon.drawable.ripple.AnimatorsCompat;
import carbon.drawable.ripple.FloatProperty;
import carbon.drawable.ripple.RippleComponent;
import carbon.drawable.ripple.RippleDrawableICS;

class RippleBackground
extends RippleComponent {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final int OPACITY_ENTER_DURATION = 600;
    private static final int OPACITY_ENTER_DURATION_FAST = 120;
    private static final int OPACITY_EXIT_DURATION = 480;
    private float mOpacity = 0.0f;
    private static final BackgroundProperty OPACITY = new BackgroundProperty("opacity"){

        @Override
        public void setValue(RippleBackground object, float value) {
            object.mOpacity = value;
            object.invalidateSelf();
        }

        public Float get(RippleBackground object) {
            return Float.valueOf(object.mOpacity);
        }
    };

    public RippleBackground(RippleDrawableICS owner, Rect bounds) {
        super(owner, bounds);
    }

    public boolean isVisible() {
        return this.mOpacity > 0.0f;
    }

    @Override
    protected boolean drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        int origAlpha = p.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        if (alpha > 0) {
            p.setAlpha(alpha);
            c.drawCircle(0.0f, 0.0f, this.mTargetRadius, p);
            p.setAlpha(origAlpha);
            hasContent = true;
        }
        return hasContent;
    }

    @Override
    protected Animator createSoftwareEnter(boolean fast) {
        int maxDuration = fast ? 120 : 600;
        int duration = (int)((1.0f - this.mOpacity) * (float)maxDuration);
        ObjectAnimator opacity = ObjectAnimator.ofFloat((Object)this, (Property)OPACITY, (float[])new float[]{1.0f});
        AnimatorsCompat.setAutoCancel(opacity);
        opacity.setDuration((long)duration);
        opacity.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
        return opacity;
    }

    @Override
    protected Animator createSoftwareExit() {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator exit = ObjectAnimator.ofFloat((Object)this, (Property)OPACITY, (float[])new float[]{0.0f});
        exit.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
        exit.setDuration(480L);
        AnimatorsCompat.setAutoCancel(exit);
        AnimatorSet.Builder builder = set.play((Animator)exit);
        int fastEnterDuration = (int)((1.0f - this.mOpacity) * 120.0f);
        if (fastEnterDuration > 0) {
            ObjectAnimator enter = ObjectAnimator.ofFloat((Object)this, (Property)OPACITY, (float[])new float[]{1.0f});
            enter.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
            enter.setDuration((long)fastEnterDuration);
            AnimatorsCompat.setAutoCancel(enter);
            builder.after((Animator)enter);
        }
        return set;
    }

    @Override
    protected void jumpValuesToExit() {
        this.mOpacity = 0.0f;
    }

    private static abstract class BackgroundProperty
    extends FloatProperty<RippleBackground> {
        public BackgroundProperty(String name) {
            super(name);
        }
    }
}

