/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.animation.Animator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import carbon.drawable.ripple.RippleDrawableICS;

abstract class RippleComponent {
    private final RippleDrawableICS mOwner;
    protected final Rect mBounds;
    private Animator mSoftwareAnimator;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensity;

    public RippleComponent(RippleDrawableICS owner, Rect bounds) {
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    public void onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    public final void setup(float maxRadius, float density) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensity = density;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static float getTargetRadius(Rect bounds) {
        float halfWidth = (float)bounds.width() / 2.0f;
        float halfHeight = (float)bounds.height() / 2.0f;
        return (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
    }

    public final void enter(boolean fast) {
        this.cancel();
        this.mSoftwareAnimator = this.createSoftwareEnter(fast);
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.start();
        }
    }

    public final void exit() {
        this.cancel();
        this.mSoftwareAnimator = this.createSoftwareExit();
        this.mSoftwareAnimator.start();
    }

    public void cancel() {
        this.cancelSoftwareAnimations();
    }

    public void end() {
        this.endSoftwareAnimations();
    }

    public boolean draw(Canvas c, Paint p) {
        return this.drawSoftware(c, p);
    }

    public void getBounds(Rect bounds) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds.set(-r, -r, r, r);
    }

    private void cancelSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.cancel();
            this.mSoftwareAnimator = null;
        }
    }

    private void endSoftwareAnimations() {
        if (this.mSoftwareAnimator != null) {
            this.mSoftwareAnimator.end();
            this.mSoftwareAnimator = null;
        }
    }

    protected final void invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    protected final void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            float targetRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            this.onTargetRadiusChanged(targetRadius);
        }
    }

    protected void onTargetRadiusChanged(float targetRadius) {
    }

    protected abstract Animator createSoftwareEnter(boolean var1);

    protected abstract Animator createSoftwareExit();

    protected abstract boolean drawSoftware(Canvas var1, Paint var2);

    protected abstract void jumpValuesToExit();
}

