/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import androidx.core.graphics.drawable.TintAwareDrawable;
import carbon.Carbon;
import carbon.drawable.AlphaDrawable;
import carbon.drawable.ripple.RippleDrawableICS;
import carbon.drawable.ripple.RippleDrawableLollipop;
import carbon.drawable.ripple.RippleDrawableMarshmallow;

public interface RippleDrawable
extends AlphaDrawable,
TintAwareDrawable {
    public Drawable getBackground();

    public boolean setState(int[] var1);

    public void draw(Canvas var1);

    public void setAlpha(int var1);

    @Override
    public int getAlpha();

    public void setColorFilter(ColorFilter var1);

    public void jumpToCurrentState();

    public int getOpacity();

    public Style getStyle();

    public boolean isHotspotEnabled();

    public void setHotspotEnabled(boolean var1);

    public void setBounds(int var1, int var2, int var3, int var4);

    public void setBounds(Rect var1);

    public void setHotspot(float var1, float var2);

    public boolean isStateful();

    public void setCallback(Drawable.Callback var1);

    public ColorStateList getColor();

    public void setRadius(int var1);

    public int getRadius();

    public static RippleDrawable create(ColorStateList color2, Style style2, View view, boolean useHotspot, int radius) {
        RippleDrawable rippleDrawable = Build.VERSION.SDK_INT >= 23 ? new RippleDrawableMarshmallow(color2, style2 == Style.Background ? view.getBackground() : null, style2) : (Carbon.IS_LOLLIPOP_OR_HIGHER ? new RippleDrawableLollipop(color2, style2 == Style.Background ? view.getBackground() : null, style2) : new RippleDrawableICS(color2, style2 == Style.Background ? view.getBackground() : null, style2));
        rippleDrawable.setCallback((Drawable.Callback)view);
        rippleDrawable.setHotspotEnabled(useHotspot);
        rippleDrawable.setRadius(radius);
        return rippleDrawable;
    }

    public static RippleDrawable create(ColorStateList color2, Style style2, View view, Drawable background, boolean useHotspot, int radius) {
        RippleDrawable rippleDrawable = Build.VERSION.SDK_INT >= 23 ? new RippleDrawableMarshmallow(color2, background, style2) : (Carbon.IS_LOLLIPOP_OR_HIGHER ? new RippleDrawableLollipop(color2, background, style2) : new RippleDrawableICS(color2, background, style2));
        rippleDrawable.setCallback((Drawable.Callback)view);
        rippleDrawable.setHotspotEnabled(useHotspot);
        rippleDrawable.setRadius(radius);
        return rippleDrawable;
    }

    public static enum Style {
        Over,
        Background,
        Borderless;

    }
}

