/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import carbon.Carbon;
import carbon.R;
import carbon.drawable.ripple.DrawableReflectiveUtils;
import carbon.drawable.ripple.LayerDrawable;
import carbon.drawable.ripple.RippleBackground;
import carbon.drawable.ripple.RippleDrawable;
import carbon.drawable.ripple.RippleForeground;
import carbon.drawable.ripple.TypedArrayCompat;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawableICS
extends LayerDrawable
implements RippleDrawable {
    public static final int RADIUS_AUTO = -1;
    private static final int MASK_UNKNOWN = -1;
    private static final int MASK_NONE = 0;
    private static final int MASK_CONTENT = 1;
    private static final int MASK_EXPLICIT = 2;
    private static final int MAX_RIPPLES = 10;
    private final Rect mTempRect = new Rect();
    private final Rect mHotspotBounds = new Rect();
    private final Rect mDrawingBounds = new Rect();
    private final Rect mDirtyBounds = new Rect();
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private Bitmap mMaskBuffer;
    private BitmapShader mMaskShader;
    private Canvas mMaskCanvas;
    private Matrix mMaskMatrix;
    private PorterDuffColorFilter mMaskColorFilter;
    private boolean mHasValidMask;
    private boolean mBackgroundActive;
    private RippleForeground mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private RippleForeground[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    private float mDensity = 1.0f;
    private boolean mOverrideBounds;
    Drawable background;
    private RippleDrawable.Style style;
    private boolean useHotspot;

    RippleDrawableICS() {
        this(new RippleState(null, null, null), null);
    }

    public RippleDrawableICS(ColorStateList color2, Drawable background, RippleDrawable.Style style2) {
        this(color2, background, (Drawable)(style2 == RippleDrawable.Style.Borderless ? null : new ColorDrawable(-1)));
        this.style = style2;
    }

    public RippleDrawableICS(@NonNull ColorStateList color2, @Nullable Drawable content, @Nullable Drawable mask) {
        this(new RippleState(null, null, null), null);
        if (color2 == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, R.id.carbon_mask, 0, 0, 0, 0);
        }
        this.background = content;
        this.setColor(color2);
        this.ensurePadding();
        this.refreshPadding();
        this.updateLocalState();
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mRipple != null) {
            this.mRipple.end();
        }
        if (this.mBackground != null) {
            this.mBackground.end();
        }
        this.cancelExitingRipples();
    }

    private void cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].end();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        this.invalidateSelf(false);
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
                continue;
            }
            if (state == 16842908) {
                focused = true;
                continue;
            }
            if (state != 16842919) continue;
            pressed = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(focused || enabled && pressed, focused);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private void setBackgroundActive(boolean active, boolean focused) {
        if (this.mBackgroundActive != active) {
            this.mBackgroundActive = active;
            if (active) {
                this.tryBackgroundEnter(focused);
            } else {
                this.tryBackgroundExit();
            }
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onBoundsChange();
        }
        if (this.mRipple != null) {
            this.mRipple.onBoundsChange();
        }
        this.invalidateSelf();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (this.mBackgroundActive) {
                this.tryBackgroundEnter(false);
            }
            this.jumpToCurrentState();
        }
        return changed;
    }

    private boolean isBounded() {
        return this.getNumberOfLayers() > 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public void setColor(ColorStateList color2) {
        this.mState.mColor = color2;
        this.invalidateSelf(false);
    }

    @Override
    public void setRadius(int radius) {
        this.mState.mMaxRadius = radius;
        this.invalidateSelf(false);
    }

    @Override
    public int getRadius() {
        return this.mState.mMaxRadius;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawableICS.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.setTargetDensity(r.getDisplayMetrics());
        this.updateLocalState();
    }

    @Override
    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        if (super.setDrawableByLayerId(id2, drawable2)) {
            if (id2 == R.id.carbon_mask) {
                this.mMask = drawable2;
                this.mHasValidMask = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private void updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        RippleState state = this.mState;
        state.mChangingConfigurations |= TypedArrayCompat.getChangingConfigurations(a);
        state.mTouchThemeAttrs = TypedArrayCompat.extractThemeAttrs(a);
        ColorStateList color2 = a.getColorStateList(R.styleable.RippleDrawable_android_color);
        if (color2 != null) {
            this.mState.mColor = color2;
        }
        this.mState.mMaxRadius = a.getDimensionPixelSize(R.styleable.RippleDrawable_android_radius, this.mState.mMaxRadius);
        this.verifyRequiredAttributes(a);
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[R.styleable.RippleDrawable_android_color] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    private void setTargetDensity(DisplayMetrics metrics) {
        if (this.mDensity != metrics.density) {
            this.mDensity = metrics.density;
            this.invalidateSelf(false);
        }
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null) {
            return;
        }
        this.updateLocalState();
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryBackgroundEnter(boolean focused) {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        this.mBackground.setup(this.mState.mMaxRadius, this.mDensity);
        this.mBackground.enter(focused);
    }

    private void tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            boolean isBounded = this.isBounded();
            this.mRipple = new RippleForeground(this, this.mHotspotBounds, x, y, isBounded);
        }
        this.mRipple.setup(this.mState.mMaxRadius, this.mDensity);
        this.mRipple.enter(false);
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new RippleForeground[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        if (this.mRipple != null) {
            this.mRipple.end();
            this.mRipple = null;
            this.mRippleActive = false;
        }
        if (this.mBackground != null) {
            this.mBackground.end();
            this.mBackground = null;
            this.mBackgroundActive = false;
        }
        this.cancelExitingRipples();
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    @Override
    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == R.id.carbon_mask) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        this.pruneRipples();
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save();
        canvas.clipRect(bounds);
        this.drawContent(canvas);
        this.drawBackgroundAndRipples(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void invalidateSelf() {
        this.invalidateSelf(true);
    }

    void invalidateSelf(boolean invalidateMask) {
        super.invalidateSelf();
        if (invalidateMask) {
            this.mHasValidMask = false;
        }
    }

    private void pruneRipples() {
        int i;
        int remaining = 0;
        RippleForeground[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (i = 0; i < count; ++i) {
            if (ripples[i].hasFinishedExit()) continue;
            ripples[remaining++] = ripples[i];
        }
        for (i = remaining; i < count; ++i) {
            ripples[i] = null;
        }
        this.mExitingRipplesCount = remaining;
    }

    private void updateMaskShaderIfNeeded() {
        if (this.mHasValidMask) {
            return;
        }
        int maskType = this.getMaskType();
        if (maskType == -1) {
            return;
        }
        this.mHasValidMask = true;
        Rect bounds = this.getBounds();
        if (maskType == 0 || bounds.isEmpty()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
                this.mMaskBuffer = null;
                this.mMaskShader = null;
                this.mMaskCanvas = null;
            }
            this.mMaskMatrix = null;
            this.mMaskColorFilter = null;
            return;
        }
        if (this.mMaskBuffer == null || this.mMaskBuffer.getWidth() != bounds.width() || this.mMaskBuffer.getHeight() != bounds.height()) {
            if (this.mMaskBuffer != null) {
                this.mMaskBuffer.recycle();
            }
            this.mMaskBuffer = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
            this.mMaskShader = new BitmapShader(this.mMaskBuffer, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mMaskCanvas = new Canvas(this.mMaskBuffer);
        } else {
            this.mMaskBuffer.eraseColor(0);
        }
        if (this.mMaskMatrix == null) {
            this.mMaskMatrix = new Matrix();
        } else {
            this.mMaskMatrix.reset();
        }
        if (this.mMaskColorFilter == null) {
            this.mMaskColorFilter = new PorterDuffColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        int left = bounds.left;
        int top = bounds.top;
        this.mMaskCanvas.translate((float)(-left), (float)(-top));
        if (maskType == 2) {
            this.drawMask(this.mMaskCanvas);
        } else if (maskType == 1) {
            this.drawContent(this.mMaskCanvas);
        }
        this.mMaskCanvas.translate((float)left, (float)top);
    }

    private int getMaskType() {
        if (!(this.mRipple != null || this.mExitingRipplesCount > 0 || this.mBackground != null && this.mBackground.isVisible())) {
            return -1;
        }
        if (this.mMask != null) {
            if (this.mMask.getOpacity() == -1) {
                return 0;
            }
            return 2;
        }
        LayerDrawable.ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        for (int i = 0; i < count; ++i) {
            if (array[i].mDrawable.getOpacity() == -1) continue;
            return 1;
        }
        return 0;
    }

    private void drawContent(Canvas canvas) {
        LayerDrawable.ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        for (int i = 0; i < count; ++i) {
            if (array[i].mId == R.id.carbon_mask) continue;
            array[i].mDrawable.draw(canvas);
        }
    }

    private void drawBackgroundAndRipples(Canvas canvas) {
        RippleForeground active = this.mRipple;
        RippleBackground background = this.mBackground;
        int count = this.mExitingRipplesCount;
        if (!(active != null || count > 0 || background != null && background.isVisible())) {
            return;
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        canvas.translate(x, y);
        this.updateMaskShaderIfNeeded();
        if (this.mMaskShader != null) {
            Rect bounds = this.getBounds();
            this.mMaskMatrix.setTranslate((float)bounds.left - x, (float)bounds.top - y);
            this.mMaskShader.setLocalMatrix(this.mMaskMatrix);
        }
        int color2 = this.mState.mColor.getColorForState(this.getState(), -16777216);
        int halfAlpha = Color.alpha((int)color2) / 2 << 24;
        Paint p = this.getRipplePaint();
        if (this.mMaskColorFilter != null) {
            int fullAlphaColor = color2 | 0xFF000000;
            DrawableReflectiveUtils.setColor(this.mMaskColorFilter, fullAlphaColor, PorterDuff.Mode.SRC_IN);
            p.setColor(halfAlpha);
            p.setColorFilter((ColorFilter)this.mMaskColorFilter);
            p.setShader((Shader)this.mMaskShader);
        } else {
            int halfAlphaColor = color2 & 0xFFFFFF | halfAlpha;
            p.setColor(halfAlphaColor);
            p.setColorFilter(null);
            p.setShader(null);
        }
        if (background != null && background.isVisible()) {
            background.draw(canvas, p);
        }
        if (count > 0) {
            RippleForeground[] ripples = this.mExitingRipples;
            for (int i = 0; i < count; ++i) {
                ripples[i].draw(canvas, p);
            }
        }
        if (active != null) {
            active.draw(canvas, p);
        }
        canvas.translate(-x, -y);
    }

    private void drawMask(Canvas canvas) {
        this.mMask.draw(canvas);
    }

    private Paint getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }
        return this.mRipplePaint;
    }

    public Rect getDirtyBounds() {
        if (!this.isBounded()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            RippleForeground[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            if (Build.VERSION.SDK_INT >= 21) {
                dirtyBounds.union(super.getDirtyBounds());
            }
            return dirtyBounds;
        }
        return this.getBounds();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        this.mMask = this.findDrawableByLayerId(R.id.carbon_mask);
        return this;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    private RippleDrawableICS(RippleState state, Resources res) {
        this.mState = new RippleState((LayerDrawable.LayerState)state, this, res);
        this.mLayerState = this.mState;
        if (this.mState.mNum > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
        if (res != null) {
            this.mDensity = res.getDisplayMetrics().density;
        }
        this.updateLocalState();
    }

    private void updateLocalState() {
        this.mMask = this.findDrawableByLayerId(R.id.carbon_mask);
    }

    @Override
    public Drawable getBackground() {
        return this.background;
    }

    @Override
    public RippleDrawable.Style getStyle() {
        return this.style;
    }

    @Override
    public boolean isHotspotEnabled() {
        return this.useHotspot;
    }

    @Override
    public void setHotspotEnabled(boolean useHotspot) {
        this.useHotspot = useHotspot;
    }

    @Override
    public ColorStateList getColor() {
        return this.mState.mColor;
    }

    @Override
    public int getAlpha() {
        return Carbon.getDrawableAlpha(this.background);
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        int[] mTouchThemeAttrs;
        ColorStateList mColor = ColorStateList.valueOf((int)-65281);
        int mMaxRadius = -1;

        public RippleState(LayerDrawable.LayerState orig, RippleDrawableICS owner, Resources res) {
            super(orig, owner, res);
            if (orig != null && orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
            }
        }

        @Override
        public Drawable newDrawable() {
            return new RippleDrawableICS(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new RippleDrawableICS(this, res);
        }
    }
}

