/*
 * Decompiled with CFR 0.152.
 */
package carbon.drawable.ripple;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import carbon.Carbon;
import carbon.drawable.ripple.LollipopDrawablesCompat;
import java.lang.reflect.Field;
import java.util.Arrays;

class TypedArrayCompat {
    private static final int[] TEMP_ARRAY = new int[1];
    private static final ITypedArray IMPL = Carbon.IS_LOLLIPOP_OR_HIGHER ? new TypedArrayLollipop() : new BaseTypedArray();
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DENSITY = 5;

    TypedArrayCompat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getColorStateList(Resources.Theme theme, TypedArray a, TypedValue[] values, int index) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    ColorStateList colorStateList = tmp.getColorStateList(0);
                    return colorStateList;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getColorStateList(index);
        }
        return null;
    }

    public static int getChangingConfigurations(TypedArray array) {
        return IMPL.getChangingConfigurations(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(Resources.Theme theme, TypedArray a, TypedValue[] values, int index) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    Drawable drawable2 = tmp.getDrawable(0);
                    return drawable2;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return LollipopDrawablesCompat.getDrawable(a, index, theme);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResourceId(Resources.Theme theme, TypedArray a, TypedValue[] values, int index, int def) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    int n = tmp.getResourceId(0, def);
                    return n;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getResourceId(index, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDimensionPixelOffset(Resources.Theme theme, TypedArray a, TypedValue[] values, int index, int def) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    int n = tmp.getDimensionPixelOffset(0, def);
                    return n;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getDimensionPixelOffset(index, def);
        }
        return def;
    }

    public static int[] extractThemeAttrs(TypedArray array) {
        Object scrap = null;
        int[] attrs = null;
        int[] mData = null;
        try {
            Field mDataField = array.getClass().getDeclaredField("mData");
            mDataField.setAccessible(true);
            mData = (int[])mDataField.get(array);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        int[] data = mData;
        int N = array.length();
        for (int i = 0; i < N; ++i) {
            int index = i * 6;
            if (data[index + 0] != 2) continue;
            data[index + 0] = 0;
            int attr2 = data[index + 1];
            if (attr2 == 0) continue;
            if (attrs == null) {
                if (scrap != null && (scrap).length == N) {
                    attrs = scrap;
                    Arrays.fill(attrs, 0);
                } else {
                    attrs = new int[N];
                }
            }
            attrs[i] = attr2;
        }
        return attrs;
    }

    @TargetApi(value=21)
    static class TypedArrayLollipop
    extends BaseTypedArray {
        TypedArrayLollipop() {
        }

        @Override
        public int getChangingConfigurations(TypedArray array) {
            return array.getChangingConfigurations();
        }
    }

    static class BaseTypedArray
    implements ITypedArray {
        BaseTypedArray() {
        }

        @Override
        public int getChangingConfigurations(TypedArray array) {
            return 0;
        }
    }

    static interface ITypedArray {
        public int getChangingConfigurations(TypedArray var1);
    }
}

