/*
 * Decompiled with CFR 0.152.
 */
package carbon.gesture;

import android.content.Context;
import android.os.Handler;
import android.view.MotionEvent;
import carbon.R;
import carbon.gesture.OnGestureListener;
import java.util.ArrayList;
import java.util.List;

public class GestureDetector {
    private static final int DEFAULT_PRESS_TIMEOUT = 100;
    private static final int DEFAULT_LONGPRESS_TIMEOUT = 200;
    private static final int DEFAULT_TAP_TIMEOUT = 300;
    private int pressTimeout = 100;
    private long longPressTimeout = 200L;
    private int tapTimeout = 300;
    private int moveEpsilon;
    private Handler handler = new Handler();
    private Runnable pressHandler;
    private Runnable longPressHandler;
    private Runnable tapHandler;
    private float prevTouchY;
    private float startTouchX;
    private float prevTouchX;
    private float startTouchY;
    private float prevCenterX;
    private float prevCenterY;
    private float prevDist;
    private float prevRotation;
    private boolean pressed;
    private int clicks = 0;
    private boolean moving;
    private boolean transforming = false;
    private List<OnGestureListener> listeners = new ArrayList<OnGestureListener>();

    public GestureDetector(Context context) {
        this.moveEpsilon = context.getResources().getDimensionPixelSize(R.dimen.carbon_moveEpsilon);
    }

    public void addOnGestureListener(OnGestureListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        this.listeners.add(listener);
    }

    public void removeOnGestureListener(OnGestureListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        this.listeners.remove(listener);
    }

    public void clearOnGestureListeners() {
        this.listeners.clear();
    }

    public boolean shouldInterceptEvents(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.moving = false;
                this.pressed = true;
                this.startTouchX = event.getX();
                this.startTouchY = event.getY();
                break;
            }
            case 2: {
                if (!this.pressed) break;
                if (!this.moving) {
                    float dy;
                    float dx = event.getX() - this.startTouchX;
                    if (!(Math.sqrt(dx * dx + (dy = event.getY() - this.startTouchY) * dy) > (double)this.moveEpsilon)) break;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent event = MotionEvent.obtain((MotionEvent)motionEvent);
        this.handler.removeCallbacks(this.longPressHandler);
        this.longPressHandler = null;
        if (motionEvent.getPointerCount() == 1) {
            this.transforming = false;
            this.handleSinglePointer(event);
        } else if (motionEvent.getPointerCount() == 2) {
            this.handleTwoPointers(event);
        }
        this.prevTouchX = motionEvent.getX();
        this.prevTouchY = motionEvent.getY();
        return this.moving;
    }

    private void handleSinglePointer(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.moving = false;
                this.pressed = true;
                this.startTouchX = event.getX();
                this.startTouchY = event.getY();
                ++this.clicks;
                this.handler.removeCallbacks(this.tapHandler);
                this.tapHandler = null;
                this.pressHandler = () -> this.firePressEvent(event);
                this.handler.postDelayed(this.pressHandler, (long)this.pressTimeout);
                this.longPressHandler = () -> this.fireLongPressEvent(event);
                this.handler.removeCallbacks(this.longPressHandler);
                this.handler.postDelayed(this.longPressHandler, this.longPressTimeout);
                break;
            }
            case 1: {
                if (this.pressed && this.pressHandler != null) {
                    this.handler.removeCallbacks(this.pressHandler);
                    this.pressHandler.run();
                }
                if (this.clicks > 0) {
                    this.fireTapEvent(event, this.clicks);
                    this.tapHandler = () -> {
                        this.tapHandler = null;
                        this.clicks = 0;
                    };
                    this.handler.postDelayed(this.tapHandler, (long)this.tapTimeout);
                }
                this.pressed = false;
                break;
            }
            case 2: {
                if (!this.pressed) break;
                if (!this.moving) {
                    float dy;
                    float dx = event.getX() - this.startTouchX;
                    if (!(Math.sqrt(dx * dx + (dy = event.getY() - this.startTouchY) * dy) > (double)this.moveEpsilon)) break;
                    this.handler.removeCallbacks(this.tapHandler);
                    this.tapHandler = null;
                    this.handler.removeCallbacks(this.pressHandler);
                    this.pressHandler = null;
                    this.handler.removeCallbacks(this.longPressHandler);
                    this.longPressHandler = null;
                    this.moving = true;
                    this.fireDragEvent(event, dx, dy);
                    break;
                }
                this.fireDragEvent(event, event.getX() - this.prevTouchX, event.getY() - this.prevTouchY);
                break;
            }
            case 3: {
                this.pressed = false;
                this.moving = false;
                this.handler.removeCallbacks(this.pressHandler);
                this.pressHandler = null;
                this.handler.removeCallbacks(this.tapHandler);
                this.tapHandler = null;
                this.handler.removeCallbacks(this.longPressHandler);
                this.longPressHandler = null;
                this.clicks = 0;
            }
        }
    }

    private void handleTwoPointers(MotionEvent event) {
        this.clicks = 0;
        switch (event.getActionMasked()) {
            case 0: 
            case 2: 
            case 5: 
            case 261: {
                if (!this.transforming) {
                    this.transforming = true;
                    this.handler.removeCallbacks(this.pressHandler);
                    this.pressHandler = null;
                    this.handler.removeCallbacks(this.longPressHandler);
                    this.longPressHandler = null;
                    this.handler.removeCallbacks(this.tapHandler);
                    this.tapHandler = null;
                    this.prevRotation = (float)Math.atan2(event.getY(0) - event.getY(1), event.getX(0) - event.getX(1));
                    this.prevDist = (float)Math.sqrt(Math.pow(event.getX(0) - event.getX(1), 2.0) + Math.pow(event.getY(0) - event.getY(1), 2.0));
                    this.prevCenterX = (event.getX(0) + event.getX(1)) / 2.0f;
                    this.prevCenterY = (event.getY(0) + event.getY(1)) / 2.0f;
                    break;
                }
                float dist = (float)Math.sqrt(Math.pow(event.getX(0) - event.getX(1), 2.0) + Math.pow(event.getY(0) - event.getY(1), 2.0));
                float cx = (event.getX(0) + event.getX(1)) / 2.0f;
                float cy = (event.getY(0) + event.getY(1)) / 2.0f;
                float dx = cx - this.prevCenterX;
                float dy = cy - this.prevCenterY;
                float rotation = (float)Math.atan2(event.getY(0) - event.getY(1), event.getX(0) - event.getX(1));
                float scale = dist / this.prevDist;
                float rx = rotation - this.prevRotation;
                this.fireTransformEvent(event, cx, cy, dx, dy, rx, scale);
                this.prevCenterX = cx;
                this.prevCenterY = cy;
                this.prevRotation = rotation;
                this.prevDist = dist;
            }
        }
    }

    private void fireTransformEvent(MotionEvent motionEvent, float cx, float cy, float dx, float dy, float rx, float scale) {
        for (OnGestureListener listener : this.listeners) {
            listener.onTransform(motionEvent, cx, cy, dx, dy, rx, scale);
        }
    }

    private void fireDragEvent(MotionEvent motionEvent, float translationX, float translationY) {
        this.clicks = 0;
        for (OnGestureListener listener : this.listeners) {
            listener.onDrag(motionEvent, translationX, translationY);
        }
    }

    private void fireTapEvent(MotionEvent motionEvent, int clicks) {
        this.tapHandler = null;
        for (OnGestureListener listener : this.listeners) {
            listener.onTap(motionEvent, clicks);
        }
    }

    private void fireLongPressEvent(MotionEvent motionEvent) {
        this.clicks = 0;
        this.longPressHandler = null;
        for (OnGestureListener listener : this.listeners) {
            listener.onLongPress(motionEvent);
        }
    }

    private void firePressEvent(MotionEvent motionEvent) {
        this.pressHandler = null;
        for (OnGestureListener listener : this.listeners) {
            listener.onPress(motionEvent);
        }
    }

    public int getPressTimeout() {
        return this.pressTimeout;
    }

    public void setPressTimeout(int pressTimeout) {
        this.pressTimeout = pressTimeout;
    }

    public long getLongPressTimeout() {
        return this.longPressTimeout;
    }

    public void setLongPressTimeout(long longPressTimeout) {
        this.longPressTimeout = longPressTimeout;
    }

    public int getTapTimeout() {
        return this.tapTimeout;
    }

    public void setTapTimeout(int tapTimeout) {
        this.tapTimeout = tapTimeout;
    }

    public int getMoveEpsilon() {
        return this.moveEpsilon;
    }

    public void setMoveEpsilon(int moveEpsilon) {
        this.moveEpsilon = moveEpsilon;
    }
}

