/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import carbon.R;
import java.util.ArrayList;
import java.util.List;

public class DebugOverlay
extends PopupWindow {
    private boolean drawBounds = true;
    private boolean drawMargins = true;
    private boolean drawPaddings = true;
    private boolean drawGrid = false;
    private boolean drawRulers = false;
    private boolean drawHitRects = true;
    private boolean drawTextSizes = false;
    private Activity context;
    private static SparseIntArray marginColors = new SparseIntArray();
    private static List<Integer> colors = new ArrayList<Integer>();
    private ViewTreeObserver.OnPreDrawListener listener = () -> {
        this.getContentView().postInvalidate();
        return true;
    };

    public DebugOverlay(Activity context) {
        super((Context)context);
        this.context = context;
        if (colors.isEmpty()) {
            colors.add(context.getResources().getColor(R.color.carbon_red_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_pink_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_purple_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_deepPurple_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_indigo_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_blue_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_lightBlue_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_cyan_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_teal_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_green_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_lightGreen_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_lime_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_yellow_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_amber_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_orange_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_deepOrange_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_brown_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_grey_400) & 0xFFFFFF | 0x7F000000);
            colors.add(context.getResources().getColor(R.color.carbon_blueGrey_400) & 0xFFFFFF | 0x7F000000);
        }
    }

    public void show() {
        View anchor = this.context.getWindow().getDecorView().getRootView();
        this.setContentView(new DebugLayout((Context)this.context, anchor));
        this.getContentView().setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -1));
        this.setBackgroundDrawable((Drawable)new ColorDrawable(this.context.getResources().getColor(17170445)));
        this.setTouchable(false);
        this.setFocusable(false);
        this.setOutsideTouchable(false);
        this.setAnimationStyle(0);
        super.showAtLocation(anchor, 0x800033, 0, 0);
        this.update(anchor.getWidth(), anchor.getHeight());
        anchor.getViewTreeObserver().addOnPreDrawListener(this.listener);
    }

    public void dismiss() {
        View anchor = this.context.getWindow().getDecorView().getRootView();
        anchor.getViewTreeObserver().removeOnPreDrawListener(this.listener);
        super.dismiss();
    }

    public boolean isDrawBoundsEnabled() {
        return this.drawBounds;
    }

    public void setDrawBoundsEnabled(boolean drawBounds) {
        this.drawBounds = drawBounds;
    }

    public boolean isDrawGridEnabled() {
        return this.drawGrid;
    }

    public void setDrawGridEnabled(boolean drawGrid) {
        this.drawGrid = drawGrid;
    }

    public boolean isDrawRulersEnabled() {
        return this.drawRulers;
    }

    public void setDrawRulersEnabled(boolean drawRulers) {
        this.drawRulers = drawRulers;
    }

    public boolean isDrawMarginsEnabled() {
        return this.drawMargins;
    }

    public void setDrawMarginsEnabled(boolean drawMargins) {
        this.drawMargins = drawMargins;
    }

    public boolean isDrawPaddingsEnabled() {
        return this.drawPaddings;
    }

    public void setDrawPaddingsEnabled(boolean drawPaddings) {
        this.drawPaddings = drawPaddings;
    }

    public boolean isDrawHitRectsEnabled() {
        return this.drawHitRects;
    }

    public void setDrawHitRectsEnabled(boolean drawHitRects) {
        this.drawHitRects = drawHitRects;
    }

    public boolean isDrawTextSizesEnabled() {
        return this.drawTextSizes;
    }

    public void setDrawTextSizesEnabled(boolean drawTextSizes) {
        this.drawTextSizes = drawTextSizes;
    }

    private int getColor(int index) {
        int color2 = marginColors.get(index);
        if (color2 == 0) {
            color2 = colors.get(marginColors.size() % colors.size());
        }
        marginColors.put(index, color2);
        return color2;
    }

    private class DebugLayout
    extends View {
        private final View view;
        Paint paint;
        Rect rect;
        Rect rect2;
        float step;
        private int[] location;
        float[] rulers;

        public DebugLayout(Context context, View view) {
            super(context);
            this.paint = new Paint(1);
            this.rect = new Rect();
            this.rect2 = new Rect();
            this.rulers = new float[5];
            this.view = view;
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Resources res = context.getResources();
            this.step = res.getDimension(R.dimen.carbon_grid8);
            this.rulers[0] = res.getDimension(R.dimen.carbon_windowPadding);
            this.rulers[1] = res.getDimension(R.dimen.carbon_windowPadding) + res.getDimension(R.dimen.carbon_iconSize);
            this.rulers[2] = res.getDimension(R.dimen.carbon_contentSpace) - res.getDimension(R.dimen.carbon_padding);
            this.rulers[3] = res.getDimension(R.dimen.carbon_contentSpace);
            this.rulers[4] = (float)wm.getDefaultDisplay().getWidth() - res.getDimension(R.dimen.carbon_windowPadding);
        }

        protected void dispatchDraw(@NonNull Canvas canvas) {
            this.location = new int[2];
            this.getLocationOnScreen(this.location);
            this.paint.setAlpha(255);
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(1.0f);
            if (DebugOverlay.this.drawGrid) {
                this.paint.setColor(0x1F000000);
                for (float x = this.step; x < (float)this.getWidth(); x += this.step) {
                    canvas.drawLine(x, 0.0f, x, (float)this.getHeight(), this.paint);
                }
                this.paint.setColor(0x3F000000);
                for (float y = this.step; y < (float)this.getHeight(); y += this.step) {
                    canvas.drawLine(0.0f, y, (float)this.getWidth(), y, this.paint);
                }
            }
            if (this.view instanceof ViewGroup) {
                this.drawViewGroup(canvas, (ViewGroup)this.view);
            } else {
                this.drawView(canvas, this.view);
            }
            if (DebugOverlay.this.drawRulers) {
                this.paint.setColor(0x7FFF00FF);
                for (float ruler : this.rulers) {
                    canvas.drawLine(ruler, 0.0f, ruler, (float)this.getHeight(), this.paint);
                }
                this.paint.setColor(0x3F00FFFF);
                this.paint.setStyle(Paint.Style.FILL);
                canvas.drawRect(0.0f, 0.0f, this.rulers[0], (float)this.getHeight(), this.paint);
                canvas.drawRect(this.rulers[2], 0.0f, this.rulers[3], (float)this.getHeight(), this.paint);
                canvas.drawRect(this.rulers[4], 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
            }
        }

        private void drawView(Canvas canvas, View v) {
            int[] l = new int[2];
            v.getLocationOnScreen(l);
            this.rect.set(0, 0, v.getWidth(), v.getHeight());
            this.rect.offset(l[0] - this.location[0], l[1] - this.location[1]);
            if (DebugOverlay.this.drawMargins) {
                this.drawMargins(canvas, v);
            }
            if (DebugOverlay.this.drawPaddings) {
                this.drawPaddings(canvas, v);
            }
            if (DebugOverlay.this.drawBounds) {
                this.drawBounds(canvas, v);
            }
            if (DebugOverlay.this.drawHitRects) {
                v.getHitRect(this.rect2);
                this.rect2.offset(l[0] - this.location[0] - v.getLeft(), l[1] - this.location[1] - v.getTop());
                if (!this.rect.equals((Object)this.rect2)) {
                    this.paint.setColor(0x7FFF0000);
                    canvas.drawRect(this.rect2, this.paint);
                }
            }
            if (DebugOverlay.this.drawTextSizes && v instanceof TextView) {
                TextView tv = (TextView)v;
                this.paint.setTextSize(12.0f);
                float textSize = tv.getTextSize() / this.getResources().getDisplayMetrics().scaledDensity;
                this.paint.setColor(-1);
                this.paint.setShadowLayer(2.0f, 0.0f, 0.0f, -16777216);
                canvas.drawText(textSize + "sp", (float)this.rect.left, (float)this.rect.top + this.paint.getTextSize(), this.paint);
            }
        }

        private void drawBounds(Canvas canvas, View v) {
            this.paint.setStyle(Paint.Style.STROKE);
            float vertLine = Math.min(this.step, (float)(v.getWidth() / 3));
            float horzLine = Math.min(this.step, (float)(v.getHeight() / 3));
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setColor(0x3F00FF00);
            canvas.drawRect(this.rect, this.paint);
            this.paint.setColor(0x7F00FF00);
            canvas.drawLine((float)this.rect.left, (float)this.rect.top, (float)this.rect.left + vertLine, (float)this.rect.top, this.paint);
            canvas.drawLine((float)this.rect.left, (float)this.rect.top, (float)this.rect.left, (float)this.rect.top + horzLine, this.paint);
            canvas.drawLine((float)this.rect.right, (float)this.rect.top, (float)this.rect.right - vertLine, (float)this.rect.top, this.paint);
            canvas.drawLine((float)this.rect.right, (float)this.rect.top, (float)this.rect.right, (float)this.rect.top + horzLine, this.paint);
            canvas.drawLine((float)this.rect.left, (float)this.rect.bottom, (float)this.rect.left + vertLine, (float)this.rect.bottom, this.paint);
            canvas.drawLine((float)this.rect.left, (float)this.rect.bottom, (float)this.rect.left, (float)this.rect.bottom - horzLine, this.paint);
            canvas.drawLine((float)this.rect.right, (float)this.rect.bottom, (float)this.rect.right - vertLine, (float)this.rect.bottom, this.paint);
            canvas.drawLine((float)this.rect.right, (float)this.rect.bottom, (float)this.rect.right, (float)this.rect.bottom - horzLine, this.paint);
        }

        private void drawPaddings(Canvas canvas, View v) {
            this.paint.setStyle(Paint.Style.FILL);
            if (v.getPaddingTop() > 0) {
                this.paint.setColor(DebugOverlay.this.getColor(v.getPaddingTop()));
                canvas.drawRect((float)this.rect.left, (float)(this.rect.top + v.getPaddingTop()), (float)this.rect.right, (float)this.rect.top, this.paint);
            }
            if (v.getPaddingBottom() > 0) {
                this.paint.setColor(DebugOverlay.this.getColor(v.getPaddingBottom()));
                canvas.drawRect((float)this.rect.left, (float)this.rect.bottom, (float)this.rect.right, (float)(this.rect.bottom - v.getPaddingBottom()), this.paint);
            }
            if (v.getPaddingLeft() > 0) {
                this.paint.setColor(DebugOverlay.this.getColor(v.getPaddingLeft()));
                canvas.drawRect((float)(this.rect.left + v.getPaddingLeft()), (float)this.rect.top, (float)this.rect.left, (float)this.rect.bottom, this.paint);
            }
            if (v.getPaddingRight() > 0) {
                this.paint.setColor(DebugOverlay.this.getColor(v.getPaddingRight()));
                canvas.drawRect((float)this.rect.right, (float)this.rect.top, (float)(this.rect.right - v.getPaddingRight()), (float)this.rect.bottom, this.paint);
            }
        }

        private void drawMargins(Canvas canvas, View v) {
            this.paint.setStyle(Paint.Style.FILL);
            ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLp = (ViewGroup.MarginLayoutParams)layoutParams;
                if (marginLp.topMargin > 0) {
                    this.paint.setColor(DebugOverlay.this.getColor(marginLp.topMargin));
                    canvas.drawRect((float)(this.rect.left - marginLp.leftMargin), (float)(this.rect.top - marginLp.topMargin), (float)(this.rect.right + marginLp.rightMargin), (float)this.rect.top, this.paint);
                }
                if (marginLp.bottomMargin > 0) {
                    this.paint.setColor(DebugOverlay.this.getColor(marginLp.bottomMargin));
                    canvas.drawRect((float)(this.rect.left - marginLp.leftMargin), (float)this.rect.bottom, (float)(this.rect.right + marginLp.rightMargin), (float)(this.rect.bottom + marginLp.bottomMargin), this.paint);
                }
                if (marginLp.leftMargin > 0) {
                    this.paint.setColor(DebugOverlay.this.getColor(marginLp.leftMargin));
                    canvas.drawRect((float)(this.rect.left - marginLp.leftMargin), (float)(this.rect.top - marginLp.topMargin), (float)this.rect.left, (float)(this.rect.bottom + marginLp.bottomMargin), this.paint);
                }
                if (marginLp.rightMargin > 0) {
                    this.paint.setColor(DebugOverlay.this.getColor(marginLp.rightMargin));
                    canvas.drawRect((float)this.rect.right, (float)(this.rect.top - marginLp.topMargin), (float)(this.rect.right + marginLp.rightMargin), (float)(this.rect.bottom + marginLp.bottomMargin), this.paint);
                }
            }
        }

        void drawViewGroup(Canvas canvas, ViewGroup viewGroup) {
            this.drawView(canvas, (View)viewGroup);
            canvas.save();
            int[] l = new int[2];
            viewGroup.getLocationOnScreen(l);
            this.rect.set(0, 0, viewGroup.getWidth(), viewGroup.getHeight());
            this.rect.offset(l[0] - this.location[0], l[1] - this.location[1]);
            canvas.clipRect(this.rect);
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View v = viewGroup.getChildAt(i);
                if (v instanceof ViewGroup) {
                    this.drawViewGroup(canvas, (ViewGroup)v);
                    continue;
                }
                this.drawView(canvas, v);
            }
            canvas.restore();
        }
    }
}

