/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import carbon.R;
import carbon.internal.MathUtils;
import carbon.recycler.ListAdapter;
import carbon.recycler.ViewItemDecoration;
import carbon.widget.DropDown;
import carbon.widget.FrameLayout;
import carbon.widget.RecyclerView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DropDownMenu
extends PopupWindow {
    protected RecyclerView recycler;
    private View anchorView;
    private DropDown.PopupMode popupMode;
    private ListAdapter defaultAdapter;
    private DropDown.Mode mode;
    private List<Integer> selectedIndices = new ArrayList<Integer>();
    private RecyclerView.OnItemClickedListener<Serializable> onItemClickedListener;
    private Serializable customItem;

    public DropDownMenu(Context context) {
        super(View.inflate((Context)context, (int)R.layout.carbon_dropdown_menu, null));
        this.getContentView().setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -1));
        this.recycler = (RecyclerView)this.getContentView().findViewById(R.id.recycler);
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.recycler.setOnKeyListener((v, keyCode, event) -> {
            if (event.getAction() == 1 && (keyCode == 82 || keyCode == 4)) {
                this.dismiss();
                return true;
            }
            return false;
        });
        ViewItemDecoration dividerItemDecoration = new ViewItemDecoration(context, R.layout.carbon_menustrip_hseparator_item);
        dividerItemDecoration.setDrawAfter(position -> this.getAdapter().getItem(position) == this.customItem);
        this.recycler.addItemDecoration(dividerItemDecoration);
        ViewItemDecoration paddingItemDecoration = new ViewItemDecoration(context, R.layout.carbon_row_padding);
        paddingItemDecoration.setDrawBefore(position -> position == 0);
        paddingItemDecoration.setDrawAfter(position -> position == this.recycler.getAdapter().getItemCount() - 1);
        this.recycler.addItemDecoration(paddingItemDecoration);
        this.defaultAdapter = new DropDown.Adapter();
        this.recycler.setAdapter(this.defaultAdapter);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(context.getResources().getColor(17170445)));
        this.setTouchable(true);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setAnimationStyle(0);
    }

    public boolean show(View anchor) {
        this.anchorView = anchor;
        super.showAtLocation(anchor, 0x800033, 0, 0);
        this.update();
        FrameLayout content = (FrameLayout)this.getContentView().findViewById(R.id.carbon_popupContainer);
        content.animateVisibility(0);
        return true;
    }

    public boolean showImmediate(View anchor) {
        this.anchorView = anchor;
        super.showAtLocation(anchor, 0x800033, 0, 0);
        this.update();
        FrameLayout content = (FrameLayout)this.getContentView().findViewById(R.id.carbon_popupContainer);
        content.setVisibility(0);
        return true;
    }

    public void update() {
        if (this.anchorView == null) {
            return;
        }
        this.setClippingEnabled(this.popupMode == DropDown.PopupMode.Fit);
        Resources res = this.getContentView().getContext().getResources();
        int margin = (int)res.getDimension(R.dimen.carbon_margin);
        int itemHeight = (int)res.getDimension(R.dimen.carbon_dropdownMenuItemHeight);
        int marginHalf = (int)res.getDimension(R.dimen.carbon_paddingHalf);
        int selectedItem = 0;
        ListAdapter<?, Serializable> adapter = this.getAdapter();
        if (this.anchorView instanceof TextView) {
            TextView textView = (TextView)this.anchorView;
            String text = textView.getText().toString();
            for (int i = 0; i < adapter.getItemCount(); ++i) {
                if (!adapter.getItem(i).toString().equals(text)) continue;
                selectedItem = i;
                break;
            }
        }
        Rect windowRect = new Rect();
        this.anchorView.getWindowVisibleDisplayFrame(windowRect);
        int hWindow = windowRect.bottom - windowRect.top;
        int wWindow = windowRect.right - windowRect.left;
        int[] location = new int[2];
        this.anchorView.getLocationInWindow(location);
        if (this.popupMode == DropDown.PopupMode.Over) {
            int maxHeightAbove = location[1] - windowRect.top - marginHalf * 2;
            int maxItemsAbove = maxHeightAbove / itemHeight;
            int maxHeightBelow = hWindow - location[1] - marginHalf * 2;
            int maxItemsBelow = Math.max(1, maxHeightBelow / itemHeight);
            int itemsBelow = Math.min(adapter.getItemCount() - selectedItem, maxItemsBelow);
            int itemsAbove = Math.min(selectedItem, maxItemsAbove);
            int popupX = location[0] - margin - marginHalf;
            int popupY = location[1] - marginHalf * 2 - itemsAbove * itemHeight - (itemHeight - (this.anchorView.getHeight() - this.anchorView.getPaddingTop() - this.anchorView.getPaddingBottom())) / 2 + this.anchorView.getPaddingTop();
            int popupWidth = this.anchorView.getWidth() + margin * 2 + marginHalf * 2 - this.anchorView.getPaddingLeft() - this.anchorView.getPaddingRight();
            int popupHeight = marginHalf * 4 + Math.max(1, itemsAbove + itemsBelow) * itemHeight;
            popupWidth = Math.min(popupWidth, wWindow - marginHalf * 2);
            if (popupX < 0) {
                popupWidth -= Math.min(-popupX, margin);
                popupX = 0;
            }
            if (popupX + popupWidth > wWindow) {
                int diff = popupX + popupWidth - wWindow;
                diff = Math.min(margin, diff);
                popupX = wWindow - (popupWidth -= diff);
            }
            popupY = MathUtils.constrain(popupY, 0, hWindow - popupHeight);
            LinearLayoutManager manager = (LinearLayoutManager)this.recycler.getLayoutManager();
            manager.scrollToPositionWithOffset(selectedItem - itemsAbove, 0);
            this.update(popupX, popupY, popupWidth, popupHeight);
        } else {
            int maxItems = (hWindow - marginHalf * 2 - margin * 2) / itemHeight;
            int popupX = location[0] - margin - marginHalf;
            int popupY = location[1] - marginHalf * 2 - (itemHeight - (this.anchorView.getHeight() - this.anchorView.getPaddingTop() - this.anchorView.getPaddingBottom())) / 2 + this.anchorView.getPaddingTop();
            int popupWidth = this.anchorView.getWidth() + margin * 2 + marginHalf * 2 - this.anchorView.getPaddingLeft() - this.anchorView.getPaddingRight();
            int popupHeight = marginHalf * 4 + Math.min(this.recycler.getAdapter().getItemCount(), maxItems) * itemHeight;
            LinearLayoutManager manager = (LinearLayoutManager)this.recycler.getLayoutManager();
            manager.scrollToPosition(selectedItem);
            this.update(popupX, popupY, popupWidth, popupHeight);
        }
        super.update();
    }

    public void dismiss() {
        FrameLayout content = (FrameLayout)this.getContentView().findViewById(R.id.carbon_popupContainer);
        content.animateVisibility(4).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DropDownMenu.super.dismiss();
            }
        });
    }

    public void dismissImmediate() {
        super.dismiss();
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<Serializable> listener) {
        this.onItemClickedListener = listener;
        this.getAdapter().setOnItemClickedListener(listener);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            this.recycler.setAdapter(this.defaultAdapter);
        } else {
            this.recycler.setAdapter(adapter);
        }
    }

    public ListAdapter<?, Serializable> getAdapter() {
        return (ListAdapter)this.recycler.getAdapter();
    }

    public void setSelectedIndex(int index) {
        this.selectedIndices.clear();
        this.selectedIndices.add(index);
    }

    public void setSelectedIndices(int[] indices) {
        this.selectedIndices.clear();
        for (int i : indices) {
            this.selectedIndices.add(i);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndices.isEmpty() ? -1 : this.selectedIndices.get(0);
    }

    public int[] getSelectedIndices() {
        int[] result = new int[this.selectedIndices.size()];
        for (int i = 0; i < this.selectedIndices.size(); ++i) {
            result[i] = this.selectedIndices.get(i);
        }
        return result;
    }

    public <Type extends Serializable> void setSelectedItems(List<Type> items) {
        List<Serializable> adapterItems = this.getAdapter().getItems();
        this.selectedIndices.clear();
        block0: for (Serializable item : items) {
            for (int i = 0; i < adapterItems.size(); ++i) {
                if (!adapterItems.get(i).equals(item)) continue;
                this.selectedIndices.add(i);
                continue block0;
            }
        }
    }

    public <Type extends Serializable> Type getSelectedItem() {
        return (Type)(this.selectedIndices.isEmpty() ? null : this.getAdapter().getItem(this.selectedIndices.get(0)));
    }

    public <Type extends Serializable> List<Type> getSelectedItems() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (int i : this.selectedIndices) {
            result.add(this.getAdapter().getItem(i));
        }
        return result;
    }

    public String getSelectedText() {
        if (this.selectedIndices.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(this.selectedIndices);
        for (int i : this.selectedIndices) {
            builder.append(this.getAdapter().getItem(i).toString());
            builder.append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public void toggle(int position) {
        if (this.selectedIndices.contains(position)) {
            this.selectedIndices.remove(this.selectedIndices.indexOf(position));
        } else {
            this.selectedIndices.add(position);
        }
        RecyclerView.ViewHolder viewHolder = this.recycler.findViewHolderForAdapterPosition(position);
        if (viewHolder instanceof Checkable) {
            ((Checkable)viewHolder).toggle();
        }
    }

    public DropDown.PopupMode getPopupMode() {
        return this.popupMode;
    }

    public void setPopupMode(DropDown.PopupMode popupMode) {
        this.popupMode = popupMode;
    }

    public DropDown.Mode getMode() {
        return this.mode;
    }

    public void setMode(@NonNull DropDown.Mode mode) {
        this.mode = mode;
        ListAdapter newAdapter = mode == DropDown.Mode.MultiSelect ? new DropDown.CheckableAdapter(this.selectedIndices) : new DropDown.Adapter();
        if (this.recycler.getAdapter() == this.defaultAdapter) {
            this.recycler.setAdapter(newAdapter);
        }
        this.defaultAdapter = newAdapter;
        newAdapter.setOnItemClickedListener(this.onItemClickedListener);
    }

    public <Type extends Serializable> void setCustomItem(Type item) {
        if (this.getAdapter().getItems().get(0) == this.customItem) {
            this.getAdapter().getItems().remove(0);
            this.getAdapter().notifyItemRemoved(0);
        }
        if (this.getAdapter().getItems().contains(item) || this.mode != DropDown.Mode.Editable) {
            return;
        }
        this.customItem = item;
        if (item != null) {
            this.getAdapter().getItems().add(0, this.customItem);
            this.getAdapter().notifyItemInserted(0);
        }
    }

    public <Type extends Serializable> void setItems(List<Type> items) {
        this.defaultAdapter.setItems(items);
        this.defaultAdapter.notifyDataSetChanged();
    }
}

