/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import carbon.R;
import carbon.widget.Button;
import carbon.widget.EditText;
import carbon.widget.LinearLayout;

public class EditTextMenu
extends PopupWindow {
    private EditText editText;

    public EditTextMenu(Context context) {
        super(LayoutInflater.from((Context)context).inflate(R.layout.carbon_editormenu, null, false));
        this.getContentView().setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-1, -1));
        this.setBackgroundDrawable((Drawable)new ColorDrawable(context.getResources().getColor(17170445)));
        this.setTouchable(true);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setAnimationStyle(0);
        this.setClippingEnabled(false);
    }

    public boolean show(EditText anchor) {
        this.editText = anchor;
        super.showAtLocation((View)anchor, 0x800033, 0, 0);
        this.update();
        View content = this.getContentView().findViewById(R.id.carbon_menuContainer);
        content.setVisibility(0);
        return true;
    }

    public boolean showImmediate(EditText anchor) {
        this.editText = anchor;
        super.showAtLocation((View)anchor, 0x800033, 0, 0);
        this.update();
        LinearLayout content = (LinearLayout)this.getContentView().findViewById(R.id.carbon_menuContainer);
        content.setVisibility(0);
        return true;
    }

    public void update() {
        if (this.editText == null) {
            return;
        }
        Resources res = this.getContentView().getContext().getResources();
        int margin = (int)res.getDimension(R.dimen.carbon_padding);
        int itemHeight = (int)res.getDimension(R.dimen.carbon_menuHeight);
        Rect windowRect = new Rect();
        this.editText.getWindowVisibleDisplayFrame(windowRect);
        int[] location = new int[2];
        this.editText.getLocationInWindow(location);
        LinearLayout content = (LinearLayout)this.getContentView().findViewById(R.id.carbon_menuContent);
        content.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)itemHeight, (int)0x40000000));
        int popupX = location[0] - margin;
        int popupY = location[1] - margin * 2 - content.getMeasuredHeight();
        this.update(popupX, popupY, content.getMeasuredWidth() + margin * 2, content.getMeasuredHeight() + margin * 2);
        super.update();
    }

    public void dismiss() {
        LinearLayout content = (LinearLayout)this.getContentView().findViewById(R.id.carbon_menuContainer);
        content.setVisibility(4);
        content.getAnimator().addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                EditTextMenu.super.dismiss();
            }
        });
    }

    public void dismissImmediate() {
        super.dismiss();
    }

    public boolean hasVisibleItems() {
        View cut = this.getContentView().findViewById(R.id.carbon_cut);
        View copy = this.getContentView().findViewById(R.id.carbon_copy);
        View paste = this.getContentView().findViewById(R.id.carbon_paste);
        View selectAll = this.getContentView().findViewById(R.id.carbon_selectAll);
        return cut.getVisibility() == 0 || copy.getVisibility() == 0 || paste.getVisibility() == 0 || selectAll.getVisibility() == 0;
    }

    public void initCopy(MenuItem item) {
        Button button = (Button)this.getContentView().findViewById(R.id.carbon_copy);
        this.initMenuItem(item, button);
    }

    public void initCut(MenuItem item) {
        Button button = (Button)this.getContentView().findViewById(R.id.carbon_cut);
        this.initMenuItem(item, button);
    }

    public void initPaste(MenuItem item) {
        Button button = (Button)this.getContentView().findViewById(R.id.carbon_paste);
        this.initMenuItem(item, button);
    }

    public void initSelectAll(MenuItem item) {
        Button button = (Button)this.getContentView().findViewById(R.id.carbon_selectAll);
        this.initMenuItem(item, button);
    }

    private void initMenuItem(final MenuItem item, Button button) {
        if (item != null) {
            button.setText(item.getTitle());
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    EditTextMenu.this.editText.onTextContextMenuItem(item.getItemId());
                    EditTextMenu.this.dismiss();
                }
            });
            button.setVisibility(0);
        } else {
            button.setVisibility(8);
        }
    }
}

