/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;

public class NURBS {
    private int degree = 2;
    private float[] knots = null;
    private List<PointF> points = new ArrayList<PointF>();

    private float deBoor(int i, int k, float t) {
        if (k == 1) {
            if (this.knots[i] <= t && t < this.knots[i + 1]) {
                return 1.0f;
            }
            return 0.0f;
        }
        float b1 = this.deBoor(i, k - 1, t);
        float dt = this.knots[i + k - 1] - this.knots[i];
        b1 = (double)dt > 1.0E-5 ? (b1 /= dt) : 0.0f;
        float b2 = this.deBoor(i + 1, k - 1, t);
        dt = this.knots[i + k] - this.knots[i + 1];
        b2 = (double)dt > 1.0E-6 ? (b2 /= dt) : 0.0f;
        return (t - this.knots[i]) * b1 + (this.knots[i + k] - t) * b2;
    }

    public void init() {
        this.knots = new float[this.points.size() + this.degree + 1];
        float div = 0.0f;
        int d = this.points.size() - (this.degree + 1);
        float w = 0.0f;
        if (d != 0) {
            div = (float)d + 1.0f;
        }
        for (int i = 0; i < this.points.size() + this.degree + 1; ++i) {
            if (i > this.degree && i < this.points.size() + 1) {
                w += 1.0f;
            }
            this.knots[i] = d != 0 ? w / div : w;
        }
    }

    public void addPoint(PointF p) {
        this.points.add(p);
    }

    public PointF getPoint(float t) {
        if (this.degree > this.points.size()) {
            throw new IllegalStateException("degree >= points.size()");
        }
        if (t == 0.0f) {
            return new PointF(this.points.get((int)0).x, this.points.get((int)0).y);
        }
        if (t == 1.0f) {
            return new PointF(this.points.get((int)(this.points.size() - 1)).x, this.points.get((int)(this.points.size() - 1)).y);
        }
        PointF rt = new PointF();
        for (int i = 0; i < this.points.size(); ++i) {
            float ww = this.deBoor(i, this.degree + 1, t);
            rt.x += this.points.get((int)i).x * ww;
            rt.y += this.points.get((int)i).y * ww;
        }
        return rt;
    }
}

