/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Typeface;
import android.os.Handler;
import android.util.Log;
import android.util.TypedValue;
import androidx.annotation.FontRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.util.Preconditions;
import carbon.internal.TypefaceCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourcesCompat {
    private static final String TAG = "ResourcesCompat";

    @Nullable
    public static Typeface getFont(@NonNull Context context, @FontRes int id2) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, id2, new TypedValue(), 0, 400, null, null, false);
    }

    public static void getFont(@NonNull Context context, @FontRes int id2, @NonNull ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler) throws Resources.NotFoundException {
        Preconditions.checkNotNull((Object)fontCallback);
        if (context.isRestricted()) {
            fontCallback.callbackFailAsync(-4, handler);
            return;
        }
        ResourcesCompat.loadFont(context, id2, new TypedValue(), 0, 400, fontCallback, handler, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface getFont(@NonNull Context context, @FontRes int id2, TypedValue value, int style2, int weight, @Nullable ResourcesCompat.FontCallback fontCallback) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, id2, value, style2, weight, fontCallback, null, true);
    }

    private static Typeface loadFont(@NonNull Context context, int id2, TypedValue value, int style2, int weight, @Nullable ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator) {
        Resources resources = context.getResources();
        resources.getValue(id2, value, true);
        Typeface typeface = ResourcesCompat.loadFont(context, resources, value, id2, style2, weight, fontCallback, handler, isRequestFromLayoutInflator);
        if (typeface == null && fontCallback == null) {
            throw new Resources.NotFoundException("Font resource ID #0x" + Integer.toHexString(id2) + " could not be retrieved.");
        }
        return typeface;
    }

    private static Typeface loadFont(@NonNull Context context, Resources wrapper, TypedValue value, int id2, int style2, int weight, @Nullable ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator) {
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + wrapper.getResourceName(id2) + "\" (" + Integer.toHexString(id2) + ") is not a Font: " + value);
        }
        String file = value.string.toString();
        if (!file.startsWith("res/")) {
            if (fontCallback != null) {
                fontCallback.callbackFailAsync(-3, handler);
            }
            return null;
        }
        Typeface typeface = TypefaceCompat.findFromCache(wrapper, id2, (style2 & 2) != 0, weight);
        if (typeface != null) {
            if (fontCallback != null) {
                fontCallback.callbackSuccessAsync(typeface, handler);
            }
            return typeface;
        }
        try {
            if (file.toLowerCase().endsWith(".xml")) {
                XmlResourceParser rp = wrapper.getXml(id2);
                FontResourcesParserCompat.FamilyResourceEntry familyEntry = FontResourcesParserCompat.parse((XmlPullParser)rp, (Resources)wrapper);
                if (familyEntry == null) {
                    Log.e((String)TAG, (String)"Failed to find font-family tag");
                    if (fontCallback != null) {
                        fontCallback.callbackFailAsync(-3, handler);
                    }
                    return null;
                }
                return TypefaceCompat.createFromResourcesFamilyXml(context, familyEntry, wrapper, id2, style2, weight, fontCallback, handler, isRequestFromLayoutInflator);
            }
            typeface = TypefaceCompat.createFromResourcesFontFile(context, wrapper, id2, file, (style2 & 2) != 0, weight);
            if (fontCallback != null) {
                if (typeface != null) {
                    fontCallback.callbackSuccessAsync(typeface, handler);
                } else {
                    fontCallback.callbackFailAsync(-3, handler);
                }
            }
            return typeface;
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)("Failed to parse xml resource " + file), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Failed to read xml resource " + file), (Throwable)e);
        }
        if (fontCallback != null) {
            fontCallback.callbackFailAsync(-3, handler);
        }
        return null;
    }

    private ResourcesCompat() {
    }
}

