/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableString;
import carbon.widget.SearchEditText;

public class SearchHelper {
    private SearchHelper() {
    }

    public static Spannable highlightMatchedChars(String text, String query, SearchEditText.MatchMode matchMode, ParcelableSpan span) {
        SpannableString string = new SpannableString((CharSequence)text);
        if (matchMode == SearchEditText.MatchMode.START || matchMode == SearchEditText.MatchMode.ADJACENT) {
            int index = text.indexOf(query);
            if (index != -1) {
                string.setSpan((Object)span, index, index + query.length(), 17);
            }
        } else if (matchMode == SearchEditText.MatchMode.NONADJACENT) {
            int j = 0;
            for (int i = 0; i < text.length() && j < query.length(); ++i) {
                if (text.charAt(i) != query.charAt(j)) continue;
                string.setSpan((Object)span, i, i + 1, 17);
                ++j;
            }
        }
        return string;
    }

    public static boolean nonadjacentMatch(String text, String query) {
        int j = 0;
        for (int i = 0; i < text.length() && j < query.length(); ++i) {
            if (text.charAt(i) != query.charAt(j)) continue;
            ++j;
        }
        return j == query.length();
    }
}

