/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import carbon.R;
import carbon.widget.FrameLayout;
import carbon.widget.TextView;

public class SeekBarPopup
extends PopupWindow {
    private final Context context;
    private final View contentView = this.getContentView();
    private FrameLayout bubble;
    private TextView label = (TextView)this.contentView.findViewById(R.id.carbon_label);

    public SeekBarPopup(Context context) {
        super(LayoutInflater.from((Context)context).inflate(R.layout.carbon_seekbar_bubble, null, false));
        this.bubble = (FrameLayout)this.contentView.findViewById(R.id.carbon_bubble);
        this.context = context;
        this.setBackgroundDrawable((Drawable)new ColorDrawable(context.getResources().getColor(17170445)));
        this.setTouchable(false);
        this.setFocusable(false);
        this.setOutsideTouchable(false);
        this.setAnimationStyle(0);
        this.setClippingEnabled(false);
    }

    public void update(int x, int y) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        super.update(0, y, wm.getDefaultDisplay().getWidth(), this.contentView.getMeasuredHeight());
        this.bubble.setTranslationX(x);
    }

    public boolean show(View anchor) {
        super.showAtLocation(anchor, 0x800033, 0, 0);
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        this.contentView.measure(View.MeasureSpec.makeMeasureSpec((int)wm.getDefaultDisplay().getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        super.update(wm.getDefaultDisplay().getWidth(), this.contentView.getMeasuredHeight());
        this.bubble.animateVisibility(0);
        return true;
    }

    public boolean showImmediate(View anchor) {
        super.showAtLocation(anchor, 0x800033, 0, 0);
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        this.contentView.measure(View.MeasureSpec.makeMeasureSpec((int)wm.getDefaultDisplay().getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        super.update(wm.getDefaultDisplay().getWidth(), this.contentView.getMeasuredHeight());
        this.bubble.setVisibility(0);
        return true;
    }

    public void dismiss() {
        this.bubble.animateVisibility(4);
        Animator animator = this.bubble.getAnimator();
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    SeekBarPopup.super.dismiss();
                }
            });
        }
    }

    public void dismissImmediate() {
        super.dismiss();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public int getBubbleWidth() {
        return this.bubble.getMeasuredWidth();
    }
}

