/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.LruCache;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import carbon.internal.TypefaceCompatBaseImpl;

public class TypefaceCompat {
    private static final TypefaceCompatBaseImpl sTypefaceCompatImpl = new TypefaceCompatBaseImpl();
    private static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);

    private TypefaceCompat() {
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface findFromCache(@NonNull Resources resources, int id2, boolean italic, int fontWeight) {
        return (Typeface)sTypefaceCache.get((Object)TypefaceCompat.createResourceUid(resources, id2, italic, fontWeight));
    }

    private static String createResourceUid(Resources resources, int id2, boolean italic, int fontWeight) {
        return resources.getResourcePackageName(id2) + "-" + id2 + "-" + italic + "-" + fontWeight;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromResourcesFamilyXml(@NonNull Context context, @NonNull FontResourcesParserCompat.FamilyResourceEntry entry, @NonNull Resources resources, int id2, int style, int weight, @Nullable ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator) {
        Typeface typeface;
        if (entry instanceof FontResourcesParserCompat.ProviderResourceEntry) {
            FontResourcesParserCompat.ProviderResourceEntry providerEntry = (FontResourcesParserCompat.ProviderResourceEntry)entry;
            boolean isBlocking = isRequestFromLayoutInflator ? providerEntry.getFetchStrategy() == 0 : fontCallback == null;
            int timeout = isRequestFromLayoutInflator ? providerEntry.getTimeout() : -1;
            typeface = FontsContractCompat.getFontSync((Context)context, (FontRequest)providerEntry.getRequest(), (ResourcesCompat.FontCallback)fontCallback, (Handler)handler, (boolean)isBlocking, (int)timeout, (int)style);
        } else {
            typeface = sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry(context, (FontResourcesParserCompat.FontFamilyFilesResourceEntry)entry, resources, (style & 2) != 0, weight);
            if (fontCallback != null) {
                if (typeface != null) {
                    fontCallback.callbackSuccessAsync(typeface, handler);
                } else {
                    fontCallback.callbackFailAsync(-3, handler);
                }
            }
        }
        if (typeface != null) {
            sTypefaceCache.put((Object)TypefaceCompat.createResourceUid(resources, id2, (style & 2) != 0, weight), (Object)typeface);
        }
        return typeface;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromResourcesFontFile(@NonNull Context context, @NonNull Resources resources, int id2, String path, boolean italic, int weight) {
        Typeface typeface = sTypefaceCompatImpl.createFromResourcesFontFile(context, resources, id2, path, 0);
        if (typeface != null) {
            String resourceUid = TypefaceCompat.createResourceUid(resources, id2, italic, weight);
            sTypefaceCache.put((Object)resourceUid, (Object)typeface);
        }
        return typeface;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromFontInfo(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, boolean italic, int weight) {
        return sTypefaceCompatImpl.createFromFontInfo(context, cancellationSignal, fonts, italic, weight);
    }

    @Nullable
    private static Typeface getBestFontFromFamily(Context context, Typeface typeface, boolean italic, int weight) {
        FontResourcesParserCompat.FontFamilyFilesResourceEntry families = sTypefaceCompatImpl.getFontFamily(typeface);
        if (families == null) {
            return null;
        }
        return sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry(context, families, context.getResources(), italic, weight);
    }

    @NonNull
    public static Typeface create(@NonNull Context context, @Nullable Typeface family, int style, int weight) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        Typeface typefaceFromFamily = null;
        if (Build.VERSION.SDK_INT < 21 && (typefaceFromFamily = TypefaceCompat.getBestFontFromFamily(context, family, (style & 2) != 0, weight)) != null) {
            return typefaceFromFamily;
        }
        return Typeface.create((Typeface)family, (int)style);
    }
}

