/*
 * Decompiled with CFR 0.152.
 */
package carbon.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.CancellationSignal;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.graphics.TypefaceCompatUtil;
import androidx.core.provider.FontsContractCompat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
class TypefaceCompatBaseImpl {
    private static final String TAG = "TypefaceCompatBaseImpl";
    private static final int INVALID_KEY = 0;
    private ConcurrentHashMap<Long, FontResourcesParserCompat.FontFamilyFilesResourceEntry> mFontFamilies = new ConcurrentHashMap();

    TypefaceCompatBaseImpl() {
    }

    private static <T> T findBestFont(T[] fonts, boolean isTargetItalic, int targetWeight, StyleExtractor<T> extractor) {
        T best = null;
        int bestScore = Integer.MAX_VALUE;
        for (T font : fonts) {
            int score = Math.abs(extractor.getWeight(font) - targetWeight) * 2 + (extractor.isItalic(font) == isTargetItalic ? 0 : 1);
            if (best != null && bestScore <= score) continue;
            best = font;
            bestScore = score;
        }
        return best;
    }

    private static long getUniqueKey(@Nullable Typeface typeface) {
        if (typeface == null) {
            return 0L;
        }
        try {
            Field field = Typeface.class.getDeclaredField("native_instance");
            field.setAccessible(true);
            Number num = (Number)field.get(typeface);
            return num.longValue();
        }
        catch (NoSuchFieldException e) {
            Log.e((String)TAG, (String)"Could not retrieve font from family.", (Throwable)e);
            return 0L;
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Could not retrieve font from family.", (Throwable)e);
            return 0L;
        }
    }

    protected FontsContractCompat.FontInfo findBestInfo(FontsContractCompat.FontInfo[] fonts, boolean isTargetItalic, int targetWeight) {
        return TypefaceCompatBaseImpl.findBestFont(fonts, isTargetItalic, targetWeight, new StyleExtractor<FontsContractCompat.FontInfo>(){

            @Override
            public int getWeight(FontsContractCompat.FontInfo info) {
                return info.getWeight();
            }

            @Override
            public boolean isItalic(FontsContractCompat.FontInfo info) {
                return info.isItalic();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Typeface createFromInputStream(Context context, InputStream is) {
        File tmpFile = TypefaceCompatUtil.getTempFile((Context)context);
        if (tmpFile == null) {
            return null;
        }
        try {
            if (!TypefaceCompatUtil.copyToFile((File)tmpFile, (InputStream)is)) {
                Typeface typeface = null;
                return typeface;
            }
            Typeface typeface = Typeface.createFromFile((String)tmpFile.getPath());
            return typeface;
        }
        catch (RuntimeException e) {
            Typeface typeface = null;
            return typeface;
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Typeface createFromFontInfo(Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, boolean isTargetItalic, int targetWeight) {
        Typeface typeface;
        if (fonts.length < 1) {
            return null;
        }
        FontsContractCompat.FontInfo font = this.findBestInfo(fonts, isTargetItalic, targetWeight);
        InputStream is = null;
        try {
            is = context.getContentResolver().openInputStream(font.getUri());
            typeface = this.createFromInputStream(context, is);
        }
        catch (IOException e) {
            Typeface typeface2;
            try {
                typeface2 = null;
            }
            catch (Throwable throwable) {
                TypefaceCompatUtil.closeQuietly(is);
                throw throwable;
            }
            TypefaceCompatUtil.closeQuietly((Closeable)is);
            return typeface2;
        }
        TypefaceCompatUtil.closeQuietly((Closeable)is);
        return typeface;
    }

    private FontResourcesParserCompat.FontFileResourceEntry findBestEntry(FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, boolean isTargetItalic, int targetWeight) {
        return TypefaceCompatBaseImpl.findBestFont(entry.getEntries(), isTargetItalic, targetWeight, new StyleExtractor<FontResourcesParserCompat.FontFileResourceEntry>(){

            @Override
            public int getWeight(FontResourcesParserCompat.FontFileResourceEntry entry) {
                return entry.getWeight();
            }

            @Override
            public boolean isItalic(FontResourcesParserCompat.FontFileResourceEntry entry) {
                return entry.isItalic();
            }
        });
    }

    @Nullable
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, boolean isTargetItalic, int targetWeight) {
        FontResourcesParserCompat.FontFileResourceEntry best = this.findBestEntry(entry, isTargetItalic, targetWeight);
        if (best == null) {
            return null;
        }
        Typeface typeface = TypefaceCompat.createFromResourcesFontFile((Context)context, (Resources)resources, (int)best.getResourceId(), (String)best.getFileName(), (int)0);
        this.addFontFamily(typeface, entry);
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Typeface createFromResourcesFontFile(Context context, Resources resources, int id2, String path, int style2) {
        File tmpFile = TypefaceCompatUtil.getTempFile((Context)context);
        if (tmpFile == null) {
            return null;
        }
        try {
            if (!TypefaceCompatUtil.copyToFile((File)tmpFile, (Resources)resources, (int)id2)) {
                Typeface typeface = null;
                return typeface;
            }
            Typeface typeface = Typeface.createFromFile((String)tmpFile.getPath());
            return typeface;
        }
        catch (RuntimeException e) {
            Typeface typeface = null;
            return typeface;
        }
        finally {
            tmpFile.delete();
        }
    }

    @Nullable
    FontResourcesParserCompat.FontFamilyFilesResourceEntry getFontFamily(Typeface typeface) {
        long key = TypefaceCompatBaseImpl.getUniqueKey(typeface);
        if (key == 0L) {
            return null;
        }
        return this.mFontFamilies.get(key);
    }

    private void addFontFamily(Typeface typeface, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry) {
        long key = TypefaceCompatBaseImpl.getUniqueKey(typeface);
        if (key != 0L) {
            this.mFontFamilies.put(key, entry);
        }
    }

    private static interface StyleExtractor<T> {
        public int getWeight(T var1);

        public boolean isItalic(T var1);
    }
}

