/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import carbon.R;
import carbon.drawable.ColorStateListDrawable;
import carbon.drawable.ColorStateListFactory;
import org.jetbrains.annotations.NotNull;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable drawable;
    private int height;
    private DrawRules drawBeforeRules;
    private DrawRules drawAfterRules;

    public DividerItemDecoration(Context context) {
        this.drawable = new ColorStateListDrawable(ColorStateListFactory.INSTANCE.makeControl(context));
        this.height = context.getResources().getDimensionPixelSize(R.dimen.carbon_dividerHeight);
    }

    public DividerItemDecoration(Drawable drawable2, int height) {
        this.drawable = drawable2;
        this.height = height;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.drawable == null) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        if (position == -1) {
            return;
        }
        if (this.drawAfterRules != null && this.drawAfterRules.draw(position)) {
            if (this.getOrientation(parent) == 1) {
                outRect.bottom = this.height;
            } else {
                outRect.right = this.height;
            }
        }
        if (this.drawBeforeRules != null && this.drawBeforeRules.draw(position) || this.drawAfterRules == null && this.drawBeforeRules == null && position > 0) {
            if (this.getOrientation(parent) == 1) {
                outRect.top = this.height;
            } else {
                outRect.left = this.height;
            }
        }
    }

    public void onDrawOver(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        if (this.drawable == null) {
            super.onDrawOver(c, parent, state);
            return;
        }
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int orientation = this.getOrientation(parent);
        int childCount = parent.getChildCount();
        if (orientation == 1) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
        } else {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
        }
        for (int i = 0; i < childCount; ++i) {
            View child;
            int position = parent.getChildAdapterPosition(parent.getChildAt(i));
            if (position == -1) continue;
            if (this.drawAfterRules != null && this.drawAfterRules.draw(position)) {
                child = parent.getChildAt(i);
                if (orientation == 1) {
                    top = (int)((float)child.getBottom() + child.getTranslationY());
                    bottom = top + this.height;
                } else {
                    left = (int)((float)child.getRight() + child.getTranslationX());
                    right = left + this.height;
                }
                c.save();
                c.clipRect(left, top, right, bottom);
                this.drawable.setAlpha((int)(child.getAlpha() * 255.0f));
                this.drawable.setBounds(left, top, right, bottom);
                this.drawable.draw(c);
                c.restore();
            }
            if ((this.drawBeforeRules == null || !this.drawBeforeRules.draw(position)) && (this.drawAfterRules != null || this.drawBeforeRules != null || position <= 0)) continue;
            child = parent.getChildAt(i);
            if (orientation == 1) {
                bottom = (int)((float)child.getTop() + child.getTranslationY());
                top = bottom - this.height;
            } else {
                right = (int)((float)child.getLeft() + child.getTranslationX());
                left = right - this.height;
            }
            c.save();
            c.clipRect(left, top, right, bottom);
            this.drawable.setAlpha((int)(child.getAlpha() * 255.0f));
            this.drawable.setBounds(left, top, right, bottom);
            this.drawable.draw(c);
            c.restore();
        }
    }

    private int getOrientation(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            return layoutManager.getOrientation();
        }
        throw new IllegalStateException("DividerItemDecoration can only be used with a LinearLayoutManager.");
    }

    public void setDrawAfter(DrawRules drawRules) {
        this.drawAfterRules = drawRules;
    }

    public void setDrawBefore(DrawRules drawRules) {
        this.drawBeforeRules = drawRules;
    }

    public static interface DrawRules {
        public boolean draw(int var1);
    }
}

