/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import carbon.recycler.Adapter;
import carbon.recycler.ItemTouchHelper;
import java.util.HashMap;

public class DragTouchHelper<T>
extends ItemTouchHelper.SimpleCallback {
    private final ItemTouchHelper itemTouchHelper;
    private RecyclerView recycler;
    private Adapter<?, T> adapter;
    private OnItemMovedListener<T> onItemMovedListener;
    private HashMap<Class<? extends T>, OnItemMovedListener<? extends T>> onItemMovedListeners = new HashMap();

    public DragTouchHelper(RecyclerView recycler, Adapter<?, T> adapter) {
        super(0, 0);
        this.recycler = recycler;
        this.adapter = adapter;
        this.itemTouchHelper = new ItemTouchHelper(this);
        this.itemTouchHelper.attachToRecyclerView(recycler);
    }

    public void setOnItemMovedListener(OnItemMovedListener<T> onItemMovedListener) {
        this.onItemMovedListener = onItemMovedListener;
    }

    public <ItemType extends T> void setOnItemMovedListener(Class<ItemType> type, OnItemMovedListener<ItemType> onItemMovedListener) {
        this.onItemMovedListeners.put(type, onItemMovedListener);
    }

    @Override
    public int getDragDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        Object item = this.adapter.getItem(viewHolder.getAdapterPosition());
        if (this.onItemMovedListener != null || item != null && this.onItemMovedListeners.containsKey(item.getClass())) {
            return 3;
        }
        return super.getDragDirs(recyclerView, viewHolder);
    }

    @Override
    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        OnItemMovedListener<T> onItemMovedListener;
        Object item = this.adapter.getItem(viewHolder.getAdapterPosition());
        if (item != null && (onItemMovedListener = this.onItemMovedListeners.get(item.getClass())) != null) {
            return onItemMovedListener.onItemMoved(item, viewHolder.getAdapterPosition(), target.getAdapterPosition());
        }
        if (this.onItemMovedListener != null) {
            return this.onItemMovedListener.onItemMoved(this.adapter.getItem(viewHolder.getAdapterPosition()), viewHolder.getAdapterPosition(), target.getAdapterPosition());
        }
        return false;
    }

    @Override
    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
    }

    public void startDrag(View view) {
        this.itemTouchHelper.startDrag(this.recycler.findContainingViewHolder(view));
    }

    public static interface OnItemMovedListener<Type> {
        public boolean onItemMoved(Type var1, int var2, int var3);
    }
}

