/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.graphics.Canvas;
import android.view.View;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.ItemTouchUIUtil;
import androidx.recyclerview.widget.RecyclerView;
import carbon.R;
import carbon.view.ShadowView;

class ItemTouchUIUtilImpl {
    ItemTouchUIUtilImpl() {
    }

    static class BaseImpl
    implements ItemTouchUIUtil {
        BaseImpl() {
        }

        public void clearView(View view) {
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
        }

        public void onSelected(View view) {
        }

        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            view.setTranslationX(dX);
            view.setTranslationY(dY);
        }

        public void onDrawOver(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        }
    }

    static class Carbon
    extends BaseImpl {
        Carbon() {
        }

        @Override
        public void onDraw(Canvas c, RecyclerView recyclerView, View view, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            Object originalElevation;
            if (isCurrentlyActive && (originalElevation = view.getTag(R.id.item_touch_helper_previous_elevation)) == null) {
                originalElevation = Float.valueOf(view instanceof ShadowView ? ((ShadowView)view).getElevation() : ViewCompat.getElevation((View)view));
                float newElevation = 1.0f + this.findMaxElevation(recyclerView, view);
                if (view instanceof ShadowView) {
                    ((ShadowView)view).setElevation(newElevation);
                } else {
                    ViewCompat.setElevation((View)view, (float)newElevation);
                }
                view.setTag(R.id.item_touch_helper_previous_elevation, originalElevation);
            }
            super.onDraw(c, recyclerView, view, dX, dY, actionState, isCurrentlyActive);
        }

        private float findMaxElevation(RecyclerView recyclerView, View itemView) {
            int childCount = recyclerView.getChildCount();
            float max = 0.0f;
            for (int i = 0; i < childCount; ++i) {
                float elevation;
                View child = recyclerView.getChildAt(i);
                if (child == itemView || !((elevation = ViewCompat.getElevation((View)child)) > max)) continue;
                max = elevation;
            }
            return max;
        }

        @Override
        public void clearView(View view) {
            Object tag = view.getTag(R.id.item_touch_helper_previous_elevation);
            if (tag != null && tag instanceof Float) {
                if (view instanceof ShadowView) {
                    ((ShadowView)view).setElevation(((Float)tag).floatValue());
                } else {
                    ViewCompat.setElevation((View)view, (float)((Float)tag).floatValue());
                }
            }
            view.setTag(R.id.item_touch_helper_previous_elevation, null);
            super.clearView(view);
        }
    }
}

