/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import carbon.recycler.Adapter;
import carbon.recycler.DiffListCallback;
import carbon.recycler.SelectableItemsAdapter;
import carbon.view.SelectionMode;
import carbon.widget.RecyclerView;
import com.annimon.stream.Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ListAdapter<VH extends RecyclerView.ViewHolder, I>
extends Adapter<VH, I>
implements SelectableItemsAdapter<I> {
    private RecyclerView.OnItemClickedListener<I> onItemClickedListener;
    private Map<Class<? extends I>, RecyclerView.OnItemClickedListener<? extends I>> onItemClickedListeners = new HashMap<Class<? extends I>, RecyclerView.OnItemClickedListener<? extends I>>();
    private boolean diff = true;
    private DiffListCallback<I> diffCallback;
    private SelectionMode selectionMode = SelectionMode.NONE;
    private ArrayList<I> selectedItems = new ArrayList();
    protected List<I> items;

    public ListAdapter() {
        this.items = new ArrayList<I>();
    }

    public ListAdapter(List<I> items) {
        this.items = items;
    }

    @Override
    public I getItem(int position) {
        return this.items.get(position);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setDiffCallback(DiffListCallback<I> diffCallback) {
        this.diffCallback = diffCallback;
    }

    public void setItems(@NonNull List<I> items) {
        ArrayList<I> newItems = new ArrayList<I>(items);
        if (!this.diff) {
            this.items = newItems;
            return;
        }
        if (this.diffCallback == null) {
            this.diffCallback = new DiffListCallback();
        }
        this.diffCallback.setLists(this.items, newItems);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff(this.diffCallback);
        this.items = newItems;
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.setSelectionMode(this.selectionMode);
    }

    public List<I> getItems() {
        return this.items;
    }

    public long getItemId(int position) {
        return position;
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<I> onItemClickedListener) {
        this.onItemClickedListener = onItemClickedListener;
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener2<I> onItemClickedListener) {
        this.onItemClickedListener = (view, item, position) -> {
            if (onItemClickedListener != null) {
                onItemClickedListener.onItemClicked(item);
            }
        };
    }

    public <ItemType extends I> void setOnItemClickedListener(Class<ItemType> type, RecyclerView.OnItemClickedListener<ItemType> onItemClickedListener) {
        this.onItemClickedListeners.put(type, onItemClickedListener);
    }

    public <ItemType extends I> void setOnItemClickedListener(Class<ItemType> type, RecyclerView.OnItemClickedListener2<ItemType> onItemClickedListener) {
        this.onItemClickedListeners.put(type, (view, item, position) -> {
            if (onItemClickedListener != null) {
                onItemClickedListener.onItemClicked(item);
            }
        });
    }

    protected void fireOnItemClickedEvent(View view, int position) {
        if (position < 0 || position > this.items.size()) {
            return;
        }
        I item = this.items.get(position);
        RecyclerView.OnItemClickedListener<I> typeSpecificListener = this.onItemClickedListeners.get(item.getClass());
        if (typeSpecificListener != null) {
            typeSpecificListener.onItemClicked(view, item, position);
        }
        if (this.onItemClickedListener != null) {
            this.onItemClickedListener.onItemClicked(view, item, position);
        }
        if (this.selectionMode != SelectionMode.NONE && view.isFocusable() && view.isClickable()) {
            this.selectItem(item);
        }
    }

    public void setDiffEnabled(boolean useDiff) {
        this.diff = useDiff;
    }

    public boolean isDiffEnabled() {
        return this.diff;
    }

    public void onBindViewHolder(VH holder, int position) {
        ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(view -> this.fireOnItemClickedEvent(holder.itemView, holder.getAdapterPosition()));
    }

    @Override
    public void setSelectionMode(@NonNull SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.setSelectedItems(this.selectedItems);
    }

    @Override
    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectedIndices(List<Integer> selectedIndices) {
        this.setSelectedItems(Stream.of(selectedIndices).map(it -> this.items.get((int)it)).toList());
    }

    @Override
    public List<Integer> getSelectedIndices() {
        return Stream.of(this.selectedItems).map(this.items::indexOf).toList();
    }

    @Override
    public void setSelectedItems(List<I> selectedItems) {
        ArrayList<I> prevSelectedItems = this.selectedItems;
        this.selectedItems = new ArrayList();
        for (I item : prevSelectedItems) {
            this.notifyItemChanged(this.items.indexOf(item), false);
        }
        if (this.selectionMode != SelectionMode.NONE) {
            for (I item : selectedItems) {
                int index = this.items.indexOf(item);
                if (index == -1) continue;
                this.selectedItems.add(item);
                this.notifyItemChanged(index, true);
            }
        }
    }

    @Override
    public List<I> getSelectedItems() {
        return this.selectedItems;
    }

    @Override
    public void selectItem(I item) {
        if (this.selectionMode == SelectionMode.SINGLE) {
            if (this.selectedItems.size() > 0) {
                int deselectedIndex = this.items.indexOf(this.selectedItems.get(0));
                this.selectedItems.clear();
                this.notifyItemChanged(deselectedIndex, false);
            }
            int selectedIndex = this.items.indexOf(item);
            this.selectedItems.add(item);
            this.notifyItemChanged(selectedIndex, true);
        } else if (this.selectionMode == SelectionMode.MULTI) {
            int indexOfSelectedIndex = this.selectedItems.indexOf(item);
            int selectedIndex = this.items.indexOf(item);
            if (indexOfSelectedIndex != -1) {
                this.selectedItems.remove(item);
                this.notifyItemChanged(selectedIndex, false);
            } else {
                this.selectedItems.add(item);
                this.notifyItemChanged(selectedIndex, true);
            }
        }
    }
}

