/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.util.SparseArray;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import carbon.component.Component;
import carbon.component.ItemTransformer;
import carbon.recycler.ListAdapter;
import carbon.recycler.RowDescriptor;
import carbon.recycler.RowFactory;
import carbon.recycler.RowViewHolder;
import carbon.view.SelectionMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RowListAdapter<Type>
extends ListAdapter<RowViewHolder<Type>, Type> {
    private SparseArray<RowDescriptor<? extends Type, ? extends Type>> factories = new SparseArray();
    private Map<Class<? extends Type>, Integer> types = new HashMap<Class<? extends Type>, Integer>();

    public RowListAdapter() {
    }

    public <ItemType extends Type> RowListAdapter(@NonNull Class<ItemType> type, @NonNull RowFactory<ItemType> factory) {
        this.putFactory(type, factory);
    }

    public <ItemType extends Type> RowListAdapter(@NonNull List<ItemType> items, @NonNull RowFactory<ItemType> factory) {
        super(new ArrayList<ItemType>(items));
        this.putFactory(items.get(0).getClass(), factory);
    }

    public <ItemType extends Type, FactoryType extends Type> RowListAdapter(@NonNull Class<ItemType> type, @NonNull ItemTransformer<ItemType, FactoryType> transformer, @NonNull RowFactory<FactoryType> factory) {
        this.putFactory(type, transformer, factory);
    }

    public <ItemType extends Type, FactoryType extends Type> RowListAdapter(@NonNull List<ItemType> items, @NonNull ItemTransformer<ItemType, FactoryType> transformer, @NonNull RowFactory<FactoryType> factory) {
        super(new ArrayList<ItemType>(items));
        this.putFactory(items.get(0).getClass(), transformer, factory);
    }

    public <ItemType extends Type> void putFactory(@NonNull Class<ItemType> type, @NonNull RowFactory<ItemType> factory) {
        this.putFactory(type, ItemTransformer.EMPTY, factory);
    }

    public <ItemType extends Type, FactoryType extends Type> void putFactory(@NonNull Class<ItemType> type, @NonNull ItemTransformer<ItemType, FactoryType> transformer, @NonNull RowFactory<FactoryType> factory) {
        int viewType = this.types.containsKey(type) ? this.types.get(type).intValue() : this.types.size();
        this.factories.put(viewType, new RowDescriptor<ItemType, FactoryType>(transformer, factory));
        this.types.put(type, viewType);
    }

    public RowViewHolder<Type> onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Component component = ((RowDescriptor)this.factories.get((int)viewType)).factory.create(viewGroup);
        return new RowViewHolder(component);
    }

    @Override
    public void onBindViewHolder(@NotNull RowViewHolder<Type> holder, int position) {
        super.onBindViewHolder(holder, position);
        Object data = this.getItem(position);
        Component component = holder.getComponent();
        ItemTransformer transformer = ((RowDescriptor)this.factories.get((int)this.getItemViewType((int)position))).transformer;
        component.setData(transformer.transform(data));
        if (this.getSelectionMode() != SelectionMode.NONE) {
            component.getView().setSelected(this.getSelectedIndices().contains(position));
        }
    }

    public void onBindViewHolder(@NonNull RowViewHolder<Type> holder, int position, @NonNull List<Object> payloads) {
        super.onBindViewHolder(holder, position);
        Object data = this.getItem(position);
        Component component = holder.getComponent();
        ItemTransformer transformer = ((RowDescriptor)this.factories.get((int)this.getItemViewType((int)position))).transformer;
        component.setData(transformer.transform(data));
        if (this.getSelectionMode() != SelectionMode.NONE) {
            component.getView().setSelected(this.getSelectedIndices().contains(position));
        }
    }

    public int getItemViewType(int position) {
        return this.types.get(this.getItem(position).getClass());
    }
}

