/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import androidx.recyclerview.widget.RecyclerView;
import carbon.recycler.Adapter;
import carbon.recycler.ItemTouchHelper;
import java.util.HashMap;

public class SwipeTouchHelper<T>
extends ItemTouchHelper.SimpleCallback {
    private Adapter<?, T> adapter;
    private OnItemSwipedListener<T> onItemSwipedListener;
    private HashMap<Class<? extends T>, OnItemSwipedListener<? extends T>> onItemSwipedListeners = new HashMap();

    public SwipeTouchHelper(RecyclerView recycler, Adapter<?, T> adapter) {
        super(0, 0);
        this.adapter = adapter;
        new ItemTouchHelper(this).attachToRecyclerView(recycler);
    }

    public void setOnItemSwipedListener(OnItemSwipedListener<T> onItemSwipedListener) {
        this.onItemSwipedListener = onItemSwipedListener;
    }

    public void setOnItemSwipedListener(OnItemSwipedListener2<T> onItemSwipedListener) {
        this.onItemSwipedListener = (item, position) -> onItemSwipedListener.onItemSwiped(item);
    }

    public <ItemType extends T> void setOnItemSwipedListener(Class<ItemType> type, OnItemSwipedListener<ItemType> onItemSwipedListener) {
        this.onItemSwipedListeners.put(type, onItemSwipedListener);
    }

    public <ItemType extends T> void setOnItemSwipedListener(Class<ItemType> type, OnItemSwipedListener2<ItemType> onItemSwipedListener) {
        this.onItemSwipedListeners.put(type, (item, position) -> onItemSwipedListener.onItemSwiped(item));
    }

    @Override
    public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        Object item = this.adapter.getItem(viewHolder.getAdapterPosition());
        if (this.onItemSwipedListener != null || item != null && this.onItemSwipedListeners.containsKey(item.getClass())) {
            return 12;
        }
        return super.getSwipeDirs(recyclerView, viewHolder);
    }

    @Override
    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        return false;
    }

    @Override
    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        OnItemSwipedListener<T> onItemSwipedListener;
        Object item = this.adapter.getItem(viewHolder.getAdapterPosition());
        if (item != null && (onItemSwipedListener = this.onItemSwipedListeners.get(item.getClass())) != null) {
            onItemSwipedListener.onItemSwiped(item, viewHolder.getAdapterPosition());
            return;
        }
        if (this.onItemSwipedListener != null) {
            this.onItemSwipedListener.onItemSwiped(this.adapter.getItem(viewHolder.getAdapterPosition()), viewHolder.getAdapterPosition());
        }
    }

    public static interface OnItemSwipedListener2<Type> {
        public void onItemSwiped(Type var1);
    }

    public static interface OnItemSwipedListener<Type> {
        public void onItemSwiped(Type var1, int var2);
    }
}

