/*
 * Decompiled with CFR 0.152.
 */
package carbon.recycler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import org.jetbrains.annotations.NotNull;

public class ViewItemDecoration
extends RecyclerView.ItemDecoration {
    private View view;
    private DrawRules drawBeforeRules;
    private DrawRules drawAfterRules;

    public ViewItemDecoration(Context context, int viewId) {
        this.view = LayoutInflater.from((Context)context).inflate(viewId, null);
    }

    public ViewItemDecoration(View view) {
        this.view = view;
    }

    private void measureAndLayout(RecyclerView parent) {
        if (this.getOrientation(parent) == 1) {
            this.view.measure(View.MeasureSpec.makeMeasureSpec((int)(parent.getMeasuredWidth() - parent.getPaddingLeft() - parent.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.view.layout(parent.getPaddingLeft(), 0, parent.getWidth() - parent.getPaddingRight(), this.view.getMeasuredHeight());
        } else {
            this.view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)(parent.getMeasuredHeight() - parent.getPaddingTop() - parent.getPaddingBottom()), (int)0x40000000));
            this.view.layout(0, parent.getPaddingTop(), this.view.getMeasuredWidth(), parent.getHeight() - parent.getPaddingBottom());
        }
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View child, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        super.getItemOffsets(outRect, child, parent, state);
        int position = parent.getChildAdapterPosition(child);
        if (position == -1) {
            return;
        }
        if (this.view.getMeasuredWidth() == 0 || this.view.getMeasuredHeight() == 0) {
            this.measureAndLayout(parent);
        }
        if (this.drawAfterRules != null && this.drawAfterRules.draw(position)) {
            if (this.getOrientation(parent) == 1) {
                outRect.bottom = this.view.getMeasuredHeight();
            } else {
                outRect.right = this.view.getMeasuredWidth();
            }
        }
        if (this.drawBeforeRules != null && this.drawBeforeRules.draw(position) || this.drawAfterRules == null && this.drawBeforeRules == null && position > 0) {
            if (this.getOrientation(parent) == 1) {
                outRect.top = this.view.getMeasuredHeight();
            } else {
                outRect.left = this.view.getMeasuredWidth();
            }
        }
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int left = parent.getPaddingLeft();
        int top = parent.getPaddingTop();
        int orientation = this.getOrientation(parent);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child;
            int position = parent.getChildAdapterPosition(parent.getChildAt(i));
            if (position == -1) continue;
            if (this.drawAfterRules != null && this.drawAfterRules.draw(position)) {
                child = parent.getChildAt(i);
                if (orientation == 1) {
                    top = (int)((float)child.getBottom() + child.getTranslationY());
                } else {
                    left = (int)((float)child.getRight() + child.getTranslationX());
                }
                this.view.setAlpha(child.getAlpha());
                c.translate((float)left, (float)top);
                this.view.draw(c);
                c.translate((float)(-left), (float)(-top));
            }
            if ((this.drawBeforeRules == null || !this.drawBeforeRules.draw(position)) && (this.drawAfterRules != null || this.drawBeforeRules != null || position <= 0)) continue;
            child = parent.getChildAt(i);
            if (orientation == 1) {
                top = (int)((float)child.getTop() + child.getTranslationY() - (float)this.view.getMeasuredHeight());
            } else {
                left = (int)((float)child.getLeft() + child.getTranslationX() - (float)this.view.getMeasuredWidth());
            }
            this.view.setAlpha(child.getAlpha());
            c.translate((float)left, (float)top);
            this.view.draw(c);
            c.translate((float)(-left), (float)(-top));
        }
    }

    private int getOrientation(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            return layoutManager.getOrientation();
        }
        throw new IllegalStateException("DividerItemDecoration can only be used with a LinearLayoutManager.");
    }

    public void setDrawAfter(DrawRules drawRules) {
        this.drawAfterRules = drawRules;
    }

    public void setDrawBefore(DrawRules drawRules) {
        this.drawBeforeRules = drawRules;
    }

    public static interface DrawRules {
        public boolean draw(int var1);
    }
}

