/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import carbon.view.SimpleTextWatcher;
import carbon.widget.SearchAdapter;
import carbon.widget.SearchEditText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AutoCompleteEditText
extends SearchEditText {
    public static final int FILTERING_START = 0;
    public static final int FILTERING_PARTIAL = 1;
    private boolean autoCompleting = false;
    private int prevOptions;
    private SearchEditText.OnFilterListener onFilterListener;
    private String prevText = "";
    protected TextWatcher autoCompleteTextWatcher;
    SearchAdapter dataProvider;
    List<FilterResult> filteredItems = new ArrayList<FilterResult>();

    public AutoCompleteEditText(Context context) {
        super(context);
        this.initAutoCompleteEditText();
    }

    public AutoCompleteEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAutoCompleteEditText();
    }

    public AutoCompleteEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAutoCompleteEditText();
    }

    @TargetApi(value=21)
    public AutoCompleteEditText(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAutoCompleteEditText();
    }

    public void setDataProvider(SearchAdapter dataProvider) {
        this.dataProvider = dataProvider;
    }

    private void initAutoCompleteEditText() {
        this.autoCompleteTextWatcher = new SimpleTextWatcher(){

            @Override
            public void afterTextChanged(Editable text) {
                if (!AutoCompleteEditText.this.prevText.equals(text.toString())) {
                    AutoCompleteEditText.this.autoComplete();
                }
                AutoCompleteEditText.this.prevText = text.toString();
            }
        };
        this.setOnEditorActionListener((textView, actionId, keyEvent) -> {
            if (actionId == 6) {
                this.autoCompleting = true;
                Editable text = this.getText();
                HintSpan[] spans = (HintSpan[])text.getSpans(0, this.length(), HintSpan.class);
                if (spans.length > 1) {
                    throw new IllegalStateException("more than one HintSpan");
                }
                int cursorPosition = this.getSelectionStart();
                for (HintSpan span : spans) {
                    if (cursorPosition != text.getSpanStart((Object)span)) continue;
                    text.removeSpan((Object)span);
                    break;
                }
                this.setSelection(cursorPosition);
                AutoCompleteEditText.super.setImeOptions(this.prevOptions);
                this.autoCompleting = false;
            }
            return false;
        });
    }

    private void autoComplete() {
        if (this.dataProvider == null) {
            return;
        }
        Editable text = this.getText();
        if (this.autoCompleting) {
            return;
        }
        HintSpan[] spans = (HintSpan[])text.getSpans(0, this.length(), HintSpan.class);
        if (spans.length > 1) {
            throw new IllegalStateException("more than one HintSpan");
        }
        int selStart = this.getSelectionStart();
        if (selStart != this.getSelectionEnd()) {
            return;
        }
        for (HintSpan span : spans) {
            text.delete(text.getSpanStart((Object)span), text.getSpanEnd((Object)span));
        }
        Word currentWord = this.getCurrentWord();
        if (currentWord == null || currentWord.length() == 0) {
            this.fireOnFilterEvent(null);
            return;
        }
        this.autoCompleting = true;
        this.filter(currentWord);
        this.fireOnFilterEvent(this.filteredItems);
        if (this.filteredItems.size() != 0 && this.filteredItems.get((int)0).type == 0) {
            HintSpan span;
            String word = this.filteredItems.get((int)0).text.toString();
            String remainingPart = word.substring(currentWord.preCursor.length());
            text.insert(selStart, (CharSequence)remainingPart);
            span = new HintSpan(this.getCurrentHintTextColor());
            this.setSelection(selStart);
            text.setSpan((Object)span, selStart, selStart + remainingPart.length(), 33);
            AutoCompleteEditText.super.setImeOptions(6);
        }
        this.autoCompleting = false;
    }

    private void fireOnFilterEvent(List<FilterResult> filteredItems) {
        if (this.onFilterListener != null) {
            this.onFilterListener.onFilter(filteredItems);
        }
    }

    private Word getCurrentWord() {
        char c;
        int i;
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            return null;
        }
        int position = this.getSelectionStart();
        Editable text = this.getText();
        Word word = new Word();
        for (i = position - 1; i >= 0 && Character.isLetterOrDigit(c = text.charAt(i)); --i) {
        }
        word.preCursor = text.subSequence(i + 1, position).toString();
        for (i = position; i < this.length() && Character.isLetterOrDigit(c = text.charAt(i)); ++i) {
        }
        HintSpan[] spans = (HintSpan[])text.getSpans(0, this.length(), HintSpan.class);
        if (spans.length > 0) {
            position = text.getSpanStart((Object)spans[0]);
        }
        word.postCursor = text.subSequence(position, i).toString();
        if (word.length() == 0) {
            text.delete(this.getSelectionStart(), i);
            return null;
        }
        return word;
    }

    @Override
    public void setText(CharSequence text, TextView.BufferType type) {
        this.prevText = this.getText().toString();
        super.setText(text, type);
    }

    @Override
    public Editable getText() {
        try {
            return super.getText();
        }
        catch (ClassCastException e) {
            return new SpannableStringBuilder((CharSequence)"");
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        if (this.autoCompleting) {
            return;
        }
        if (selStart == selEnd) {
            Editable text = this.getText();
            HintSpan[] spans = (HintSpan[])text.getSpans(0, this.length(), HintSpan.class);
            if (spans.length > 1) {
                throw new IllegalStateException("more than one HintSpan");
            }
            this.autoCompleting = true;
            if (spans.length == 1) {
                HintSpan span = spans[0];
                if (selStart >= text.getSpanStart((Object)span) && selStart < text.getSpanEnd((Object)span)) {
                    this.setSelection(text.getSpanStart((Object)span));
                } else if (selStart == text.getSpanEnd((Object)span)) {
                    text.removeSpan((Object)span);
                    super.setImeOptions(this.prevOptions);
                }
            }
        }
        this.autoComplete();
        this.autoCompleting = false;
        super.onSelectionChanged(selStart, selEnd);
    }

    @Override
    public void filter() {
        Word currentWord = this.getCurrentWord();
        if (currentWord != null) {
            super.filter(currentWord.toString());
        }
    }

    public void filter(Word word) {
        this.filteredItems.clear();
        if (word.length() == 0) {
            return;
        }
        String preCursor = word.preCursor.toLowerCase();
        for (int i = 0; i < this.dataProvider.getItemCount(); ++i) {
            String[] itemWords = this.dataProvider.getItemWords(i);
            this.matchItem(word, preCursor, i, itemWords);
        }
        Collections.sort(this.filteredItems);
    }

    private void matchItem(Word word, String preCursor, int i, String[] itemWords) {
        for (int j = 0; j < itemWords.length; ++j) {
            Spannable spannable;
            String itemText = itemWords[j];
            if (itemText.length() == word.length()) continue;
            if ((itemText = itemText.toLowerCase()).indexOf(preCursor) == 0 && word.postCursor.length() == 0) {
                spannable = new SpannableStringBuilder((CharSequence)itemText);
                spannable.setSpan((Object)new HintSpan(this.getCurrentHintTextColor()), preCursor.length(), itemText.length(), 33);
                this.filteredItems.add(new FilterResult(0, spannable, this.dataProvider.getItem(i)));
                return;
            }
            spannable = this.partialMatch(itemText, word);
            if (spannable == null) continue;
            this.filteredItems.add(new FilterResult(1, spannable, this.dataProvider.getItem(i)));
            return;
        }
    }

    private Spannable partialMatch(String item, Word word) {
        int i;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)item);
        int j = 0;
        String text = word.toString().toLowerCase();
        for (i = 0; i < item.length() && j < text.length(); ++i) {
            if (item.charAt(i) == text.charAt(j)) {
                ++j;
                continue;
            }
            spannable.setSpan((Object)new HintSpan(this.getCurrentHintTextColor()), i, i + 1, 33);
        }
        spannable.setSpan((Object)new HintSpan(this.getCurrentHintTextColor()), i, item.length(), 33);
        if (j == text.length()) {
            return spannable;
        }
        return null;
    }

    public void setImeOptions(int imeOptions) {
        super.setImeOptions(imeOptions);
        this.prevOptions = imeOptions;
    }

    public void performCompletion(String s) {
        int selEnd;
        int selStart = this.getSelectionStart();
        if (selStart != (selEnd = this.getSelectionEnd())) {
            return;
        }
        Editable text = this.getText();
        HintSpan[] spans = (HintSpan[])text.getSpans(0, this.length(), HintSpan.class);
        if (spans.length > 1) {
            throw new IllegalStateException("more than one HintSpan");
        }
        Word word = this.getCurrentWord();
        if (word == null) {
            throw new IllegalStateException("no word to complete");
        }
        this.autoCompleting = true;
        text.delete(selStart, selStart + word.postCursor.length());
        text.delete(selStart - word.preCursor.length(), selStart);
        text.insert(selStart - word.preCursor.length(), (CharSequence)s);
        this.setSelection(selStart - word.preCursor.length() + s.length());
        this.fireOnFilterEvent(null);
        super.setImeOptions(this.prevOptions);
        this.autoCompleting = false;
    }

    static class Word {
        String preCursor;
        String postCursor;

        Word() {
        }

        public String toString() {
            return this.preCursor + this.postCursor;
        }

        public int length() {
            return this.preCursor.length() + this.postCursor.length();
        }
    }

    public static class FilterResult
    implements Comparable<FilterResult>,
    Serializable {
        int type;
        Spannable text;
        private Object item;

        public FilterResult(int type, Spannable text, Object item) {
            this.type = type;
            this.text = text;
            this.item = item;
        }

        public int getType() {
            return this.type;
        }

        public Spannable getText() {
            return this.text;
        }

        public Object getItem() {
            return this.item;
        }

        @Override
        public int compareTo(@NonNull FilterResult o) {
            if (this.type != o.type) {
                return this.type - o.type;
            }
            if (this.type == 1 && this.text.length() != o.text.length()) {
                return this.text.length() - o.text.length();
            }
            return this.text.toString().compareTo(o.text.toString());
        }

        public boolean equals(Object obj) {
            return this.text.equals(((FilterResult)obj).text);
        }
    }

    @SuppressLint(value={"ParcelCreator"})
    public static class HintSpan
    extends ForegroundColorSpan {
        public HintSpan(int color) {
            super(color);
        }
    }
}

