/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.Button;
import carbon.R;
import carbon.widget.ImageView;
import carbon.widget.LinearLayout;
import carbon.widget.TextView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ$\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0017J\"\u0010\u001d\u001a\u00020\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0014J\u0012\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010&H\u0002R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcarbon/widget/Banner;", "Lcarbon/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "buttonContainer", "contentContainer", "Landroid/view/View;", "finishedInflating", "", "iconImageView", "Lcarbon/widget/ImageView;", "textTextView", "Lcarbon/widget/TextView;", "addView", "", "child", "index", "params", "Landroid/view/ViewGroup$LayoutParams;", "dismiss", "initBanner", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setIcon", "icon", "Landroid/graphics/drawable/Drawable;", "setText", "string", "", "carbon_release"})
public class Banner
extends LinearLayout {
    private final LinearLayout buttonContainer;
    private final View contentContainer;
    private boolean finishedInflating;
    private final ImageView iconImageView;
    private final TextView textTextView;

    private final void initBanner(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.Banner, defStyleAttr, defStyleRes);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026efStyleAttr, defStyleRes)");
        TypedArray a = typedArray;
        this.setIcon(a.getDrawable(R.styleable.Banner_carbon_icon));
        this.setText(a.getString(R.styleable.Banner_android_text));
        a.recycle();
    }

    private final void setText(String string) {
        String string2 = string;
        this.textTextView.setText(string2 != null ? (CharSequence)string2 : (CharSequence)"");
    }

    private final void setIcon(Drawable icon) {
        this.iconImageView.setVisibility(icon == null ? 8 : 0);
        this.iconImageView.setImageDrawable(icon);
    }

    public void addView(@Nullable View child, int index, @Nullable ViewGroup.LayoutParams params) {
        if (!this.finishedInflating) {
            super.addView(child, index, params);
        } else if (child instanceof Button) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.buttonContainer.getChildCount() > 0) {
                layoutParams.topMargin = this.getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf);
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.setMarginStart(this.getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf));
                }
                layoutParams.leftMargin = this.getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf);
            }
            this.buttonContainer.addView(child, index, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.buttonContainer.getWidth() > this.getWidth() - this.contentContainer.getWidth()) {
            this.buttonContainer.getLayoutParams().width = -1;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        if (this.buttonContainer.getWidth() >= this.getWidth()) {
            this.buttonContainer.setOrientation(1);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public final void dismiss() {
        this.animate().translationY((float)(-this.getHeight())).setDuration(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).start();
    }

    public Banner(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_banner, (ViewGroup)((ViewGroup)this));
        this.finishedInflating = true;
        View view = this.findViewById(R.id.carbon_banner_buttons);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.carbon_banner_buttons)");
        this.buttonContainer = (LinearLayout)view;
        View view2 = this.findViewById(R.id.carbon_banner_content);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.carbon_banner_content)");
        this.contentContainer = view2;
        View view3 = this.findViewById(R.id.carbon_bannerIcon);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.carbon_bannerIcon)");
        this.iconImageView = (ImageView)view3;
        View view4 = this.findViewById(R.id.carbon_bannerText);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.carbon_bannerText)");
        this.textTextView = (TextView)view4;
    }

    public Banner(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_banner, (ViewGroup)((ViewGroup)this));
        this.finishedInflating = true;
        View view = this.findViewById(R.id.carbon_banner_buttons);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.carbon_banner_buttons)");
        this.buttonContainer = (LinearLayout)view;
        View view2 = this.findViewById(R.id.carbon_banner_content);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.carbon_banner_content)");
        this.contentContainer = view2;
        View view3 = this.findViewById(R.id.carbon_bannerIcon);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.carbon_bannerIcon)");
        this.iconImageView = (ImageView)view3;
        View view4 = this.findViewById(R.id.carbon_bannerText);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.carbon_bannerText)");
        this.textTextView = (TextView)view4;
        this.initBanner(attrs, R.attr.carbon_bannerStyle, 0);
    }

    public Banner(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_banner, (ViewGroup)((ViewGroup)this));
        this.finishedInflating = true;
        View view = this.findViewById(R.id.carbon_banner_buttons);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.carbon_banner_buttons)");
        this.buttonContainer = (LinearLayout)view;
        View view2 = this.findViewById(R.id.carbon_banner_content);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.carbon_banner_content)");
        this.contentContainer = view2;
        View view3 = this.findViewById(R.id.carbon_bannerIcon);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.carbon_bannerIcon)");
        this.iconImageView = (ImageView)view3;
        View view4 = this.findViewById(R.id.carbon_bannerText);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.carbon_bannerText)");
        this.textTextView = (TextView)view4;
        this.initBanner(attrs, defStyleAttr, 0);
    }

    public Banner(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_banner, (ViewGroup)((ViewGroup)this));
        this.finishedInflating = true;
        View view = this.findViewById(R.id.carbon_banner_buttons);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.carbon_banner_buttons)");
        this.buttonContainer = (LinearLayout)view;
        View view2 = this.findViewById(R.id.carbon_banner_content);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.carbon_banner_content)");
        this.contentContainer = view2;
        View view3 = this.findViewById(R.id.carbon_bannerIcon);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.carbon_bannerIcon)");
        this.iconImageView = (ImageView)view3;
        View view4 = this.findViewById(R.id.carbon_bannerText);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.carbon_bannerText)");
        this.textTextView = (TextView)view4;
        this.initBanner(attrs, defStyleAttr, defStyleRes);
    }
}

