/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.MenuItemCompat;
import carbon.Carbon;
import carbon.R;
import carbon.component.Component;
import carbon.component.LayoutComponent;
import carbon.databinding.CarbonBottomnavigationviewItemBinding;
import carbon.drawable.ColorStateListFactory;
import carbon.recycler.RowFactory;
import carbon.widget.LinearLayout;
import carbon.widget.RecyclerView;

public class BottomNavigationView
extends LinearLayout {
    private Item[] items;
    private View activeView;
    private RowFactory<Item> itemFactory;
    RecyclerView.OnItemClickedListener<Item> listener;

    public BottomNavigationView(Context context) {
        super(context, null, R.attr.carbon_bottomNavigationViewStyle);
        this.initBottomNavigationView(null, R.attr.carbon_bottomNavigationViewStyle, R.style.carbon_BottomNavigationView);
    }

    public BottomNavigationView(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_bottomNavigationViewStyle);
        this.initBottomNavigationView(attrs, R.attr.carbon_bottomNavigationViewStyle, R.style.carbon_BottomNavigationView);
    }

    public BottomNavigationView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initBottomNavigationView(attrs, defStyleAttr, R.style.carbon_BottomNavigationView);
    }

    @TargetApi(value=21)
    public BottomNavigationView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initBottomNavigationView(attrs, defStyleAttr, defStyleRes);
    }

    private void initBottomNavigationView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BottomNavigationView, defStyleAttr, defStyleRes);
        this.itemFactory = ItemComponent::new;
        int menuId = a.getResourceId(R.styleable.BottomNavigationView_carbon_menu, 0);
        if (menuId != 0) {
            this.setMenu(menuId);
        }
        a.recycle();
    }

    public void setMenuItems(Item[] items) {
        this.items = items;
        this.initItems();
    }

    public Item[] getMenuItems() {
        return this.items;
    }

    public void setMenu(int resId) {
        this.setMenu(Carbon.getMenu(this.getContext(), resId));
    }

    public void setMenu(Menu menu) {
        this.items = new Item[menu.size()];
        for (int i = 0; i < menu.size(); ++i) {
            this.items[i] = new Item(menu.getItem(i));
        }
        this.initItems();
    }

    @Deprecated
    public void setItemLayout(int itemLayoutId) {
    }

    public void setItemFactory(RowFactory<Item> factory) {
        this.itemFactory = factory;
        this.initItems();
    }

    private void initItems() {
        this.removeAllViews();
        int width = this.getOrientation() == 0 ? 0 : -2;
        int height = this.getOrientation() != 0 ? 0 : -2;
        this.setWeightSum(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            Item item = this.items[i];
            if (!this.isInEditMode()) {
                Component<Item> component = this.itemFactory.create((ViewGroup)this);
                int finalI = i;
                component.getView().setOnClickListener(v -> {
                    if (component.getView() == this.activeView) {
                        return;
                    }
                    this.selectItem(component.getView());
                    if (this.listener != null) {
                        this.listener.onItemClicked(component.getView(), item, finalI);
                    }
                });
                component.setData(item);
                this.addView(component.getView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height, 1.0f));
                continue;
            }
            LinearLayout view = new LinearLayout(this.getContext());
            this.addView((View)view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height, 1.0f));
        }
    }

    private void selectItem(View item) {
        if (this.activeView != null) {
            this.activeView.setSelected(false);
        }
        this.activeView = item;
        if (this.activeView != null) {
            this.activeView.setSelected(true);
        }
    }

    public int getSelectedIndex() {
        if (this.activeView == null) {
            return -1;
        }
        return this.indexOfChild(this.activeView);
    }

    public void setSelectedIndex(int index) {
        this.selectItem(this.getChildAt(index));
    }

    public void setOnItemClickListener(RecyclerView.OnItemClickedListener<Item> listener) {
        this.listener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.selectedIndex = this.getSelectedIndex();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelectedIndex(ss.selectedIndex);
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        int selectedIndex;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(BottomNavigationView.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.selectedIndex = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeInt(this.selectedIndex);
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }

    private static class ItemComponent
    extends LayoutComponent<Item> {
        private final CarbonBottomnavigationviewItemBinding binding = CarbonBottomnavigationviewItemBinding.bind(this.getView());

        ItemComponent(ViewGroup parent) {
            super(parent, R.layout.carbon_bottomnavigationview_item);
        }

        @Override
        public void bind(Item data) {
            this.binding.carbonBottomIcon.setImageDrawable(data.icon);
            this.binding.carbonBottomIcon.setTintList(data.getIconTintList() != null ? data.getIconTintList() : ColorStateListFactory.INSTANCE.makeIconSecondary(this.getView().getContext()));
            this.binding.carbonBottomText.setText(data.text);
            this.binding.carbonBottomText.setTextColor(data.getIconTintList() != null ? data.getIconTintList() : ColorStateListFactory.INSTANCE.makeIconSecondary(this.getView().getContext()));
        }
    }

    public static class Item {
        private int id;
        private Drawable icon;
        private CharSequence text;
        private ColorStateList iconTint;

        public Item() {
        }

        public Item(int id2, Drawable icon, CharSequence text) {
            this.id = id2;
            this.icon = icon;
            this.text = text;
        }

        public Item(MenuItem menuItem) {
            this.id = menuItem.getItemId();
            try {
                this.icon = menuItem.getIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.text = menuItem.getTitle();
            this.iconTint = MenuItemCompat.getIconTintList((MenuItem)menuItem);
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id2) {
            this.id = id2;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public void setTitle(CharSequence text) {
            this.text = text;
        }

        public CharSequence getTitle() {
            return this.text;
        }

        public void setIconTintList(ColorStateList iconTint) {
            this.iconTint = iconTint;
        }

        public ColorStateList getIconTintList() {
            return this.iconTint;
        }
    }
}

