/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.Carbon;
import carbon.R;
import carbon.widget.FrameLayout;
import carbon.widget.ImageView;
import carbon.widget.Label;
import carbon.widget.LinearLayout;
import carbon.widget.PopupWindow;
import carbon.widget.TextView;

public class Chip
extends LinearLayout
implements Checkable {
    private FrameLayout content;
    private ImageView check;
    private TextView title;
    private ImageView close;
    private OnRemoveListener onRemoveListener;
    private boolean checkedState = false;
    private OnCheckedChangeListener onCheckedChangeListener;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public Chip(Context context) {
        super(context, null, R.attr.carbon_chipStyle);
        this.initChip(null, R.attr.carbon_chipStyle, R.style.carbon_Chip);
    }

    public Chip(Context context, CharSequence text) {
        super(context, null, R.attr.carbon_chipStyle);
        this.initChip(null, R.attr.carbon_chipStyle, R.style.carbon_Chip);
        this.setText(text);
    }

    public Chip(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_chipStyle);
        this.initChip(attrs, R.attr.carbon_chipStyle, R.style.carbon_Chip);
    }

    public Chip(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initChip(attrs, defStyleAttr, R.style.carbon_Chip);
    }

    @TargetApi(value=21)
    public Chip(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initChip(attrs, defStyleAttr, defStyleRes);
    }

    private void initChip(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        Chip.inflate((Context)this.getContext(), (int)R.layout.carbon_chip, (ViewGroup)this);
        this.title = (TextView)this.findViewById(R.id.carbon_chipText);
        this.content = (FrameLayout)this.findViewById(R.id.carbon_chipContent);
        this.check = (ImageView)this.findViewById(R.id.carbon_chipCheck);
        this.close = (ImageView)this.findViewById(R.id.carbon_chipClose);
        this.close.setOnClickListener(v -> {
            if (this.onRemoveListener != null) {
                this.onRemoveListener.onDismiss();
            }
        });
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Chip, defStyleAttr, defStyleRes);
        this.setText(a.getString(R.styleable.Chip_android_text));
        this.setIcon(Carbon.getDrawable((View)this, a, R.styleable.Chip_carbon_icon, 0));
        this.setRemovable(a.getBoolean(R.styleable.Chip_carbon_removable, false));
        this.setChecked(a.getBoolean(R.styleable.Chip_android_checked, false));
        this.setTooltipText(a.getText(R.styleable.Chip_carbon_tooltipText));
        a.recycle();
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public boolean performClick() {
        boolean handled;
        this.toggle();
        if (this.onCheckedChangeListener != null) {
            this.onCheckedChangeListener.onCheckedChanged(this, this.isChecked());
        }
        if (!(handled = super.performClick())) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.checkedState;
    }

    public void setChecked(boolean checked) {
        if (this.checkedState != checked) {
            this.checkedState = checked;
            this.check.setVisibility(checked ? 0 : 8);
            this.refreshDrawableState();
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 2);
        if (this.isChecked()) {
            Chip.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    @Deprecated
    public void setText(String text) {
        this.setText((CharSequence)text);
    }

    public void setText(CharSequence text) {
        if (text != null) {
            this.title.setText(text);
            this.title.setVisibility(0);
        } else {
            this.title.setVisibility(8);
        }
    }

    public void setText(int resId) {
        this.setText(this.getResources().getString(resId));
    }

    public String getText() {
        return (String)this.title.getText();
    }

    public View getTitleView() {
        return this.title;
    }

    public void setIcon(int iconRes) {
        this.content.removeAllViews();
        if (iconRes == 0) {
            this.content.setVisibility(8);
            return;
        }
        this.content.setVisibility(0);
        ImageView icon = new ImageView(this.getContext());
        this.content.addView((View)icon);
        icon.setImageResource(iconRes);
    }

    public void setIcon(Drawable drawable2) {
        this.content.removeAllViews();
        if (drawable2 == null) {
            this.content.setVisibility(8);
            return;
        }
        this.content.setVisibility(0);
        ImageView icon = new ImageView(this.getContext());
        this.content.addView((View)icon);
        icon.setImageDrawable(drawable2);
    }

    public void setIcon(Bitmap bitmap) {
        this.content.removeAllViews();
        if (bitmap == null) {
            this.content.setVisibility(8);
            return;
        }
        this.content.setVisibility(0);
        ImageView icon = new ImageView(this.getContext());
        this.content.addView((View)icon);
        icon.setImageBitmap(bitmap);
    }

    @Deprecated
    public Drawable getIcon() {
        if (this.content.getChildCount() > 0 && this.content.getChildAt(0) instanceof android.widget.ImageView) {
            return ((android.widget.ImageView)this.content.getChildAt(0)).getDrawable();
        }
        return null;
    }

    @Deprecated
    public View getIconView() {
        if (this.content.getChildCount() > 0 && this.content.getChildAt(0) instanceof android.widget.ImageView) {
            return this.content.getChildAt(0);
        }
        return null;
    }

    public View getContentView() {
        if (this.content.getChildCount() > 0) {
            return this.content.getChildAt(0);
        }
        return null;
    }

    public void setContentView(View view) {
        this.content.removeAllViews();
        if (view != null) {
            this.content.setVisibility(0);
            this.content.addView(view);
        } else {
            this.content.setVisibility(8);
        }
    }

    public void setRemovable(boolean removable) {
        this.close.setVisibility(removable ? 0 : 8);
    }

    public boolean isRemovable() {
        return this.close.getVisibility() == 0;
    }

    public void setOnRemoveListener(OnRemoveListener onRemoveListener) {
        this.onRemoveListener = onRemoveListener;
    }

    public void setTooltipText(CharSequence text) {
        if (text != null) {
            this.setOnLongClickListener(v -> {
                Label tooltip = (Label)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.carbon_tooltip, null);
                tooltip.setText(text);
                PopupWindow window = new PopupWindow(tooltip);
                window.show((View)this, 51);
                new Handler(Looper.getMainLooper()).postDelayed(window::dismiss, 3000L);
                return true;
            });
        } else if (this.isLongClickable()) {
            this.setOnLongClickListener(null);
        }
    }

    public static interface OnRemoveListener {
        public void onDismiss();
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(Chip var1, boolean var2);
    }
}

