/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.view.Orientation;
import carbon.view.View;

public class Divider
extends View {
    private Orientation orientation = Orientation.HORIZONTAL;

    public Divider(Context context) {
        super(context, null, R.attr.carbon_dividerStyle);
        this.initDivider(null, R.attr.carbon_dividerStyle, R.style.carbon_Divider);
    }

    public Divider(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_dividerStyle);
        this.initDivider(attrs, R.attr.carbon_dividerStyle, R.style.carbon_Divider);
    }

    public Divider(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initDivider(attrs, defStyleAttr, R.style.carbon_Divider);
    }

    @TargetApi(value=21)
    public Divider(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initDivider(attrs, defStyleAttr, defStyleRes);
    }

    public void initDivider(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Divider, defStyleAttr, defStyleRes);
        this.orientation = Orientation.values()[a.getInt(R.styleable.Divider_android_orientation, Orientation.HORIZONTAL.ordinal())];
        a.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.orientation == Orientation.HORIZONTAL) {
            this.setMeasuredDimension(this.getMeasuredWidth(), this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_dividerHeight));
        } else {
            this.setMeasuredDimension(this.getContext().getResources().getDimensionPixelSize(R.dimen.carbon_dividerHeight), this.getMeasuredHeight());
        }
    }
}

