/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.drawable.ButtonGravity;
import carbon.drawable.ripple.RippleDrawable;
import carbon.internal.DropDownMenu;
import carbon.recycler.ListAdapter;
import carbon.recycler.RowListAdapter;
import carbon.widget.CheckBox;
import carbon.widget.EditText;
import carbon.widget.FrameLayout;
import carbon.widget.RecyclerView;
import carbon.widget.TextView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DropDown
extends EditText {
    private CustomItemFactory customItemFactory = text -> text;
    private List items = new ArrayList();
    DropDownMenu dropDownMenu;
    OnItemSelectedListener onItemSelectedListener;
    OnSelectionChangedListener onSelectionChangedListener;
    private boolean isShowingPopup = false;
    private Drawable drawable;
    private float drawablePadding;
    private ButtonGravity buttonGravity;
    GestureDetector gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapConfirmed(MotionEvent e) {
            DropDown.this.showMenu();
            return true;
        }
    });
    RecyclerView.OnItemClickedListener<Serializable> onItemClickedListener = new RecyclerView.OnItemClickedListener<Serializable>(){

        @Override
        public void onItemClicked(View view, Serializable item, int position) {
            Mode mode = DropDown.this.dropDownMenu.getMode();
            if (mode == Mode.MultiSelect) {
                DropDown.this.dropDownMenu.toggle(position);
                if (DropDown.this.onItemSelectedListener != null) {
                    DropDown.this.onItemSelectedListener.onItemSelected(item, position);
                }
                if (DropDown.this.onSelectionChangedListener != null) {
                    DropDown.this.onSelectionChangedListener.onSelectionChanged(item, position);
                }
            } else {
                int prevSelectedIndex = DropDown.this.getSelectedIndex();
                DropDown.this.setSelectedIndex(position);
                if (DropDown.this.onItemSelectedListener != null) {
                    DropDown.this.onItemSelectedListener.onItemSelected(item, position);
                }
                if (DropDown.this.onSelectionChangedListener != null && prevSelectedIndex != position) {
                    DropDown.this.onSelectionChangedListener.onSelectionChanged(item, position);
                }
            }
            DropDown.this.setText(DropDown.this.dropDownMenu.getSelectedText());
            if (mode != Mode.MultiSelect) {
                DropDown.this.dropDownMenu.dismiss();
            }
        }
    };

    public DropDown(Context context) {
        super(context, null, R.attr.carbon_dropDownStyle);
        this.initDropDown(null, R.attr.carbon_dropDownStyle, R.style.carbon_DropDown);
    }

    public DropDown(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_dropDownStyle);
        this.initDropDown(attrs, R.attr.carbon_dropDownStyle, R.style.carbon_DropDown);
    }

    public DropDown(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initDropDown(attrs, defStyleAttr, R.style.carbon_DropDown);
    }

    @TargetApi(value=21)
    public DropDown(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initDropDown(attrs, defStyleAttr, defStyleRes);
    }

    private void initDropDown(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DropDown, defStyleAttr, defStyleRes);
        int theme = a.getResourceId(R.styleable.DropDown_carbon_popupTheme, -1);
        this.dropDownMenu = new DropDownMenu((Context)new ContextThemeWrapper(this.getContext(), theme));
        this.dropDownMenu.setOnDismissListener(() -> {
            this.isShowingPopup = false;
        });
        this.dropDownMenu.setPopupMode(PopupMode.values()[a.getInt(R.styleable.DropDown_carbon_popupMode, PopupMode.Over.ordinal())]);
        this.setMode(Mode.values()[a.getInt(R.styleable.DropDown_carbon_mode, Mode.SingleSelect.ordinal())]);
        this.dropDownMenu.setOnItemClickedListener(this.onItemClickedListener);
        this.setButtonDrawable(Carbon.getDrawable((View)this, a, R.styleable.DropDown_android_button, R.drawable.carbon_dropdown));
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.DropDown_android_drawablePadding) {
                this.drawablePadding = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 != R.styleable.DropDown_carbon_buttonGravity) continue;
            this.buttonGravity = ButtonGravity.values()[a.getInt(attr2, 0)];
        }
        a.recycle();
    }

    public PopupMode getPopupMode() {
        return this.dropDownMenu.getPopupMode();
    }

    public void setPopupMode(PopupMode popupMode) {
        this.dropDownMenu.setPopupMode(popupMode);
    }

    public Mode getStyle() {
        return this.dropDownMenu.getMode();
    }

    public void setMode(@NonNull Mode mode) {
        this.dropDownMenu.setMode(mode);
        if (mode == Mode.Editable) {
            this.setFocusableInTouchMode(true);
            this.setCursorVisible(true);
            this.setLongClickable(true);
        } else {
            this.setFocusableInTouchMode(false);
            this.setCursorVisible(false);
            this.setLongClickable(false);
        }
    }

    public void setSelectedIndex(int index) {
        this.dropDownMenu.setSelectedIndex(index);
        this.setText(this.getAdapter().getItem(index).toString());
    }

    public void setSelectedIndices(int[] indices) {
        this.dropDownMenu.setSelectedIndices(indices);
    }

    public int getSelectedIndex() {
        return this.dropDownMenu.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.dropDownMenu.getSelectedIndices();
    }

    public <Type extends Serializable> void setSelectedItem(Type item) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(item)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public <Type extends Serializable> void setSelectedItems(List<Type> items) {
        this.dropDownMenu.setSelectedItems(items);
    }

    public <Type extends Serializable> Type getSelectedItem() {
        return this.dropDownMenu.getSelectedItem();
    }

    public <Type extends Serializable> List<Type> getSelectedItems() {
        return this.dropDownMenu.getSelectedItems();
    }

    public void setAdapter(RowListAdapter<Serializable> adapter) {
        this.dropDownMenu.setAdapter(adapter);
        this.setText(this.dropDownMenu.getSelectedText());
    }

    public ListAdapter<?, Serializable> getAdapter() {
        return this.dropDownMenu.getAdapter();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.dropDownMenu.getMode() != Mode.Editable || this.isButtonOnTheLeft() && event.getX() <= (float)this.getCompoundPaddingLeft() || !this.isButtonOnTheLeft() && event.getX() >= (float)(this.getWidth() - this.getCompoundPaddingRight())) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    public void showMenu() {
        this.dropDownMenu.setCustomItem(this.customItemFactory.makeItem(this.getText().toString()));
        this.dropDownMenu.show((View)this);
        this.isShowingPopup = true;
    }

    public void setCustomItemFactory(CustomItemFactory factory) {
        this.customItemFactory = factory;
    }

    public <Type extends Serializable> void setOnItemSelectedListener(OnItemSelectedListener<Type> onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public <Type extends Serializable> void setOnSelectionChangedListener(OnSelectionChangedListener<Type> onSelectionChangedListener) {
        this.onSelectionChangedListener = onSelectionChangedListener;
    }

    public <Type extends Serializable> void setItems(Type[] items) {
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        this.dropDownMenu.setItems(this.items);
        this.setSelectedIndex(0);
    }

    public <Type extends Serializable> void setItems(List<Type> items) {
        this.items = items;
        this.dropDownMenu.setItems(items);
        this.setSelectedIndex(0);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        FrameLayout container;
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.dropDownMenu != null && (container = (FrameLayout)this.dropDownMenu.getContentView().findViewById(R.id.carbon_popupContainer)).getAnimator() == null) {
            this.dropDownMenu.update();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isShowingPopup) {
            this.dropDownMenu.showImmediate((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isShowingPopup) {
            this.dropDownMenu.dismissImmediate();
        }
    }

    private boolean isLayoutRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private boolean isButtonOnTheLeft() {
        return this.buttonGravity == ButtonGravity.LEFT || !this.isLayoutRtl() && this.buttonGravity == ButtonGravity.START || this.isLayoutRtl() && this.buttonGravity == ButtonGravity.END;
    }

    public void setButtonDrawable(Drawable d) {
        if (this.drawable != d) {
            if (this.drawable != null) {
                this.drawable.setCallback(null);
                this.unscheduleDrawable(this.drawable);
            }
            this.drawable = d;
            if (d != null) {
                this.drawable = DrawableCompat.wrap((Drawable)d);
                d.setCallback((Drawable.Callback)this);
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                d.setVisible(this.getVisibility() == 0, false);
                this.setMinHeight(d.getIntrinsicHeight());
                this.updateButtonTint();
            }
        }
    }

    public ButtonGravity getButtonGravity() {
        return this.buttonGravity;
    }

    public void setButtonGravity(ButtonGravity buttonGravity) {
        this.buttonGravity = buttonGravity;
    }

    @Override
    public void setTintList(ColorStateList list) {
        super.setTintList(list);
        this.updateButtonTint();
    }

    @Deprecated
    public void setTint(@Nullable ColorStateList list) {
        super.setTintList(list);
        this.updateButtonTint();
    }

    @Override
    public void setTint(int color2) {
        this.setTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode mode) {
        super.setTintMode(mode);
        this.updateButtonTint();
    }

    private void updateButtonTint() {
        if (this.drawable != null) {
            if (this.tint != null && this.tintMode != null) {
                Carbon.setTintListMode(this.drawable, this.tint, this.tintMode);
            } else {
                Carbon.clearTint(this.drawable);
            }
            if (this.drawable.isStateful()) {
                this.drawable.setState(this.getDrawableState());
            }
        }
    }

    public CharSequence getAccessibilityClassName() {
        return DropDown.class.getSimpleName();
    }

    public int getCompoundPaddingLeft() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingLeft();
        if (this.isButtonOnTheLeft() && (buttonDrawable = this.drawable) != null) {
            padding = (int)((float)padding + ((float)buttonDrawable.getIntrinsicWidth() + this.drawablePadding));
        }
        return padding;
    }

    public int getCompoundPaddingRight() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingRight();
        if (!this.isButtonOnTheLeft() && (buttonDrawable = this.drawable) != null) {
            padding = (int)((float)padding + ((float)buttonDrawable.getIntrinsicWidth() + this.drawablePadding));
        }
        return padding;
    }

    protected void onDraw(Canvas canvas) {
        Drawable buttonDrawable = this.drawable;
        if (buttonDrawable != null) {
            int top;
            int verticalGravity = this.getGravity() & 0x70;
            int drawableHeight = buttonDrawable.getIntrinsicHeight();
            int drawableWidth = buttonDrawable.getIntrinsicWidth();
            switch (verticalGravity) {
                case 80: {
                    top = this.getHeight() - drawableHeight - this.getPaddingBottom();
                    break;
                }
                case 16: {
                    top = (this.getHeight() - drawableHeight - this.getPaddingTop() - this.getPaddingBottom()) / 2 + this.getPaddingTop();
                    break;
                }
                default: {
                    top = this.getPaddingTop();
                }
            }
            int bottom = top + drawableHeight;
            int left = this.isButtonOnTheLeft() ? this.getPaddingLeft() : this.getWidth() - drawableWidth - this.getPaddingRight();
            int right = this.isButtonOnTheLeft() ? drawableWidth + this.getPaddingLeft() : this.getWidth() - this.getPaddingRight();
            buttonDrawable.setBounds(left, top, right, bottom);
            Drawable background = this.getBackground();
            if (background instanceof RippleDrawable) {
                // empty if block
            }
        }
        super.onDraw(canvas);
        if (buttonDrawable != null) {
            if (this.animateColorChanges && this.tint != null && this.tintMode != null) {
                buttonDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tint.getColorForState(buttonDrawable.getState(), this.tint.getDefaultColor()), this.tintMode));
            }
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            if (scrollX == 0 && scrollY == 0) {
                buttonDrawable.draw(canvas);
            } else {
                canvas.translate((float)scrollX, (float)scrollY);
                buttonDrawable.draw(canvas);
                canvas.translate((float)(-scrollX), (float)(-scrollY));
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.drawable;
        if (d != null && d.isStateful() && d.setState(this.getDrawableState())) {
            this.invalidateDrawable(d);
        }
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.drawable;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.drawable != null) {
            this.drawable.jumpToCurrentState();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isShowingPopup = this.isShowingPopup ? 1 : 0;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.isShowingPopup = ss.isShowingPopup > 0;
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        int isShowingPopup;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(EditText.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.isShowingPopup = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeInt(this.isShowingPopup);
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }

    public static class CheckableViewHolder
    extends RecyclerView.ViewHolder
    implements Checkable {
        CheckBox checkBox;

        public CheckableViewHolder(View itemView) {
            super(itemView);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.carbon_itemCheckText);
        }

        public void setChecked(boolean b) {
            this.checkBox.setChecked(b);
        }

        public boolean isChecked() {
            return this.checkBox.isChecked();
        }

        public void toggle() {
            this.checkBox.toggle();
        }
    }

    public static class CheckableAdapter<Type>
    extends ListAdapter<CheckableViewHolder, Type> {
        private List<Integer> selectedIndices;

        public CheckableAdapter(List<Integer> selectedIndices) {
            this.selectedIndices = selectedIndices;
        }

        @NotNull
        public CheckableViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View view = inflater.inflate(R.layout.carbon_dropdown_checkableitem, parent, false);
            return new CheckableViewHolder(view);
        }

        @Override
        public void onBindViewHolder(CheckableViewHolder holder, int position) {
            holder.checkBox.setText(this.items.get(position).toString());
            holder.checkBox.setChecked(this.selectedIndices.contains(position));
            holder.itemView.setOnClickListener(view -> this.fireOnItemClickedEvent(holder.itemView, holder.getAdapterPosition()));
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView tv;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tv = (TextView)itemView.findViewById(R.id.carbon_itemText);
        }
    }

    public static class Adapter<Type>
    extends ListAdapter<ViewHolder, Type> {
        @NotNull
        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View view = inflater.inflate(R.layout.carbon_dropdown_item, parent, false);
            return new ViewHolder(view);
        }

        @Override
        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.tv.setText(this.items.get(position).toString());
            holder.itemView.setOnClickListener(view -> this.fireOnItemClickedEvent(holder.itemView, holder.getAdapterPosition()));
        }
    }

    public static interface CustomItemFactory {
        public Serializable makeItem(String var1);
    }

    public static interface OnSelectionChangedListener<Type> {
        public void onSelectionChanged(Type var1, int var2);
    }

    public static interface OnItemSelectedListener<Type> {
        public void onItemSelected(Type var1, int var2);
    }

    public static enum Mode {
        SingleSelect,
        MultiSelect,
        Editable;

    }

    public static enum PopupMode {
        Over,
        Fit;

    }
}

