/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.RecyclerView;
import carbon.R;
import carbon.recycler.ArrayAdapter;
import carbon.widget.ImageView;
import carbon.widget.RecyclerView;
import carbon.widget.TextView;

public class ExpandableRecyclerView
extends RecyclerView {
    public ExpandableRecyclerView(Context context) {
        super(context);
    }

    public ExpandableRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableRecyclerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ExpandableRecyclerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.getAdapter() != null) {
            ss.stateToSave = ((Adapter)this.getAdapter()).getExpandedGroups();
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.getAdapter() != null) {
            ((Adapter)this.getAdapter()).setExpandedGroups(ss.stateToSave);
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (!(adapter instanceof Adapter)) {
            throw new IllegalArgumentException("adapter has to be of type ExpandableRecyclerView.Adapter");
        }
        super.setAdapter(adapter);
    }

    public static class SimpleGroupViewHolder
    extends GroupViewHolder {
        ImageView expandedIndicator;
        TextView text;
        private boolean expanded;

        public SimpleGroupViewHolder(Context context) {
            super(View.inflate((Context)context, (int)R.layout.carbon_expandablerecyclerview_group, null));
            this.itemView.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            this.expandedIndicator = (ImageView)this.itemView.findViewById(R.id.carbon_groupExpandedIndicator);
            this.text = (TextView)this.itemView.findViewById(R.id.carbon_groupText);
        }

        @Override
        public void expand() {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animator.setDuration(200L);
            animator.addUpdateListener(animation -> {
                this.expandedIndicator.setRotation(180.0f * ((Float)animation.getAnimatedValue()).floatValue());
                this.expandedIndicator.postInvalidate();
            });
            animator.start();
            this.expanded = true;
        }

        @Override
        public void collapse() {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animator.setDuration(200L);
            animator.addUpdateListener(animation -> {
                this.expandedIndicator.setRotation(180.0f * ((Float)animation.getAnimatedValue()).floatValue());
                this.expandedIndicator.postInvalidate();
            });
            animator.start();
            this.expanded = false;
        }

        @Override
        public void setExpanded(boolean expanded) {
            this.expandedIndicator.setRotation(expanded ? 180.0f : 0.0f);
            this.expanded = expanded;
        }

        @Override
        public boolean isExpanded() {
            return this.expanded;
        }

        public void setText(String t) {
            this.text.setText(t);
        }

        public String getText() {
            return this.text.getText().toString();
        }
    }

    public static abstract class GroupViewHolder
    extends RecyclerView.ViewHolder {
        public GroupViewHolder(View itemView) {
            super(itemView);
        }

        public abstract void expand();

        public abstract void collapse();

        public abstract void setExpanded(boolean var1);

        public abstract boolean isExpanded();
    }

    public static abstract class Adapter<CVH extends RecyclerView.ViewHolder, GVH extends RecyclerView.ViewHolder, C, G>
    extends ArrayAdapter<RecyclerView.ViewHolder, Object> {
        private static final int TYPE_HEADER = 0;
        SparseBooleanArray expanded = new SparseBooleanArray();
        private OnChildItemClickedListener onChildItemClickedListener;

        boolean isExpanded(int group) {
            return this.expanded.get(group);
        }

        SparseBooleanArray getExpandedGroups() {
            return this.expanded;
        }

        public void setExpandedGroups(SparseBooleanArray expanded) {
            this.expanded = expanded;
        }

        public void expand(int group) {
            if (this.isExpanded(group)) {
                return;
            }
            int position = 0;
            for (int i = 0; i < group; ++i) {
                ++position;
                if (!this.isExpanded(i)) continue;
                position += this.getChildItemCount(i);
            }
            this.notifyItemRangeInserted(++position, this.getChildItemCount(group));
            this.expanded.put(group, true);
        }

        public void collapse(int group) {
            if (!this.isExpanded(group)) {
                return;
            }
            int position = 0;
            for (int i = 0; i < group; ++i) {
                ++position;
                if (!this.isExpanded(i)) continue;
                position += this.getChildItemCount(i);
            }
            this.notifyItemRangeRemoved(++position, this.getChildItemCount(group));
            this.expanded.put(group, false);
        }

        public abstract int getGroupItemCount();

        public abstract int getChildItemCount(int var1);

        @Override
        public int getItemCount() {
            int count = 0;
            for (int i = 0; i < this.getGroupItemCount(); ++i) {
                count += this.isExpanded(i) ? this.getChildItemCount(i) + 1 : 1;
            }
            return count;
        }

        public abstract G getGroupItem(int var1);

        public abstract C getChildItem(int var1, int var2);

        @Override
        public Object getItem(int i) {
            int group = 0;
            while (group < this.getGroupItemCount()) {
                if (i > 0 && !this.isExpanded(group)) {
                    --i;
                    ++group;
                    continue;
                }
                if (i > 0 && this.isExpanded(group)) {
                    if (--i < this.getChildItemCount(group)) {
                        return this.getChildItem(group, i);
                    }
                    i -= this.getChildItemCount(group);
                    ++group;
                    continue;
                }
                if (i != 0) continue;
                return this.getGroupItem(group);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder holder, int i) {
            int group = 0;
            while (group < this.getGroupItemCount()) {
                if (i > 0 && !this.isExpanded(group)) {
                    --i;
                    ++group;
                    continue;
                }
                if (i > 0 && this.isExpanded(group)) {
                    if (--i < this.getChildItemCount(group)) {
                        this.onBindChildViewHolder(holder, group, i);
                        return;
                    }
                    i -= this.getChildItemCount(group);
                    ++group;
                    continue;
                }
                if (i != 0) continue;
                this.onBindGroupViewHolder(holder, group);
                return;
            }
            throw new IndexOutOfBoundsException();
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return viewType == 0 ? this.onCreateGroupViewHolder(parent) : this.onCreateChildViewHolder(parent, viewType);
        }

        protected abstract GVH onCreateGroupViewHolder(ViewGroup var1);

        protected abstract CVH onCreateChildViewHolder(ViewGroup var1, int var2);

        public abstract int getChildItemViewType(int var1, int var2);

        public int getItemViewType(int i) {
            int group = 0;
            while (group < this.getGroupItemCount()) {
                if (i > 0 && !this.isExpanded(group)) {
                    --i;
                    ++group;
                    continue;
                }
                if (i > 0 && this.isExpanded(group)) {
                    if (--i < this.getChildItemCount(group)) {
                        return this.getChildItemViewType(group, i);
                    }
                    i -= this.getChildItemCount(group);
                    ++group;
                    continue;
                }
                if (i != 0) continue;
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }

        public void setOnChildItemClickedListener(OnChildItemClickedListener onItemClickedListener) {
            this.onChildItemClickedListener = onItemClickedListener;
        }

        public void onBindChildViewHolder(CVH holder, int group, int position) {
            ((RecyclerView.ViewHolder)holder).itemView.setAlpha(1.0f);
            ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(__ -> {
                if (this.onChildItemClickedListener != null) {
                    this.onChildItemClickedListener.onChildItemClicked(group, position);
                }
            });
        }

        public void onBindGroupViewHolder(GVH holder, int group) {
            if (holder instanceof GroupViewHolder) {
                ((GroupViewHolder)((Object)holder)).setExpanded(this.isExpanded(group));
            }
            ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(__ -> {
                if (this.isExpanded(group)) {
                    this.collapse(group);
                    if (holder instanceof GroupViewHolder) {
                        ((GroupViewHolder)((Object)holder)).collapse();
                    }
                } else {
                    this.expand(group);
                    if (holder instanceof GroupViewHolder) {
                        ((GroupViewHolder)((Object)holder)).expand();
                    }
                }
            });
        }
    }

    public static interface OnChildItemClickedListener {
        public void onChildItemClicked(int var1, int var2);
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        SparseBooleanArray stateToSave;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(ExpandableRecyclerView.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.stateToSave = in.readSparseBooleanArray();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeSparseBooleanArray(this.stateToSave);
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }
}

