/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.animation.AnimUtils;
import carbon.widget.FloatingActionMenu;
import carbon.widget.ImageView;
import carbon.widget.RecyclerView;

public class FloatingActionButton
extends ImageView {
    FloatingActionMenu floatingActionMenu;

    public FloatingActionButton(Context context) {
        super(context, null, R.attr.carbon_fabStyle);
        this.initFloatingActionButton(null, R.attr.carbon_fabStyle, R.style.carbon_FloatingActionButton);
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_fabStyle);
        this.initFloatingActionButton(attrs, R.attr.carbon_fabStyle, R.style.carbon_FloatingActionButton);
    }

    public FloatingActionButton(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFloatingActionButton(attrs, defStyleAttr, R.style.carbon_FloatingActionButton);
    }

    @TargetApi(value=21)
    public FloatingActionButton(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initFloatingActionButton(attrs, defStyleAttr, defStyleRes);
    }

    private void initFloatingActionButton(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        int resId;
        AnimUtils.setupElevationAnimator(this.getStateAnimator(), this);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FloatingActionButton, defStyleAttr, defStyleRes);
        if (a.hasValue(R.styleable.FloatingActionButton_carbon_menu) && (resId = a.getResourceId(R.styleable.FloatingActionButton_carbon_menu, 0)) != 0) {
            this.setMenu(resId);
        }
        a.recycle();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.invalidateMenu();
    }

    public void invalidateMenu() {
        if (this.floatingActionMenu != null) {
            this.floatingActionMenu.invalidate();
        }
    }

    public void setMenu(int resId) {
        this.floatingActionMenu = new FloatingActionMenu(this.getContext());
        this.floatingActionMenu.setMenu(resId);
        this.floatingActionMenu.setAnchor((View)this);
        this.setOnClickListener(__ -> this.floatingActionMenu.show());
    }

    public void setMenu(Menu menu) {
        if (menu != null) {
            this.floatingActionMenu = new FloatingActionMenu(this.getContext());
            this.floatingActionMenu.setMenu(menu);
            this.floatingActionMenu.setAnchor((View)this);
            this.setOnClickListener(__ -> this.floatingActionMenu.show());
        } else {
            this.floatingActionMenu = null;
            this.setOnClickListener(null);
        }
    }

    public void setMenuItems(FloatingActionMenu.Item[] items) {
        this.floatingActionMenu = new FloatingActionMenu(this.getContext());
        this.floatingActionMenu.setMenuItems(items);
        this.floatingActionMenu.setAnchor((View)this);
        this.setOnClickListener(__ -> this.floatingActionMenu.show());
    }

    public FloatingActionMenu getFloatingActionMenu() {
        return this.floatingActionMenu;
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<FloatingActionMenu.Item> listener) {
        if (this.floatingActionMenu != null) {
            this.floatingActionMenu.setOnItemClickedListener(listener);
        }
    }
}

