/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import androidx.core.view.MenuItemCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimUtils;
import carbon.component.FloatingActionMenuLeftRow;
import carbon.component.FloatingActionMenuRightRow;
import carbon.recycler.RowArrayAdapter;
import carbon.widget.LinearLayout;
import carbon.widget.RecyclerView;
import com.annimon.stream.Stream;
import java.io.Serializable;
import java.util.ArrayList;

public class FloatingActionMenu
extends PopupWindow {
    private final Handler handler;
    private final RecyclerView content = (RecyclerView)this.getContentView();
    private Item[] items;
    RecyclerView.OnItemClickedListener<Item> listener;
    private View anchor;
    private RowArrayAdapter<Item> adapter;

    public FloatingActionMenu(Context context) {
        super((View)new RecyclerView(context), -2, -2);
        this.content.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, -2));
        this.content.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.content.setPadding(0, this.content.getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf), 0, this.content.getResources().getDimensionPixelSize(R.dimen.carbon_paddingHalf));
        this.content.setOutAnimator((Animator)AnimUtils.getFadeOutAnimator());
        this.setBackgroundDrawable((Drawable)new ColorDrawable(context.getResources().getColor(17170445)));
        this.setTouchable(true);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setAnimationStyle(0);
        this.setClippingEnabled(false);
        this.handler = new Handler();
    }

    public void setAnchor(View anchor) {
        this.anchor = anchor;
    }

    public View getAnchor() {
        return this.anchor;
    }

    public void invalidate() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public boolean show() {
        int[] location = new int[2];
        this.anchor.getLocationOnScreen(location);
        WindowManager wm = (WindowManager)this.anchor.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        boolean left = location[0] < display.getWidth() + this.anchor.getWidth() - location[0];
        boolean top = location[1] < display.getHeight() + this.anchor.getHeight() - location[1];
        this.adapter = new RowArrayAdapter(this.items, left ? FloatingActionMenuLeftRow::new : FloatingActionMenuRightRow::new);
        this.content.setAdapter(this.adapter);
        this.adapter.setOnItemClickedListener((View view, I o, int position) -> {
            if (this.listener != null) {
                this.listener.onItemClicked(view, (Item)o, position);
            }
            this.dismiss();
        });
        this.content.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        super.showAtLocation(this.anchor, 51, 0, 0);
        if (!left & top) {
            this.update(location[0] - this.content.getMeasuredWidth() + this.anchor.getWidth(), location[1] + this.anchor.getHeight(), this.content.getMeasuredWidth(), this.content.getMeasuredHeight());
        } else if (!left & !top) {
            this.update(location[0] - this.content.getMeasuredWidth() + this.anchor.getWidth(), location[1] - this.content.getMeasuredHeight(), this.content.getMeasuredWidth(), this.content.getMeasuredHeight());
        } else if (left & !top) {
            this.update(location[0], location[1] - this.content.getMeasuredHeight(), this.content.getMeasuredWidth(), this.content.getMeasuredHeight());
        } else {
            this.update(location[0], location[1] + this.anchor.getHeight(), this.content.getMeasuredWidth(), this.content.getMeasuredHeight());
        }
        for (int i = 0; i < this.content.getChildCount(); ++i) {
            LinearLayout item = (LinearLayout)this.content.getChildAt(i);
            item.setVisibility(4);
            int delay = top ? i * 50 : (this.items.length - 1 - i) * 50;
            this.handler.postDelayed(() -> item.animateVisibility(0), (long)delay);
        }
        this.content.setAlpha(1.0f);
        this.content.setVisibility(0);
        return true;
    }

    public void dismiss() {
        this.content.animateVisibility(4).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionMenu.this.dismissImmediate();
            }
        });
    }

    public void dismissImmediate() {
        super.dismiss();
    }

    public void setMenu(int resId) {
        this.setMenu(Carbon.getMenu(this.getContentView().getContext(), resId));
    }

    public void setMenu(Menu menu) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < menu.size(); ++i) {
            if (!menu.getItem(i).isVisible()) continue;
            items.add(new Item(menu.getItem(i)));
        }
        this.items = (Item[])Stream.of(items).toArray(Item[]::new);
    }

    public void setMenuItems(Item[] items) {
        this.items = items;
    }

    public Item[] getMenuItems() {
        return this.items;
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<Item> listener) {
        this.listener = listener;
    }

    public static class Item
    implements Serializable {
        Drawable icon;
        ColorStateList tint;
        Drawable background;
        private boolean enabled;
        private CharSequence title;

        public Item(MenuItem item) {
            this.icon = item.getIcon();
            this.tint = MenuItemCompat.getIconTintList((MenuItem)item);
            this.enabled = item.isEnabled();
            this.title = item.getTitle();
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIconTintList(ColorStateList tint) {
            this.tint = tint;
        }

        public ColorStateList getIconTintList() {
            return this.tint;
        }

        public void setBackgroundDrawable(Drawable background) {
            this.background = background;
        }

        public Drawable getBackgroundDrawable() {
            return this.background;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setTitle(CharSequence title) {
            this.title = title;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }
}

