/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedView;
import carbon.animation.StateAnimator;
import carbon.behavior.Behavior;
import carbon.component.Component;
import carbon.component.ComponentView;
import carbon.drawable.ripple.RippleDrawable;
import carbon.drawable.ripple.RippleView;
import carbon.internal.ElevationComparator;
import carbon.internal.RevealAnimator;
import carbon.view.BehaviorView;
import carbon.view.InsetView;
import carbon.view.MarginView;
import carbon.view.MaxSizeView;
import carbon.view.RevealView;
import carbon.view.ShadowView;
import carbon.view.ShapeModelView;
import carbon.view.StateAnimatorView;
import carbon.view.StrokeView;
import carbon.view.TouchMarginView;
import carbon.view.TransformationView;
import carbon.view.VisibleView;
import carbon.widget.OnInsetsChangedListener;
import carbon.widget.OnTransformationChangedListener;
import com.annimon.stream.Stream;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowLayout
extends FrameLayout
implements ShadowView,
RippleView,
TouchMarginView,
StateAnimatorView,
AnimatedView,
ShapeModelView,
InsetView,
StrokeView,
MaxSizeView,
RevealView,
VisibleView,
TransformationView,
BehaviorView,
MarginView {
    private View.OnTouchListener onDispatchTouchListener;
    private static int[] rippleIds = new int[]{R.styleable.FlowLayout_carbon_rippleColor, R.styleable.FlowLayout_carbon_rippleStyle, R.styleable.FlowLayout_carbon_rippleHotspot, R.styleable.FlowLayout_carbon_rippleRadius};
    private static int[] animationIds = new int[]{R.styleable.FlowLayout_carbon_inAnimation, R.styleable.FlowLayout_carbon_outAnimation};
    private static int[] touchMarginIds = new int[]{R.styleable.FlowLayout_carbon_touchMargin, R.styleable.FlowLayout_carbon_touchMarginLeft, R.styleable.FlowLayout_carbon_touchMarginTop, R.styleable.FlowLayout_carbon_touchMarginRight, R.styleable.FlowLayout_carbon_touchMarginBottom};
    private static int[] insetIds = new int[]{R.styleable.FlowLayout_carbon_inset, R.styleable.FlowLayout_carbon_insetLeft, R.styleable.FlowLayout_carbon_insetTop, R.styleable.FlowLayout_carbon_insetRight, R.styleable.FlowLayout_carbon_insetBottom, R.styleable.FlowLayout_carbon_insetColor};
    private static int[] strokeIds = new int[]{R.styleable.FlowLayout_carbon_stroke, R.styleable.FlowLayout_carbon_strokeWidth};
    private static int[] cornerCutRadiusIds = new int[]{R.styleable.FlowLayout_carbon_cornerRadiusTopStart, R.styleable.FlowLayout_carbon_cornerRadiusTopEnd, R.styleable.FlowLayout_carbon_cornerRadiusBottomStart, R.styleable.FlowLayout_carbon_cornerRadiusBottomEnd, R.styleable.FlowLayout_carbon_cornerRadius, R.styleable.FlowLayout_carbon_cornerCutTopStart, R.styleable.FlowLayout_carbon_cornerCutTopEnd, R.styleable.FlowLayout_carbon_cornerCutBottomStart, R.styleable.FlowLayout_carbon_cornerCutBottomEnd, R.styleable.FlowLayout_carbon_cornerCut};
    private static int[] maxSizeIds = new int[]{R.styleable.FlowLayout_carbon_maxWidth, R.styleable.FlowLayout_carbon_maxHeight};
    private static int[] elevationIds = new int[]{R.styleable.FlowLayout_carbon_elevation, R.styleable.FlowLayout_carbon_elevationShadowColor, R.styleable.FlowLayout_carbon_elevationAmbientShadowColor, R.styleable.FlowLayout_carbon_elevationSpotShadowColor};
    private Paint paint = new Paint(3);
    private boolean drawCalled = false;
    RevealAnimator revealAnimator;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int gravity;
    private RectF boundsRect = new RectF();
    private Path cornersMask = new Path();
    private RippleDrawable rippleDrawable;
    private float elevation = 0.0f;
    private float translationZ = 0.0f;
    private ShapeAppearanceModel shapeModel = new ShapeAppearanceModel();
    private MaterialShapeDrawable shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
    private ColorStateList ambientShadowColor;
    private ColorStateList spotShadowColor;
    private Rect touchMargin = new Rect();
    final RectF tmpHitRect = new RectF();
    private StateAnimator stateAnimator = new StateAnimator(this);
    private Animator inAnim = null;
    private Animator outAnim = null;
    private Animator animator;
    int insetLeft = -1;
    int insetTop = -1;
    int insetRight = -1;
    int insetBottom = -1;
    int insetColor;
    private OnInsetsChangedListener onInsetsChangedListener;
    List<View> views = new ArrayList<View>();
    private ColorStateList stroke;
    private float strokeWidth;
    private Paint strokePaint;
    int maxWidth = Integer.MAX_VALUE;
    int maxHeight = Integer.MAX_VALUE;
    List<OnTransformationChangedListener> transformationChangedListeners = new ArrayList<OnTransformationChangedListener>();
    private List<Behavior> behaviors = new ArrayList<Behavior>();

    public FlowLayout(Context context) {
        super(context, null, R.attr.carbon_flowLayoutStyle);
        this.initFlowLayout(null, R.attr.carbon_flowLayoutStyle, R.style.carbon_FlowLayout);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_flowLayoutStyle);
        this.initFlowLayout(attrs, R.attr.carbon_flowLayoutStyle, R.style.carbon_FlowLayout);
    }

    public FlowLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFlowLayout(attrs, defStyleAttr, R.style.carbon_FlowLayout);
    }

    @TargetApi(value=21)
    public FlowLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initFlowLayout(attrs, defStyleAttr, defStyleRes);
    }

    private void initFlowLayout(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FlowLayout, defStyleAttr, defStyleRes);
        Carbon.initDefaultBackground((View)this, a, R.styleable.FlowLayout_android_background);
        Carbon.initElevation(this, a, elevationIds);
        Carbon.initRippleDrawable(this, a, rippleIds);
        Carbon.initAnimations(this, a, animationIds);
        Carbon.initTouchMargin(this, a, touchMarginIds);
        Carbon.initInset(this, a, insetIds);
        Carbon.initMaxSize(this, a, maxSizeIds);
        Carbon.initStroke(this, a, strokeIds);
        Carbon.initCornerCutRadius(this, a, cornerCutRadiusIds);
        this.gravity = a.getInt(R.styleable.FlowLayout_android_gravity, 0x800003);
        this.horizontalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_carbon_spacingHorizontal, 0);
        this.verticalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_carbon_spacingVertical, 0);
        a.recycle();
        this.setChildrenDrawingOrderEnabled(true);
        this.setClipToPadding(false);
    }

    public Point getLocationOnScreen() {
        int[] outLocation = new int[2];
        super.getLocationOnScreen(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    public Point getLocationInWindow() {
        int[] outLocation = new int[2];
        super.getLocationInWindow(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(View hotspot, float startRadius, float finishRadius) {
        int[] location = new int[2];
        hotspot.getLocationOnScreen(location);
        int[] myLocation = new int[2];
        this.getLocationOnScreen(myLocation);
        return this.createCircularReveal(location[0] - myLocation[0] + hotspot.getWidth() / 2, location[1] - myLocation[1] + hotspot.getHeight() / 2, startRadius, finishRadius);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(int x, int y, float startRadius, float finishRadius) {
        startRadius = Carbon.getRevealRadius((View)this, x, y, startRadius);
        finishRadius = Carbon.getRevealRadius((View)this, x, y, finishRadius);
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            Animator circularReveal = ViewAnimationUtils.createCircularReveal((View)this, (int)x, (int)y, (float)startRadius, (float)finishRadius);
            circularReveal.setDuration(Carbon.getDefaultRevealDuration());
            return circularReveal;
        }
        this.revealAnimator = new RevealAnimator(x, y, startRadius, finishRadius);
        this.revealAnimator.setDuration(Carbon.getDefaultRevealDuration());
        this.revealAnimator.addUpdateListener(animation -> {
            RevealAnimator reveal = (RevealAnimator)animation;
            reveal.radius = ((Float)reveal.getAnimatedValue()).floatValue();
            reveal.mask.reset();
            reveal.mask.addCircle(reveal.x, reveal.y, Math.max(((Float)reveal.getAnimatedValue()).floatValue(), 1.0f), Path.Direction.CW);
            this.postInvalidate();
        });
        this.revealAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                FlowLayout.this.revealAnimator = null;
            }

            public void onAnimationEnd(Animator animation) {
                FlowLayout.this.revealAnimator = null;
            }
        });
        return this.revealAnimator;
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        boolean c;
        boolean r = this.revealAnimator != null && this.revealAnimator.isRunning();
        boolean bl = c = !Carbon.isShapeRect(this.shapeModel, this.boundsRect);
        if (Carbon.IS_PIE_OR_HIGHER) {
            if (this.spotShadowColor != null) {
                super.setOutlineSpotShadowColor(this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()));
            }
            if (this.ambientShadowColor != null) {
                super.setOutlineAmbientShadowColor(this.ambientShadowColor.getColorForState(this.getDrawableState(), this.ambientShadowColor.getDefaultColor()));
            }
        }
        if (this.isInEditMode() && !this.drawCalled && (r || c) && this.getWidth() > 0 && this.getHeight() > 0) {
            Bitmap layer = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas layerCanvas = new Canvas(layer);
            this.dispatchDrawInternal(layerCanvas);
            Bitmap mask = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mask);
            Paint maskPaint = new Paint(-1);
            maskCanvas.drawPath(this.cornersMask, maskPaint);
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int maskPixel = mask.getPixel(x, y);
                    layer.setPixel(x, y, Color.alpha((int)maskPixel) > 0 ? layer.getPixel(x, y) : 0);
                }
            }
            canvas.drawBitmap(layer, 0.0f, 0.0f, this.paint);
        } else if (!this.drawCalled && (r || c) && this.getWidth() > 0 && this.getHeight() > 0 && !Carbon.IS_LOLLIPOP_OR_HIGHER) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            if (r) {
                int saveCount2 = canvas.save();
                canvas.clipRect(this.revealAnimator.x - this.revealAnimator.radius, this.revealAnimator.y - this.revealAnimator.radius, this.revealAnimator.x + this.revealAnimator.radius, this.revealAnimator.y + this.revealAnimator.radius);
                this.dispatchDrawInternal(canvas);
                canvas.restoreToCount(saveCount2);
            } else {
                this.dispatchDrawInternal(canvas);
            }
            this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
            if (c) {
                this.cornersMask.setFillType(Path.FillType.INVERSE_WINDING);
                canvas.drawPath(this.cornersMask, this.paint);
            }
            if (r) {
                canvas.drawPath(this.revealAnimator.mask, this.paint);
            }
            this.paint.setXfermode(null);
            canvas.restoreToCount(saveCount);
        } else {
            this.dispatchDrawInternal(canvas);
        }
        this.drawCalled = false;
    }

    private void dispatchDrawInternal(@NonNull Canvas canvas) {
        Collections.sort(this.getViews(), new ElevationComparator());
        super.dispatchDraw(canvas);
        if (this.stroke != null) {
            this.drawStroke(canvas);
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
        if (this.insetColor != 0) {
            this.paint.setColor(this.insetColor);
            this.paint.setAlpha(255);
            if (this.insetLeft != 0) {
                canvas.drawRect(0.0f, 0.0f, (float)this.insetLeft, (float)this.getHeight(), this.paint);
            }
            if (this.insetTop != 0) {
                canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.insetTop, this.paint);
            }
            if (this.insetRight != 0) {
                canvas.drawRect((float)(this.getWidth() - this.insetRight), 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
            }
            if (this.insetBottom != 0) {
                canvas.drawRect(0.0f, (float)(this.getHeight() - this.insetBottom), (float)this.getWidth(), (float)this.getHeight(), this.paint);
            }
        }
    }

    protected boolean drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        RippleView rippleView;
        RippleDrawable rippleDrawable;
        if (child instanceof ShadowView && (!Carbon.IS_LOLLIPOP_OR_HIGHER || ((ShadowView)child).getElevationShadowColor() != null && !Carbon.IS_PIE_OR_HIGHER)) {
            ShadowView shadowView = (ShadowView)child;
            shadowView.drawShadow(canvas);
        }
        if (child instanceof RippleView && (rippleDrawable = (rippleView = (RippleView)child).getRippleDrawable()) != null && rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            int saveCount = canvas.save();
            canvas.translate((float)child.getLeft(), (float)child.getTop());
            canvas.concat(child.getMatrix());
            rippleDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    protected int getChildDrawingOrder(int childCount, int child) {
        if (this.views.size() != childCount) {
            this.getViews();
        }
        return this.indexOfChild(this.views.get(child));
    }

    protected boolean isTransformedTouchPointInView(float x, float y, View child, PointF outLocalPoint) {
        Rect frame = new Rect();
        child.getHitRect(frame);
        return frame.contains((int)x, (int)y);
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        if (this.gravity != gravity) {
            this.gravity = gravity;
            this.requestLayout();
        }
    }

    public void setSpacing(int horizontalSpacing, int verticalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
        this.verticalSpacing = verticalSpacing;
    }

    private void layoutFlowingViews(int width) {
        int gravity = GravityCompat.getAbsoluteGravity((int)this.gravity, (int)ViewCompat.getLayoutDirection((View)this));
        if ((gravity & 5) == 5) {
            this.layoutFlowingViewsRight(width);
        } else {
            this.layoutFlowingViewsLeft(width);
        }
    }

    private void relayoutLine(List<View> currentLine) {
        LayoutParams params;
        if (currentLine.size() < 2) {
            return;
        }
        int maxY = Integer.MIN_VALUE;
        int minY = currentLine.get(0).getTop() - ((LayoutParams)currentLine.get((int)0).getLayoutParams()).topMargin;
        for (View view : currentLine) {
            params = (LayoutParams)view.getLayoutParams();
            maxY = Math.max(maxY, view.getBottom() + params.bottomMargin);
        }
        for (View view : currentLine) {
            params = (LayoutParams)view.getLayoutParams();
            if ((params.gravity & 0x30) == 48) {
                view.layout(view.getLeft(), minY + params.topMargin, view.getRight(), minY + view.getHeight() + params.topMargin);
                continue;
            }
            if ((params.gravity & 0x50) == 80) {
                view.layout(view.getLeft(), maxY - view.getHeight() - params.bottomMargin, view.getRight(), maxY - params.bottomMargin);
                continue;
            }
            if ((params.gravity & 0x10) != 16) continue;
            int top = Math.max((maxY + minY) / 2 - view.getHeight() / 2, minY + params.topMargin);
            int bottom = top + view.getHeight();
            view.layout(view.getLeft(), top, view.getRight(), bottom);
        }
    }

    private void layoutFlowingViewsRight(int width) {
        int currentX = width - this.getPaddingRight();
        int currentY = this.getPaddingTop();
        int nextY = this.getPaddingTop();
        ArrayList<View> currentLine = new ArrayList<View>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            if (currentX != width - this.getPaddingRight() && currentX - params.leftMargin - child.getMeasuredWidth() - params.rightMargin < this.getPaddingLeft()) {
                currentX = width - this.getPaddingRight();
                currentY = nextY + this.verticalSpacing;
                this.relayoutLine(currentLine);
                currentLine.clear();
            }
            currentLine.add(0, child);
            int left = params.fill ? this.getPaddingLeft() + params.leftMargin : currentX - params.rightMargin - child.getMeasuredWidth();
            child.layout(left, currentY + params.topMargin, currentX - params.rightMargin, currentY + params.topMargin + child.getMeasuredHeight());
            currentX -= params.leftMargin + child.getMeasuredWidth() + params.rightMargin - this.horizontalSpacing;
            nextY = Math.max(nextY, currentY + params.topMargin + child.getMeasuredHeight() + params.bottomMargin);
            if (!params.fill) continue;
            currentX = width - this.getPaddingRight();
            currentY = nextY + this.verticalSpacing;
            this.relayoutLine(currentLine);
            currentLine.clear();
        }
        this.relayoutLine(currentLine);
    }

    private void layoutFlowingViewsLeft(int width) {
        int currentX = this.getPaddingLeft();
        int currentY = this.getPaddingTop();
        int nextY = this.getPaddingTop();
        ArrayList<View> currentLine = new ArrayList<View>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            if (currentX != this.getPaddingLeft() && currentX + params.leftMargin + child.getMeasuredWidth() + params.rightMargin > width - this.getPaddingRight()) {
                currentX = this.getPaddingLeft();
                currentY = nextY + this.verticalSpacing;
                this.relayoutLine(currentLine);
                currentLine.clear();
            }
            currentLine.add(child);
            int right = params.fill ? width - this.getPaddingRight() - params.rightMargin : currentX + params.leftMargin + child.getMeasuredWidth();
            child.layout(currentX + params.leftMargin, currentY + params.topMargin, right, currentY + params.topMargin + child.getMeasuredHeight());
            currentX += params.leftMargin + child.getMeasuredWidth() + params.rightMargin + this.horizontalSpacing;
            nextY = Math.max(nextY, currentY + params.topMargin + child.getMeasuredHeight() + params.bottomMargin);
            if (!params.fill) continue;
            currentX = this.getPaddingLeft();
            currentY = nextY + this.verticalSpacing;
            this.relayoutLine(currentLine);
            currentLine.clear();
        }
        this.relayoutLine(currentLine);
    }

    private int measureWidth() {
        int currentX = this.getPaddingLeft();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            currentX += params.leftMargin + child.getMeasuredWidth() + params.rightMargin + this.horizontalSpacing;
        }
        return currentX + this.getPaddingRight();
    }

    private int measureHeight(int width) {
        int currentX = this.getPaddingLeft();
        int currentY = this.getPaddingTop();
        int nextY = this.getPaddingTop();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            if (currentX != this.getPaddingLeft() && currentX + params.leftMargin + child.getMeasuredWidth() + params.rightMargin > width - this.getPaddingRight()) {
                currentX = this.getPaddingLeft();
                currentY = nextY + this.verticalSpacing;
            }
            if (params.fill) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)(width - this.getPaddingRight() - params.leftMargin - params.rightMargin - currentX), (int)0x40000000), child.getMeasuredHeightAndState());
            }
            currentX += params.leftMargin + child.getMeasuredWidth() + params.rightMargin + this.horizontalSpacing;
            nextY = Math.max(nextY, currentY + params.topMargin + child.getMeasuredHeight() + params.bottomMargin);
            if (!params.fill) continue;
            currentX = this.getPaddingLeft();
            currentY = nextY + this.verticalSpacing;
        }
        return nextY + this.getPaddingBottom();
    }

    protected void measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
    }

    @Override
    @NotNull
    public ShapeAppearanceModel getShapeModel() {
        return this.shapeModel;
    }

    @Override
    public void setCornerRadius(float cornerRadius) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new RoundedCornerTreatment(cornerRadius)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setCornerCut(float cornerCut) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new CutCornerTreatment(cornerCut)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setShapeModel(@NotNull ShapeAppearanceModel model) {
        this.shapeModel = model;
        this.shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.updateCorners();
        }
        if (!Carbon.IS_LOLLIPOP_OR_HIGHER) {
            this.postInvalidate();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layoutFlowingViews(this.getWidth());
        if (!changed) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.updateCorners();
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void updateCorners() {
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (!Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
                this.setClipToOutline(true);
            }
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (Carbon.isShapeRect(FlowLayout.this.shapeModel, FlowLayout.this.boundsRect)) {
                        outline.setRect(0, 0, FlowLayout.this.getWidth(), FlowLayout.this.getHeight());
                    } else {
                        FlowLayout.this.shadowDrawable.setBounds(0, 0, FlowLayout.this.getWidth(), FlowLayout.this.getHeight());
                        FlowLayout.this.shadowDrawable.setShadowCompatibilityMode(1);
                        FlowLayout.this.shadowDrawable.getOutline(outline);
                    }
                }
            });
        }
        this.boundsRect.set(this.shadowDrawable.getBounds());
        this.shadowDrawable.getPathForSize(this.getWidth(), this.getHeight(), this.cornersMask);
    }

    public void drawInternal(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.stroke != null) {
            this.drawStroke(canvas);
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(@NonNull Canvas canvas) {
        boolean c;
        this.drawCalled = true;
        boolean r = this.revealAnimator != null;
        boolean bl = c = !Carbon.isShapeRect(this.shapeModel, this.boundsRect);
        if (Carbon.IS_PIE_OR_HIGHER) {
            if (this.spotShadowColor != null) {
                super.setOutlineSpotShadowColor(this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()));
            }
            if (this.ambientShadowColor != null) {
                super.setOutlineAmbientShadowColor(this.ambientShadowColor.getColorForState(this.getDrawableState(), this.ambientShadowColor.getDefaultColor()));
            }
        }
        if (this.isInEditMode() && (r || c) && this.getWidth() > 0 && this.getHeight() > 0) {
            Bitmap layer = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas layerCanvas = new Canvas(layer);
            this.drawInternal(layerCanvas);
            Bitmap mask = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mask);
            Paint maskPaint = new Paint(-1);
            maskCanvas.drawPath(this.cornersMask, maskPaint);
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int maskPixel = mask.getPixel(x, y);
                    layer.setPixel(x, y, Color.alpha((int)maskPixel) > 0 ? layer.getPixel(x, y) : 0);
                }
            }
            canvas.drawBitmap(layer, 0.0f, 0.0f, this.paint);
        } else if (this.getWidth() > 0 && this.getHeight() > 0 && ((r || c) && !Carbon.IS_LOLLIPOP_OR_HIGHER || !this.shapeModel.isRoundRect(this.boundsRect))) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            if (r) {
                int saveCount2 = canvas.save();
                canvas.clipRect(this.revealAnimator.x - this.revealAnimator.radius, this.revealAnimator.y - this.revealAnimator.radius, this.revealAnimator.x + this.revealAnimator.radius, this.revealAnimator.y + this.revealAnimator.radius);
                this.drawInternal(canvas);
                canvas.restoreToCount(saveCount2);
            } else {
                this.drawInternal(canvas);
            }
            this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
            if (c) {
                this.cornersMask.setFillType(Path.FillType.INVERSE_WINDING);
                canvas.drawPath(this.cornersMask, this.paint);
            }
            if (r) {
                canvas.drawPath(this.revealAnimator.mask, this.paint);
            }
            this.paint.setXfermode(null);
            canvas.restoreToCount(saveCount);
            this.paint.setXfermode(null);
        } else {
            this.drawInternal(canvas);
        }
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (this.shadowDrawable.isPointInTransparentRegion((int)event.getX(), (int)event.getY())) {
            return false;
        }
        if (this.onDispatchTouchListener != null && this.onDispatchTouchListener.onTouch((View)this, event)) {
            return true;
        }
        if (this.rippleDrawable != null && event.getAction() == 0) {
            this.rippleDrawable.setHotspot(event.getX(), event.getY());
        }
        return super.dispatchTouchEvent(event);
    }

    @Override
    public RippleDrawable getRippleDrawable() {
        return this.rippleDrawable;
    }

    @Override
    public void setRippleDrawable(RippleDrawable newRipple) {
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setCallback(null);
            if (this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable(this.rippleDrawable.getBackground());
            }
        }
        if (newRipple != null) {
            newRipple.setCallback((Drawable.Callback)this);
            newRipple.setBounds(0, 0, this.getWidth(), this.getHeight());
            newRipple.setState(this.getDrawableState());
            ((Drawable)newRipple).setVisible(this.getVisibility() == 0, false);
            if (newRipple.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable((Drawable)newRipple);
            }
        }
        this.rippleDrawable = newRipple;
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || this.rippleDrawable == who;
    }

    public void invalidateDrawable(@NonNull Drawable drawable2) {
        super.invalidateDrawable(drawable2);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(@NonNull Rect dirty) {
        super.invalidate(dirty);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(int l, int t, int r, int b) {
        super.invalidate(l, t, r, b);
        this.invalidateParentIfNeeded();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateParentIfNeeded();
    }

    private void invalidateParentIfNeeded() {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).invalidate();
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).invalidate();
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        super.postInvalidateDelayed(delayMilliseconds);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        super.postInvalidateDelayed(delayMilliseconds, left, top, right, bottom);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    private void postInvalidateParentIfNeededDelayed(long delayMilliseconds) {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background instanceof RippleDrawable) {
            this.setRippleDrawable((RippleDrawable)background);
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
            this.rippleDrawable.setCallback(null);
            this.rippleDrawable = null;
        }
        super.setBackgroundDrawable(background);
    }

    @Override
    public float getElevation() {
        return this.elevation;
    }

    @Override
    public void setElevation(float elevation) {
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setElevation(elevation);
            super.setTranslationZ(this.translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setElevation(elevation);
                super.setTranslationZ(this.translationZ);
            } else {
                super.setElevation(0.0f);
                super.setTranslationZ(0.0f);
            }
        } else if (elevation != this.elevation && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.elevation = elevation;
    }

    @Override
    public float getTranslationZ() {
        return this.translationZ;
    }

    @Override
    public void setTranslationZ(float translationZ) {
        if (translationZ == this.translationZ) {
            return;
        }
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setTranslationZ(translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setTranslationZ(translationZ);
            } else {
                super.setTranslationZ(0.0f);
            }
        } else if (translationZ != this.translationZ && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.translationZ = translationZ;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public boolean hasShadow() {
        return this.getElevation() + this.getTranslationZ() >= 0.01f && this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public void drawShadow(@NotNull Canvas canvas) {
        int saveCount;
        boolean r;
        float alpha = this.getAlpha() * Carbon.getBackgroundTintAlpha((View)this) / 255.0f;
        if (alpha == 0.0f || !this.hasShadow()) {
            return;
        }
        float z = this.getElevation() + this.getTranslationZ();
        boolean maskShadow = this.getBackground() != null && alpha != 1.0f;
        boolean bl = r = this.revealAnimator != null && this.revealAnimator.isRunning();
        if (alpha != 1.0f) {
            this.paint.setAlpha((int)(255.0f * alpha));
            saveCount = canvas.saveLayer(-z, -z, (float)canvas.getWidth() + z, (float)canvas.getHeight() + z, this.paint, 31);
        } else {
            saveCount = canvas.save();
        }
        if (r) {
            canvas.clipRect((float)this.getLeft() + this.revealAnimator.x - this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y - this.revealAnimator.radius, (float)this.getLeft() + this.revealAnimator.x + this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y + this.revealAnimator.radius);
        }
        this.shadowDrawable.setFillColor(this.spotShadowColor);
        this.shadowDrawable.setShadowColor(this.spotShadowColor != null ? this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()) : -16777216);
        this.shadowDrawable.setShadowCompatibilityMode(2);
        this.shadowDrawable.setAlpha(68);
        this.shadowDrawable.setElevation(z);
        this.shadowDrawable.setShadowVerticalOffset(0);
        this.shadowDrawable.setBounds(this.getLeft(), (int)((float)this.getTop() + z / 4.0f), this.getRight(), (int)((float)this.getBottom() + z / 4.0f));
        this.shadowDrawable.draw(canvas);
        canvas.translate((float)this.getLeft(), (float)this.getTop());
        this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
        if (maskShadow) {
            this.cornersMask.setFillType(Path.FillType.WINDING);
            canvas.drawPath(this.cornersMask, this.paint);
        }
        if (r) {
            canvas.drawPath(this.revealAnimator.mask, this.paint);
        }
        canvas.restoreToCount(saveCount);
        this.paint.setXfermode(null);
        this.paint.setAlpha(255);
    }

    @Override
    public void setElevationShadowColor(ColorStateList shadowColor) {
        this.ambientShadowColor = this.spotShadowColor = shadowColor;
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public void setElevationShadowColor(int color2) {
        this.ambientShadowColor = this.spotShadowColor = ColorStateList.valueOf((int)color2);
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public ColorStateList getElevationShadowColor() {
        return this.ambientShadowColor;
    }

    @Override
    public void setOutlineAmbientShadowColor(int color2) {
        this.setOutlineAmbientShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineAmbientShadowColor(ColorStateList color2) {
        this.ambientShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineAmbientShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineAmbientShadowColor() {
        return this.ambientShadowColor.getDefaultColor();
    }

    @Override
    public void setOutlineSpotShadowColor(int color2) {
        this.setOutlineSpotShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineSpotShadowColor(ColorStateList color2) {
        this.spotShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineSpotShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineSpotShadowColor() {
        return this.spotShadowColor.getDefaultColor();
    }

    @Override
    public void setTouchMargin(int left, int top, int right, int bottom) {
        this.touchMargin.set(left, top, right, bottom);
    }

    @Override
    public void setTouchMarginLeft(int margin) {
        this.touchMargin.left = margin;
    }

    @Override
    public void setTouchMarginTop(int margin) {
        this.touchMargin.top = margin;
    }

    @Override
    public void setTouchMarginRight(int margin) {
        this.touchMargin.right = margin;
    }

    @Override
    public void setTouchMarginBottom(int margin) {
        this.touchMargin.bottom = margin;
    }

    @Override
    @NotNull
    public Rect getTouchMargin() {
        return this.touchMargin;
    }

    public void getHitRect(@NonNull Rect outRect) {
        Matrix matrix = this.getMatrix();
        if (matrix.isIdentity()) {
            outRect.set(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        } else {
            this.tmpHitRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            matrix.mapRect(this.tmpHitRect);
            outRect.set((int)this.tmpHitRect.left + this.getLeft(), (int)this.tmpHitRect.top + this.getTop(), (int)this.tmpHitRect.right + this.getLeft(), (int)this.tmpHitRect.bottom + this.getTop());
        }
        outRect.left -= this.touchMargin.left;
        outRect.top -= this.touchMargin.top;
        outRect.right += this.touchMargin.right;
        outRect.bottom += this.touchMargin.bottom;
    }

    @Override
    @NotNull
    public StateAnimator getStateAnimator() {
        return this.stateAnimator;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() != RippleDrawable.Style.Background) {
            this.rippleDrawable.setState(this.getDrawableState());
        }
        if (this.stateAnimator != null) {
            this.stateAnimator.setState(this.getDrawableState());
        }
    }

    @Override
    public Animator animateVisibility(final int visibility) {
        if (visibility == 0 && (this.getVisibility() != 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.inAnim != null) {
                this.animator = this.inAnim;
                this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        FlowLayout.this.animator = null;
                    }

                    public void onAnimationCancel(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        FlowLayout.this.animator = null;
                    }
                });
                this.animator.start();
            }
            this.setVisibility(visibility);
        } else if (visibility != 0 && (this.getVisibility() == 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.outAnim == null) {
                this.setVisibility(visibility);
                return null;
            }
            this.animator = this.outAnim;
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator a) {
                    if (((ValueAnimator)a).getAnimatedFraction() == 1.0f) {
                        FlowLayout.this.setVisibility(visibility);
                    }
                    a.removeListener((Animator.AnimatorListener)this);
                    FlowLayout.this.animator = null;
                }

                public void onAnimationCancel(Animator a) {
                    a.removeListener((Animator.AnimatorListener)this);
                    FlowLayout.this.animator = null;
                }
            });
            this.animator.start();
        } else {
            this.setVisibility(visibility);
        }
        return this.animator;
    }

    @Override
    public Animator getAnimator() {
        return this.animator;
    }

    @Override
    public Animator getOutAnimator() {
        return this.outAnim;
    }

    @Override
    public void setOutAnimator(Animator outAnim) {
        if (this.outAnim != null) {
            this.outAnim.setTarget(null);
        }
        this.outAnim = outAnim;
        if (outAnim != null) {
            outAnim.setTarget((Object)this);
        }
    }

    @Override
    public Animator getInAnimator() {
        return this.inAnim;
    }

    @Override
    public void setInAnimator(Animator inAnim) {
        if (this.inAnim != null) {
            this.inAnim.setTarget(null);
        }
        this.inAnim = inAnim;
        if (inAnim != null) {
            inAnim.setTarget((Object)this);
        }
    }

    @Override
    public int getInsetColor() {
        return this.insetColor;
    }

    @Override
    public void setInsetColor(int insetsColor) {
        this.insetColor = insetsColor;
    }

    @Override
    public void setInset(int left, int top, int right, int bottom) {
        this.insetLeft = left;
        this.insetTop = top;
        this.insetRight = right;
        this.insetBottom = bottom;
    }

    @Override
    public int getInsetLeft() {
        return this.insetLeft;
    }

    @Override
    public void setInsetLeft(int insetLeft) {
        this.insetLeft = insetLeft;
    }

    @Override
    public int getInsetTop() {
        return this.insetTop;
    }

    @Override
    public void setInsetTop(int insetTop) {
        this.insetTop = insetTop;
    }

    @Override
    public int getInsetRight() {
        return this.insetRight;
    }

    @Override
    public void setInsetRight(int insetRight) {
        this.insetRight = insetRight;
    }

    @Override
    public int getInsetBottom() {
        return this.insetBottom;
    }

    @Override
    public void setInsetBottom(int insetBottom) {
        this.insetBottom = insetBottom;
    }

    protected boolean fitSystemWindows(@NonNull Rect insets) {
        if (this.insetLeft == -1) {
            this.insetLeft = insets.left;
        }
        if (this.insetTop == -1) {
            this.insetTop = insets.top;
        }
        if (this.insetRight == -1) {
            this.insetRight = insets.right;
        }
        if (this.insetBottom == -1) {
            this.insetBottom = insets.bottom;
        }
        insets.set(this.insetLeft, this.insetTop, this.insetRight, this.insetBottom);
        if (this.onInsetsChangedListener != null) {
            this.onInsetsChangedListener.onInsetsChanged();
        }
        this.postInvalidate();
        return super.fitSystemWindows(insets);
    }

    @Override
    public void setOnInsetsChangedListener(OnInsetsChangedListener onInsetsChangedListener) {
        this.onInsetsChangedListener = onInsetsChangedListener;
    }

    public List<View> getViews() {
        this.views.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.views.add(this.getChildAt(i));
        }
        return this.views;
    }

    public void setOnDispatchTouchListener(View.OnTouchListener onDispatchTouchListener) {
        this.onDispatchTouchListener = onDispatchTouchListener;
    }

    public Component findComponentById(int id2) {
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child instanceof ComponentView && ((Component)((ComponentView)child).getComponent()).getView().getId() == id2) {
                    return ((ComponentView)child).getComponent();
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return null;
    }

    public List<Component> findComponentsById(int id2) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child instanceof ComponentView && ((Component)((ComponentView)child).getComponent()).getView().getId() == id2) {
                    result.add((Component)((ComponentView)child).getComponent());
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return result;
    }

    public Component findComponentOfType(Class type) {
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child instanceof ComponentView && ((ComponentView)child).getComponent().getClass().equals(type)) {
                    return ((ComponentView)child).getComponent();
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return null;
    }

    public List<Component> findComponentsOfType(Class type) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child instanceof ComponentView && ((ComponentView)child).getComponent().getClass().equals(type)) {
                    result.add((Component)((ComponentView)child).getComponent());
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return result;
    }

    public <Type extends View> Type findViewOfType(Class<Type> type) {
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child.getClass().equals(type)) {
                    return (Type)child;
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return null;
    }

    public <Type extends View> List<Type> findViewsOfType(Class<Type> type) {
        ArrayList<View> result = new ArrayList<View>();
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child.getClass().equals(type)) {
                    result.add(child);
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return result;
    }

    public List<View> findViewsById(int id2) {
        ArrayList<View> result = new ArrayList<View>();
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (child.getId() == id2) {
                    result.add(child);
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return result;
    }

    public List<View> findViewsWithTag(Object tag) {
        ArrayList<View> result = new ArrayList<View>();
        ArrayList<FlowLayout> groups = new ArrayList<FlowLayout>();
        groups.add(this);
        while (!groups.isEmpty()) {
            ViewGroup group = (ViewGroup)groups.remove(0);
            for (int i = 0; i < group.getChildCount(); ++i) {
                View child = group.getChildAt(i);
                if (tag.equals(child.getTag())) {
                    result.add(child);
                }
                if (!(child instanceof ViewGroup)) continue;
                groups.add((FlowLayout)((ViewGroup)child));
            }
        }
        return result;
    }

    public View inflate(@LayoutRes int id2) {
        return LayoutInflater.from((Context)this.getContext()).inflate(id2, (ViewGroup)this);
    }

    public View inflate(@LayoutRes int id2, boolean attach) {
        return LayoutInflater.from((Context)this.getContext()).inflate(id2, (ViewGroup)this, attach);
    }

    private void drawStroke(Canvas canvas) {
        this.strokePaint.setStrokeWidth(this.strokeWidth * 2.0f);
        this.strokePaint.setColor(this.stroke.getColorForState(this.getDrawableState(), this.stroke.getDefaultColor()));
        this.cornersMask.setFillType(Path.FillType.WINDING);
        canvas.drawPath(this.cornersMask, this.strokePaint);
    }

    @Override
    public void setStroke(ColorStateList colorStateList) {
        this.stroke = colorStateList;
        if (this.stroke == null) {
            return;
        }
        if (this.strokePaint == null) {
            this.strokePaint = new Paint(1);
            this.strokePaint.setStyle(Paint.Style.STROKE);
        }
    }

    @Override
    public void setStroke(int color2) {
        this.setStroke(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getStroke() {
        return this.stroke;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Override
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.requestLayout();
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.requestLayout();
    }

    private void onMeasureInternal(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            width = this.measureWidth();
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.measureHeight(width);
            height = Math.max(height, this.getSuggestedMinimumHeight());
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        this.onMeasureInternal(widthMeasureSpec, heightMeasureSpec);
        if (this.getMeasuredWidth() > this.maxWidth || this.getMeasuredHeight() > this.maxHeight) {
            if (this.getMeasuredWidth() > this.maxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)0x40000000);
            }
            if (this.getMeasuredHeight() > this.maxHeight) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)0x40000000);
            }
            this.onMeasureInternal(widthMeasureSpec, heightMeasureSpec);
        }
        if (this.getMeasuredHeight() > this.maxHeight) {
            if (this.getMeasuredHeight() > this.maxHeight) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)0x40000000);
            }
            this.onMeasureInternal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    public void addOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.add(listener);
    }

    @Override
    public void removeOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.remove(listener);
    }

    @Override
    public void clearOnTransformationChangedListeners() {
        this.transformationChangedListeners.clear();
    }

    private void fireOnTransformationChangedListener() {
        if (this.transformationChangedListeners == null) {
            return;
        }
        for (OnTransformationChangedListener listener : this.transformationChangedListeners) {
            listener.onTransformationChanged();
        }
    }

    public void setRotation(float rotation) {
        super.setRotation(rotation);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationY(float rotationY) {
        super.setRotationY(rotationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationX(float rotationX) {
        super.setRotationX(rotationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleX(float scaleX) {
        super.setScaleX(scaleX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleY(float scaleY) {
        super.setScaleY(scaleY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotX(float pivotX) {
        super.setPivotX(pivotX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotY(float pivotY) {
        super.setPivotY(pivotY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        super.setAlpha(alpha);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, -2));
        } else {
            layoutParams.width = width;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, height));
        } else {
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        } else {
            layoutParams.width = width;
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setTranslationX(x);
        this.setTranslationY(y);
    }

    public void addBehavior(@NotNull Behavior behavior) {
        this.behaviors.add(behavior);
    }

    public void removeBehavior(@NotNull Behavior behavior) {
        this.behaviors.remove(behavior);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Stream.of(this.behaviors).forEach(Behavior::onDetachedFromWindow);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Stream.of(this.behaviors).forEach(Behavior::onAttachedToWindow);
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        private boolean fill = false;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FlowLayout_Layout);
            this.fill = a.getBoolean(R.styleable.FlowLayout_Layout_carbon_layout_fill, false);
            if (a.hasValue(R.styleable.FlowLayout_Layout_carbon_layout_marginHorizontal)) {
                this.leftMargin = this.rightMargin = a.getDimensionPixelSize(R.styleable.FlowLayout_Layout_carbon_layout_marginHorizontal, 0);
            }
            if (a.hasValue(R.styleable.FlowLayout_Layout_carbon_layout_marginVertical)) {
                this.topMargin = this.bottomMargin = a.getDimensionPixelSize(R.styleable.FlowLayout_Layout_carbon_layout_marginVertical, 0);
            }
            a.recycle();
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(FrameLayout.LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.fill = source.fill;
        }

        public boolean getFill() {
            return this.fill;
        }

        public void setFill(boolean fill) {
            this.fill = fill;
        }
    }
}

