/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.drawable.EdgeEffect;
import carbon.view.MarginView;
import carbon.view.TintedView;
import carbon.view.VisibleView;

public class HorizontalScrollView
extends android.widget.HorizontalScrollView
implements TintedView,
VisibleView,
MarginView {
    private int mTouchSlop;
    EdgeEffect leftGlow;
    EdgeEffect rightGlow;
    private boolean drag = true;
    private float prevX;
    private int overscrollMode;
    long prevScroll = 0L;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    private static int[] tintIds = new int[]{R.styleable.HorizontalScrollView_carbon_tint, R.styleable.HorizontalScrollView_carbon_tintMode, R.styleable.HorizontalScrollView_carbon_backgroundTint, R.styleable.HorizontalScrollView_carbon_backgroundTintMode, R.styleable.HorizontalScrollView_carbon_animateColorChanges};
    ColorStateList tint;
    PorterDuff.Mode tintMode;
    ColorStateList backgroundTint;
    PorterDuff.Mode backgroundTintMode;
    boolean animateColorChanges;
    ValueAnimator.AnimatorUpdateListener tintAnimatorListener = animation -> {
        this.updateTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };
    ValueAnimator.AnimatorUpdateListener backgroundTintAnimatorListener = animation -> {
        this.updateBackgroundTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };

    public HorizontalScrollView(Context context) {
        super(context);
        this.initHorizontalScrollView(null, 16843603, R.style.carbon_HorizontalScrollView);
    }

    public HorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initHorizontalScrollView(attrs, 16843603, R.style.carbon_HorizontalScrollView);
    }

    public HorizontalScrollView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initHorizontalScrollView(attrs, defStyleAttr, R.style.carbon_HorizontalScrollView);
    }

    @TargetApi(value=21)
    public HorizontalScrollView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initHorizontalScrollView(attrs, defStyleAttr, defStyleRes);
    }

    private void initHorizontalScrollView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalScrollView, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.HorizontalScrollView_carbon_overScroll) continue;
            this.setOverScrollMode(a.getInt(attr2, 0));
        }
        Carbon.initTint(this, a, tintIds);
        a.recycle();
        this.setWillNotDraw(false);
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.leftGlow != null) {
            int restoreCount;
            int scrollX = this.getScrollX();
            if (!this.leftGlow.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(270.0f);
                canvas.translate((float)(-height + this.getPaddingTop()), (float)Math.min(0, scrollX));
                this.leftGlow.setSize(height, this.getWidth());
                if (this.leftGlow.draw(canvas)) {
                    this.postInvalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.rightGlow.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), (float)(-(Math.max(this.computeHorizontalScrollRange() - this.getWidth(), scrollX) + width)));
                this.rightGlow.setSize(height, width);
                if (this.rightGlow.draw(canvas)) {
                    this.postInvalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        switch (ev.getAction()) {
            case 2: {
                boolean canOverscroll;
                float deltaX = this.prevX - ev.getX();
                if (!this.drag && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.drag = true;
                    deltaX = deltaX > 0.0f ? (deltaX -= (float)this.mTouchSlop) : (deltaX += (float)this.mTouchSlop);
                }
                if (!this.drag) break;
                int oldX = this.getScrollX();
                int range = this.computeHorizontalScrollRange() - this.getWidth();
                boolean bl = canOverscroll = this.overscrollMode == 0 || this.overscrollMode == 1 && range > 0;
                if (!canOverscroll) break;
                float pulledToY = (float)oldX + deltaX;
                if (pulledToY < 0.0f) {
                    this.leftGlow.onPull(deltaX / (float)this.getWidth(), 1.0f - ev.getY() / (float)this.getHeight());
                    if (!this.rightGlow.isFinished()) {
                        this.rightGlow.onRelease();
                    }
                } else if (pulledToY > (float)range) {
                    this.rightGlow.onPull(deltaX / (float)this.getWidth(), ev.getY() / (float)this.getHeight());
                    if (!this.leftGlow.isFinished()) {
                        this.leftGlow.onRelease();
                    }
                }
                if (this.leftGlow == null || this.leftGlow.isFinished() && this.rightGlow.isFinished()) break;
                this.postInvalidate();
                break;
            }
            case 1: 
            case 3: {
                if (!this.drag) break;
                this.drag = false;
                if (this.leftGlow == null) break;
                this.leftGlow.onRelease();
                this.rightGlow.onRelease();
            }
        }
        this.prevX = ev.getX();
        return super.dispatchTouchEvent(ev);
    }

    protected void onScrollChanged(int x, int y, int prevX, int prevY) {
        boolean canOverscroll;
        super.onScrollChanged(x, y, prevX, prevY);
        if (this.drag || this.leftGlow == null) {
            return;
        }
        int range = this.computeHorizontalScrollRange() - this.getWidth();
        boolean bl = canOverscroll = this.overscrollMode == 0 || this.overscrollMode == 1 && range > 0;
        if (canOverscroll) {
            int dx = x - prevX;
            long t = System.currentTimeMillis();
            int velx = (int)((float)dx * 1000.0f / (float)(t - this.prevScroll));
            if (this.computeHorizontalScrollOffset() == 0 && dx < 0) {
                this.leftGlow.onAbsorb(-velx);
            } else if (this.computeHorizontalScrollOffset() == range && dx > 0) {
                this.rightGlow.onAbsorb(velx);
            }
            this.prevScroll = t;
        }
    }

    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.leftGlow == null) {
                Context context = this.getContext();
                this.leftGlow = new EdgeEffect(context);
                this.rightGlow = new EdgeEffect(context);
                this.updateTint();
            }
        } else {
            this.leftGlow = null;
            this.rightGlow = null;
        }
        super.setOverScrollMode(2);
        this.overscrollMode = mode;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateTint();
    }

    @Override
    public void setTintList(ColorStateList list) {
        this.tint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.tintAnimatorListener) : list);
        this.updateTint();
    }

    @Override
    public void setTint(int color2) {
        this.setTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getTint() {
        return this.tint;
    }

    private void updateTint() {
        if (this.tint == null) {
            return;
        }
        int color2 = this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor());
        if (this.leftGlow != null) {
            this.leftGlow.setColor(color2);
        }
        if (this.rightGlow != null) {
            this.rightGlow.setColor(color2);
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode mode) {
        this.tintMode = mode;
        this.updateTint();
    }

    @Override
    public PorterDuff.Mode getTintMode() {
        return this.tintMode;
    }

    @Override
    public void setBackgroundTintList(ColorStateList list) {
        this.backgroundTint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.backgroundTintAnimatorListener) : list);
        this.updateBackgroundTint();
    }

    @Override
    public void setBackgroundTint(int color2) {
        this.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getBackgroundTint() {
        return this.backgroundTint;
    }

    private void updateBackgroundTint() {
        if (this.getBackground() == null) {
            return;
        }
        if (this.backgroundTint != null && this.backgroundTintMode != null) {
            int color2 = this.backgroundTint.getColorForState(this.getDrawableState(), this.backgroundTint.getDefaultColor());
            this.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, this.tintMode));
        } else {
            this.getBackground().setColorFilter(null);
        }
    }

    @Override
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        this.backgroundTintMode = mode;
        this.updateBackgroundTint();
    }

    @Override
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    @Override
    public boolean isAnimateColorChangesEnabled() {
        return this.animateColorChanges;
    }

    @Override
    public void setAnimateColorChangesEnabled(boolean animateColorChanges) {
        if (this.animateColorChanges == animateColorChanges) {
            return;
        }
        this.animateColorChanges = animateColorChanges;
        this.setTintList(this.tint);
        this.setBackgroundTintList(this.backgroundTint);
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }
}

