/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimUtils;
import carbon.view.InputView;
import carbon.widget.EditText;
import carbon.widget.ImageView;
import carbon.widget.LinearLayout;
import carbon.widget.RelativeLayout;
import carbon.widget.TextView;

public class InputLayout
extends RelativeLayout {
    private int gravity;
    private boolean inDrawableStateChanged = false;
    private TextView errorTextView;
    ErrorMode errorMode = ErrorMode.WhenInvalid;
    private String label;
    private TextView counterTextView;
    private LabelMode labelMode;
    private TextView labelTextView;
    private ActionButton actionButton = ActionButton.None;
    private ImageView clearImageView;
    private ImageView showPasswordImageView;
    private ImageView voiceInputImageView;
    private ViewGroup container;
    private View child;
    TransformationMethod transformationMethod;

    public InputLayout(Context context) {
        super(context, null, R.attr.carbon_inputLayoutStyle);
        this.initInputLayout(null, R.attr.carbon_inputLayoutStyle, R.style.carbon_InputLayout);
    }

    public InputLayout(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_inputLayoutStyle);
        this.initInputLayout(attrs, R.attr.carbon_inputLayoutStyle, R.style.carbon_InputLayout);
    }

    public InputLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initInputLayout(attrs, defStyleAttr, R.style.carbon_InputLayout);
    }

    public InputLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initInputLayout(attrs, defStyleAttr, defStyleRes);
    }

    private void initInputLayout(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_inputlayout, (ViewGroup)this);
        this.errorTextView = (TextView)this.findViewById(R.id.carbon_error);
        this.errorTextView.setValid(false);
        this.counterTextView = (TextView)this.findViewById(R.id.carbon_counter);
        this.labelTextView = (TextView)this.findViewById(R.id.carbon_label);
        this.labelTextView.setGravity(this.gravity);
        this.clearImageView = (ImageView)this.findViewById(R.id.carbon_clear);
        this.showPasswordImageView = (ImageView)this.findViewById(R.id.carbon_showPassword);
        this.voiceInputImageView = (ImageView)this.findViewById(R.id.carbon_voiceInput);
        this.container = (ViewGroup)this.findViewById(R.id.carbon_inputLayoutContainer);
        this.setAddStatesFromChildren(this.addStatesFromChildren());
        this.setDuplicateParentStateEnabled(this.isDuplicateParentStateEnabled());
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.InputLayout, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (!this.isInEditMode() && attr2 == R.styleable.InputLayout_carbon_errorTextAppearance) {
                Carbon.setTextAppearance(this.errorTextView, attr2, false, true);
                continue;
            }
            if (attr2 == R.styleable.InputLayout_carbon_counterTextAppearance) {
                Carbon.setTextAppearance(this.counterTextView, attr2, false, true);
                continue;
            }
            if (attr2 != R.styleable.InputLayout_carbon_labelTextAppearance) continue;
            Carbon.setTextAppearance(this.labelTextView, attr2, false, true);
        }
        this.setError(a.getString(R.styleable.InputLayout_carbon_error));
        this.setErrorMode(ErrorMode.values()[a.getInt(R.styleable.InputLayout_carbon_errorMode, ErrorMode.WhenInvalid.ordinal())]);
        this.setLabelMode(LabelMode.values()[a.getInt(R.styleable.InputLayout_carbon_labelMode, LabelMode.Floating.ordinal())]);
        this.setLabel(a.getString(R.styleable.InputLayout_carbon_label));
        this.setActionButton(ActionButton.values()[a.getInt(R.styleable.InputLayout_carbon_actionButton, 0)]);
        this.setGravity(a.getInt(R.styleable.InputLayout_android_gravity, 0x800003));
        a.recycle();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!"inputLayout".equals(child.getTag())) {
            this.setInputChild(child);
            this.container.addView(child, index == -1 ? -1 : index + 1, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(params));
        } else {
            super.addView(child, index, params);
        }
    }

    private void setInputChild(View child) {
        this.child = child;
        if (child.isDuplicateParentStateEnabled()) {
            this.container.setDuplicateParentStateEnabled(true);
        }
        if (child instanceof ViewGroup && ((ViewGroup)child).addStatesFromChildren()) {
            this.container.setAddStatesFromChildren(true);
        }
        if (child.getId() == -1) {
            child.setId(R.id.carbon_input);
        }
        if (child instanceof EditText) {
            EditText editText = (EditText)child;
            if (this.labelTextView.getText().length() == 0) {
                this.setLabel(editText.getHint());
            }
            editText.addOnValidChangedListener(valid -> {
                this.updateError(valid);
                this.updateCounter(editText);
            });
            this.showPasswordImageView.setOnTouchListener((view, motionEvent) -> {
                int selectionStart = editText.getSelectionStart();
                int selectionEnd = editText.getSelectionEnd();
                if (motionEvent.getAction() == 0) {
                    this.transformationMethod = editText.getTransformationMethod();
                    editText.setTransformationMethod(null);
                } else if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
                    editText.setTransformationMethod(this.transformationMethod);
                }
                editText.setSelection(selectionStart, selectionEnd);
                return false;
            });
            this.clearImageView.setOnClickListener(view -> editText.setText(""));
            this.labelTextView.setInAnimator(null);
            this.labelTextView.setOutAnimator(null);
            this.setLabel(this.label);
            this.errorTextView.setInAnimator(null);
            this.errorTextView.setOutAnimator(null);
            this.updateError(editText.isValid());
            this.updateHint((View)editText);
            this.updateCounter(editText);
            this.labelTextView.setInAnimator((Animator)AnimUtils.getFlyInAnimator());
            this.labelTextView.setOutAnimator((Animator)AnimUtils.getFadeOutAnimator());
            this.errorTextView.setInAnimator((Animator)AnimUtils.getFadeInAnimator());
            this.errorTextView.setOutAnimator((Animator)AnimUtils.getFadeOutAnimator());
        } else if (child instanceof InputView) {
            InputView inputView = (InputView)child;
            inputView.addOnValidChangedListener(this::updateError);
            this.labelTextView.setInAnimator(null);
            this.labelTextView.setOutAnimator(null);
            this.errorTextView.setInAnimator(null);
            this.errorTextView.setOutAnimator(null);
            this.updateError(inputView.isValid());
            this.updateHint(child);
            this.labelTextView.setInAnimator((Animator)AnimUtils.getFlyInAnimator());
            this.labelTextView.setOutAnimator((Animator)AnimUtils.getFadeOutAnimator());
            this.errorTextView.setInAnimator((Animator)AnimUtils.getFadeInAnimator());
            this.errorTextView.setOutAnimator((Animator)AnimUtils.getFadeOutAnimator());
        }
        if (this.actionButton != ActionButton.None) {
            int buttonPadding = this.getResources().getDimensionPixelSize(R.dimen.carbon_padding) + this.getResources().getDimensionPixelSize(R.dimen.carbon_iconSize);
            child.setPadding(child.getPaddingLeft(), child.getPaddingTop(), child.getPaddingRight() + buttonPadding, child.getPaddingBottom());
        }
    }

    @Override
    protected void drawableStateChanged() {
        if (this.inDrawableStateChanged) {
            return;
        }
        this.inDrawableStateChanged = true;
        super.drawableStateChanged();
        this.updateHint(this.child);
        this.inDrawableStateChanged = false;
    }

    private void updateError(boolean valid) {
        this.labelTextView.setValid(valid);
        this.errorTextView.animateVisibility(this.errorMode == ErrorMode.Always || this.errorMode == ErrorMode.WhenInvalid && !valid ? 0 : (this.errorMode == ErrorMode.Never ? 8 : 4));
    }

    private void updateCounter(EditText editText) {
        int minCharacters = editText.getMinCharacters();
        int maxCharacters = editText.getMaxCharacters();
        this.counterTextView.setValid(editText.isValid());
        if (minCharacters > 0 && maxCharacters < Integer.MAX_VALUE) {
            this.counterTextView.setVisibility(0);
            this.counterTextView.setText(editText.length() + " / " + minCharacters + "-" + maxCharacters);
        } else if (minCharacters > 0) {
            this.counterTextView.setVisibility(0);
            this.counterTextView.setText(editText.length() + " / " + minCharacters + "+");
        } else if (maxCharacters < Integer.MAX_VALUE) {
            this.counterTextView.setVisibility(0);
            this.counterTextView.setText(editText.length() + " / " + maxCharacters);
        } else {
            this.counterTextView.setVisibility(8);
        }
    }

    private void updateHint(View child) {
        if (this.labelTextView == null) {
            return;
        }
        if (child == null) {
            this.labelTextView.setVisibility(8);
            return;
        }
        if (this.labelMode == LabelMode.Persistent || this.labelMode == LabelMode.Floating && child.isFocused() || this.labelMode == LabelMode.IfNotEmpty && (child.isFocused() || child instanceof android.widget.TextView && ((android.widget.TextView)child).getText().length() > 0)) {
            this.labelTextView.animateVisibility(0);
            if (child instanceof EditText) {
                ((EditText)child).setHint(null);
            }
        } else if (this.labelMode != LabelMode.Hint) {
            this.labelTextView.animateVisibility(4);
            if (child instanceof EditText) {
                ((EditText)child).setHint(this.label + (((EditText)child).isRequired() ? " *" : ""));
            }
        } else {
            this.labelTextView.setVisibility(8);
        }
    }

    public void setError(String text) {
        this.errorTextView.setText(text);
    }

    public void setErrorMode(@NonNull ErrorMode errorMode) {
        this.errorMode = errorMode;
        this.errorTextView.setVisibility(errorMode == ErrorMode.WhenInvalid ? 4 : (errorMode == ErrorMode.Always ? 0 : 8));
    }

    public void setErrorTextAppearance(int resId) {
        Carbon.setTextAppearance(this.errorTextView, resId, false, true);
    }

    public void setCounterTextAppearance(int resId) {
        Carbon.setTextAppearance(this.counterTextView, resId, false, true);
    }

    public void setLabelTextAppearance(int resId) {
        Carbon.setTextAppearance(this.labelTextView, resId, false, true);
    }

    public String getLabel() {
        return this.labelTextView.getText().toString();
    }

    public void setLabel(CharSequence label) {
        this.setLabel(String.valueOf(label));
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelTextView.setText((label != null ? label : "") + (this.child instanceof EditText && ((EditText)this.child).isRequired() ? " *" : ""));
        if (this.child != null) {
            this.updateHint(this.child);
        }
    }

    public LabelMode getLabelMode() {
        return this.labelMode;
    }

    public void setLabelMode(LabelMode labelMode) {
        this.labelMode = labelMode;
        if (this.child != null) {
            this.updateHint(this.child);
        }
    }

    public ActionButton getActionButton() {
        return this.actionButton;
    }

    public void setActionButton(ActionButton actionButton) {
        int paddingRight = 0;
        if (this.child != null) {
            paddingRight = this.child.getPaddingRight();
            if (this.actionButton != ActionButton.None) {
                paddingRight -= this.getResources().getDimensionPixelSize(R.dimen.carbon_padding) + this.getResources().getDimensionPixelSize(R.dimen.carbon_iconSize);
            }
        }
        this.actionButton = actionButton;
        this.clearImageView.setVisibility(actionButton == ActionButton.Clear ? 0 : 8);
        this.showPasswordImageView.setVisibility(actionButton == ActionButton.ShowPassword ? 0 : 8);
        this.voiceInputImageView.setVisibility(actionButton == ActionButton.VoiceInput ? 0 : 8);
        if (actionButton != null) {
            paddingRight += this.getResources().getDimensionPixelSize(R.dimen.carbon_padding) + this.getResources().getDimensionPixelSize(R.dimen.carbon_iconSize);
        }
        if (this.child != null) {
            this.child.setPadding(this.child.getPaddingLeft(), this.child.getPaddingTop(), paddingRight, this.child.getPaddingBottom());
        }
    }

    public int getBaseline() {
        if (this.child == null) {
            return super.getBaseline();
        }
        return (this.labelTextView.getVisibility() != 8 ? this.labelTextView.getMeasuredHeight() + 1 : 0) + this.child.getBaseline();
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        super.setGravity(gravity);
        if (this.labelTextView != null) {
            this.labelTextView.setGravity(gravity);
        }
    }

    public void setDuplicateParentStateEnabled(boolean enabled) {
        super.setDuplicateParentStateEnabled(enabled);
        if (this.container != null) {
            this.container.setDuplicateParentStateEnabled(enabled);
            if (enabled) {
                this.container.setAddStatesFromChildren(false);
            }
        }
    }

    public void setAddStatesFromChildren(boolean addsStates) {
        super.setAddStatesFromChildren(addsStates);
        if (this.container != null) {
            if (addsStates) {
                this.container.setDuplicateParentStateEnabled(false);
            }
            this.container.setAddStatesFromChildren(addsStates);
        }
    }

    public static enum ActionButton {
        None,
        Clear,
        ShowPassword,
        VoiceInput;

    }

    public static enum ErrorMode {
        WhenInvalid,
        Always,
        Never;

    }

    public static enum LabelMode {
        Floating,
        Persistent,
        Hint,
        IfNotEmpty;

    }
}

