/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.view.AllCapsTransformationMethod;
import carbon.view.TextAppearanceView;
import org.jetbrains.annotations.NotNull;

public class Label
extends carbon.view.View
implements TextAppearanceView {
    private CharSequence text = "";
    private ColorStateList textColor;
    private StaticLayout layout;
    private TransformationMethod transformationMethod;
    private int gravity;
    private float spacingMul = 1.0f;
    private float spacingAdd = 0.0f;
    ValueAnimator.AnimatorUpdateListener textColorAnimatorListener = animation -> this.postInvalidate();

    public Label(Context context) {
        super(context, null, R.attr.carbon_labelStyle);
        this.initLabel(null, R.attr.carbon_labelStyle, R.style.carbon_Label);
    }

    public Label(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_labelStyle);
        this.initLabel(attrs, R.attr.carbon_labelStyle, R.style.carbon_Label);
    }

    public Label(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initLabel(attrs, defStyleAttr, R.style.carbon_Label);
    }

    @TargetApi(value=21)
    public Label(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initLabel(attrs, defStyleAttr, defStyleRes);
    }

    private void initLabel(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Label, defStyleAttr, defStyleRes);
        int ap = a.getResourceId(R.styleable.Label_android_textAppearance, -1);
        if (ap != -1) {
            Carbon.setTextAppearance(this, ap, a.hasValue(R.styleable.Label_android_textColor), true);
        }
        if (a.hasValue(R.styleable.Label_android_text)) {
            this.setText(a.getString(R.styleable.Label_android_text));
        }
        this.setAllCaps(a.getBoolean(R.styleable.Label_android_textAllCaps, false));
        this.setGravity(a.getInt(R.styleable.Label_android_gravity, 0x800003));
        Carbon.initHtmlText(this, a, R.styleable.Label_carbon_htmlText);
        ColorStateList textColor = Carbon.getDefaultColorStateList(this, a, R.styleable.Label_android_textColor);
        if (textColor != null) {
            this.setTextColor(textColor);
        } else {
            textColor = a.getColorStateList(R.styleable.Label_android_textColor);
            if (textColor != null) {
                this.setTextColor(textColor);
            }
        }
        a.recycle();
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        this.layout = null;
    }

    public int getGravity() {
        return this.gravity;
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        this.text = text;
        this.layout = null;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public void setTextColor(@NonNull ColorStateList colors) {
        this.textColor = this.isAnimateColorChangesEnabled() && !(colors instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(colors, this.textColorAnimatorListener) : colors;
    }

    public void setTextColor(int textColor) {
        this.textColor = ColorStateList.valueOf((int)textColor);
    }

    public ColorStateList getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextSize(float textSize) {
        this.paint.setTextSize(textSize);
    }

    @Override
    public void setAllCaps(boolean allCaps) {
        this.transformationMethod = allCaps ? new AllCapsTransformationMethod(this.getContext()) : null;
        this.layout = null;
    }

    public void setLineHeight(int lineHeight) {
        int fontHeight = this.getPaint().getFontMetricsInt(null);
        if (lineHeight != fontHeight) {
            this.setLineSpacing(lineHeight - fontHeight, 1.0f);
        }
    }

    public void setLineSpacing(float add, float mult) {
        if (this.spacingAdd != add || this.spacingMul != mult) {
            this.spacingAdd = add;
            this.spacingMul = mult;
            if (this.layout != null) {
                this.layout = null;
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    @Override
    public void setTypeface(@NotNull Typeface typeface, int style2) {
        this.paint.setTypeface(typeface);
    }

    public void setTextAppearance(@NonNull Context context, @StyleRes int resId) {
        Carbon.setTextAppearance(this, resId, false, true);
    }

    public void setTextAppearance(@StyleRes int resId) {
        Carbon.setTextAppearance(this, resId, false, true);
    }

    @Override
    @NotNull
    public TextPaint getPaint() {
        return this.paint;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)Label.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)Label.class.getName());
        info.setText(this.text);
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.textColor instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.textColor).setState(this.getDrawableState());
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layout = null;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.ensureLayout();
        int saveCount = canvas.save();
        if ((this.gravity & 0x70) == 16) {
            canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.layout.getHeight()) / 2.0f + (float)this.getPaddingTop());
        } else if ((this.gravity & 0x70) == 80) {
            canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() - this.getPaddingBottom() - this.layout.getHeight()));
        } else {
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        }
        if (this.textColor != null) {
            this.paint.setColor(this.textColor.getColorForState(this.getDrawableState(), this.textColor.getDefaultColor()));
        }
        this.layout.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void ensureLayout() {
        if (this.layout == null) {
            Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
            if ((GravityCompat.getAbsoluteGravity((int)this.gravity, (int)ViewCompat.getLayoutDirection((View)this)) & 7) == 5) {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
            } else if ((this.gravity & 7) == 1) {
                alignment = Layout.Alignment.ALIGN_CENTER;
            }
            CharSequence transformedText = this.transformationMethod != null ? this.transformationMethod.getTransformation(this.text, (View)this) : this.text;
            this.layout = new StaticLayout(transformedText, this.paint, this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), alignment, this.spacingMul, this.spacingAdd, false);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        CharSequence transformedText;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = this.getPaddingLeft() + this.getPaddingRight();
        int height = this.getPaddingTop() + this.getPaddingBottom();
        CharSequence charSequence = transformedText = this.transformationMethod != null ? this.transformationMethod.getTransformation(this.text, (View)this) : this.text;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            this.layout = new StaticLayout(transformedText, this.paint, Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            int maxWidth = 0;
            for (int i = 0; i < this.layout.getLineCount(); ++i) {
                maxWidth = (int)Math.ceil(Math.max((float)maxWidth, this.layout.getLineWidth(i)));
            }
            width += maxWidth;
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            this.layout = new StaticLayout(transformedText, this.paint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            height += this.layout.getHeight();
            height = Math.max(height, this.getSuggestedMinimumHeight());
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public int getBaseline() {
        this.ensureLayout();
        int baseline = this.layout.getLineBaseline(0);
        if ((this.gravity & 0x70) == 16 && this.layout != null) {
            return (int)((float)baseline + (float)(this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.layout.getHeight()) / 2.0f + (float)this.getPaddingTop());
        }
        if ((this.gravity & 0x70) == 80 && this.layout != null) {
            return baseline + this.getHeight() - this.getPaddingBottom() - this.layout.getHeight();
        }
        return baseline + this.getPaddingTop();
    }
}

