/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import androidx.core.view.MenuItemCompat;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.component.Component;
import carbon.component.LayoutComponent;
import carbon.recycler.RowFactory;
import carbon.recycler.RowListAdapter;
import carbon.recycler.ViewItemDecoration;
import carbon.widget.ImageView;
import carbon.widget.Label;
import carbon.widget.RecyclerView;
import com.annimon.stream.Stream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class NavigationView
extends RecyclerView {
    private RecyclerView.OnItemClickedListener onItemClickedListener;
    private Item[] items;
    private View header;
    private RowFactory<Item> itemFactory;

    public NavigationView(Context context) {
        super(context);
        this.initNavigationView(null, R.attr.carbon_navigationViewStyle, R.style.carbon_NavigationView);
    }

    public NavigationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initNavigationView(attrs, R.attr.carbon_navigationViewStyle, R.style.carbon_NavigationView);
    }

    public NavigationView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initNavigationView(attrs, defStyleAttr, R.style.carbon_NavigationView);
    }

    public NavigationView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.initNavigationView(attrs, defStyleAttr, defStyleRes);
    }

    private void initNavigationView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.setLayoutManager((RecyclerView.LayoutManager)new RecyclerView.LinearLayoutManager(this.getContext()));
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.NavigationView, defStyleAttr, defStyleRes);
        this.itemFactory = ItemComponent::new;
        int menuId = a.getResourceId(R.styleable.NavigationView_carbon_menu, 0);
        if (menuId != 0) {
            this.setMenu(menuId);
        }
        a.recycle();
    }

    public void setOnItemClickedListener(RecyclerView.OnItemClickedListener<MenuItem> onItemClickedListener) {
        this.onItemClickedListener = onItemClickedListener;
    }

    public void setMenu(int resId) {
        this.setMenu(Carbon.getMenu(this.getContext(), resId));
    }

    public void setMenu(Menu menu) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < menu.size(); ++i) {
            if (!menu.getItem(i).isVisible()) continue;
            items.add(new Item(menu.getItem(i)));
        }
        this.items = (Item[])Stream.of(items).toArray(Item[]::new);
        this.initItems();
    }

    private void initItems() {
        if (this.items == null) {
            return;
        }
        RowListAdapter adapter = new RowListAdapter(Item.class, this.itemFactory);
        adapter.putFactory(CustomHeaderItem.class, parent -> new CustomHeaderRow(this.header));
        adapter.setOnItemClickedListener(Item.class, (view, menuItem, position) -> {
            if (this.onItemClickedListener != null) {
                this.onItemClickedListener.onItemClicked(view, menuItem, position);
            }
        });
        ArrayList<Item> items = new ArrayList<Item>(Arrays.asList(this.items));
        for (int i = 0; i < this.getItemDecorationCount(); ++i) {
            this.removeItemDecorationAt(0);
        }
        ViewItemDecoration dividerItemDecoration = new ViewItemDecoration(this.getContext(), R.layout.carbon_menustrip_hseparator_item);
        dividerItemDecoration.setDrawAfter(position -> position < items.size() - 1 && items.get(position) instanceof Item && items.get(position + 1) instanceof Item && ((Item)items.get(position)).getGroupId() != ((Item)items.get(position + 1)).getGroupId());
        this.addItemDecoration(dividerItemDecoration);
        ViewItemDecoration paddingItemDecoration = new ViewItemDecoration(this.getContext(), R.layout.carbon_row_padding);
        paddingItemDecoration.setDrawBefore(position -> position == 0);
        paddingItemDecoration.setDrawAfter(position -> position == items.size() - 1);
        this.addItemDecoration(paddingItemDecoration);
        if (this.header != null) {
            items.add(0, (Item)((Object)new CustomHeaderItem()));
        }
        adapter.setItems(items);
        this.setAdapter(adapter);
    }

    public void setMenuItems(Item[] items) {
        this.items = items;
        this.initItems();
    }

    public Item[] getMenuItems() {
        return this.items;
    }

    public void setHeader(View header) {
        this.header = header;
        this.initItems();
    }

    @Deprecated
    public void setItemLayout(int itemLayoutId) {
    }

    public void setItemFactory(RowFactory<Item> factory) {
        this.itemFactory = factory;
        this.initItems();
    }

    private static class CustomHeaderRow
    extends Component<CustomHeaderItem> {
        CustomHeaderRow(View view) {
            this.view = view;
        }
    }

    private static class CustomHeaderItem
    implements Serializable {
        private CustomHeaderItem() {
        }
    }

    private static class ItemComponent
    extends LayoutComponent<Item> {
        private ImageView carbonItemIcon = (ImageView)this.getView().findViewById(R.id.carbon_itemIcon);
        private Label carbonItemText = (Label)this.getView().findViewById(R.id.carbon_itemText);

        ItemComponent(ViewGroup parent) {
            super(parent, R.layout.carbon_navigation_row);
        }

        @Override
        public void bind(Item data) {
            this.carbonItemIcon.setImageDrawable(data.icon);
            this.carbonItemIcon.setTintList(data.getIconTintList());
            this.carbonItemText.setText(data.title);
        }
    }

    public static class Item
    implements Serializable {
        int id;
        private Drawable icon;
        private ColorStateList tint;
        private int groupId;
        private CharSequence title;

        public Item() {
        }

        public Item(int id2, Drawable icon, CharSequence title) {
            this.id = id2;
            this.icon = icon;
            this.title = title;
        }

        public Item(MenuItem item) {
            this.id = item.getItemId();
            this.icon = item.getIcon();
            this.tint = MenuItemCompat.getIconTintList((MenuItem)item);
            this.groupId = item.getGroupId();
            this.title = item.getTitle();
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id2) {
            this.id = id2;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIconTintList(ColorStateList tint) {
            this.tint = tint;
        }

        public ColorStateList getIconTintList() {
            return this.tint;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public void setTitle(CharSequence title) {
            this.title = title;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }
}

