/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.drawable.EdgeEffect;
import carbon.drawable.ripple.RippleDrawable;
import carbon.view.MarginView;
import carbon.view.TintedView;
import carbon.view.VisibleView;

public class NestedScrollView
extends androidx.core.widget.NestedScrollView
implements TintedView,
VisibleView,
MarginView {
    private int mTouchSlop;
    EdgeEffect topGlow;
    EdgeEffect bottomGlow;
    private boolean drag = true;
    private float prevY;
    private int overscrollMode;
    long prevScroll = 0L;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    private static int[] tintIds = new int[]{R.styleable.ScrollView_carbon_tint, R.styleable.ScrollView_carbon_tintMode, R.styleable.ScrollView_carbon_backgroundTint, R.styleable.ScrollView_carbon_backgroundTintMode, R.styleable.ScrollView_carbon_animateColorChanges};
    ColorStateList tint;
    PorterDuff.Mode tintMode;
    ColorStateList backgroundTint;
    PorterDuff.Mode backgroundTintMode;
    boolean animateColorChanges;
    ValueAnimator.AnimatorUpdateListener tintAnimatorListener = animation -> {
        this.updateTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };
    ValueAnimator.AnimatorUpdateListener backgroundTintAnimatorListener = animation -> {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable) {
            background = ((RippleDrawable)background).getBackground();
        }
        if (background != null && this.backgroundTint != null && this.backgroundTintMode != null) {
            background.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.backgroundTint.getColorForState(background.getState(), this.backgroundTint.getDefaultColor()), this.backgroundTintMode));
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    };

    public NestedScrollView(Context context) {
        super(context);
        this.initScrollView(null, 0x1010080, R.style.carbon_ScrollView);
    }

    public NestedScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initScrollView(attrs, 0x1010080, R.style.carbon_ScrollView);
    }

    public NestedScrollView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initScrollView(attrs, defStyleAttr, R.style.carbon_ScrollView);
    }

    public NestedScrollView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.initScrollView(attrs, defStyleAttr, defStyleRes);
    }

    private void initScrollView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ScrollView, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.ScrollView_carbon_overScroll) continue;
            this.setOverScrollMode(a.getInt(attr2, 0));
        }
        Carbon.initTint(this, a, tintIds);
        a.recycle();
        this.setClipToPadding(false);
        this.setWillNotDraw(false);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        switch (ev.getAction()) {
            case 2: {
                boolean canOverscroll;
                float deltaY = this.prevY - ev.getY();
                if (!this.drag && Math.abs(deltaY) > (float)this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.drag = true;
                    deltaY = deltaY > 0.0f ? (deltaY -= (float)this.mTouchSlop) : (deltaY += (float)this.mTouchSlop);
                }
                if (!this.drag) break;
                int oldY = this.computeVerticalScrollOffset();
                int range = this.computeVerticalScrollRange() - this.getHeight();
                boolean bl = canOverscroll = this.overscrollMode == 0 || this.overscrollMode == 1 && range > 0;
                if (!canOverscroll) break;
                float pulledToY = (float)oldY + deltaY;
                if (pulledToY < 0.0f) {
                    this.topGlow.onPull(deltaY / (float)this.getHeight(), ev.getX() / (float)this.getWidth());
                    if (!this.bottomGlow.isFinished()) {
                        this.bottomGlow.onRelease();
                    }
                } else if (pulledToY > (float)range) {
                    this.bottomGlow.onPull(deltaY / (float)this.getHeight(), 1.0f - ev.getX() / (float)this.getWidth());
                    if (!this.topGlow.isFinished()) {
                        this.topGlow.onRelease();
                    }
                }
                if (this.topGlow == null || this.topGlow.isFinished() && this.bottomGlow.isFinished()) break;
                this.postInvalidate();
                break;
            }
            case 1: 
            case 3: {
                if (!this.drag) break;
                this.drag = false;
                if (this.topGlow == null) break;
                this.topGlow.onRelease();
                this.bottomGlow.onRelease();
            }
        }
        this.prevY = ev.getY();
        return super.dispatchTouchEvent(ev);
    }

    protected void onScrollChanged(int x, int y, int prevX, int prevY) {
        boolean canOverscroll;
        super.onScrollChanged(x, y, prevX, prevY);
        if (this.drag || this.topGlow == null) {
            return;
        }
        int range = this.computeVerticalScrollRange() - this.getHeight();
        boolean bl = canOverscroll = this.overscrollMode == 0 || this.overscrollMode == 1 && range > 0;
        if (canOverscroll) {
            long t = System.currentTimeMillis();
            int dy = y - prevY;
            int vely = (int)((float)dy * 1000.0f / (float)(t - this.prevScroll));
            if (this.computeVerticalScrollOffset() == 0 && dy < 0) {
                this.topGlow.onAbsorb(-vely);
            } else if (this.computeVerticalScrollOffset() == range && dy > 0) {
                this.bottomGlow.onAbsorb(vely);
            }
            this.prevScroll = t;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.topGlow == null) {
                Context context = this.getContext();
                this.topGlow = new EdgeEffect(context);
                this.bottomGlow = new EdgeEffect(context);
                this.updateTint();
            }
        } else {
            this.topGlow = null;
            this.bottomGlow = null;
        }
        super.setOverScrollMode(2);
        this.overscrollMode = mode;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateTint();
    }

    @Override
    public void setTintList(ColorStateList list) {
        this.tint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.tintAnimatorListener) : list);
        this.updateTint();
    }

    @Override
    public void setTint(int color2) {
        this.setTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getTint() {
        return this.tint;
    }

    private void updateTint() {
        if (this.tint == null) {
            return;
        }
        int color2 = this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor());
        if (this.topGlow != null) {
            this.topGlow.setColor(color2);
        }
        if (this.bottomGlow != null) {
            this.bottomGlow.setColor(color2);
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode mode) {
        this.tintMode = mode;
        this.updateTint();
    }

    @Override
    public PorterDuff.Mode getTintMode() {
        return this.tintMode;
    }

    @Override
    public void setBackgroundTintList(ColorStateList list) {
        this.backgroundTint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.backgroundTintAnimatorListener) : list);
        this.updateBackgroundTint();
    }

    @Override
    public void setBackgroundTint(int color2) {
        this.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getBackgroundTint() {
        return this.backgroundTint;
    }

    private void updateBackgroundTint() {
        if (this.getBackground() == null) {
            return;
        }
        if (this.backgroundTint != null && this.backgroundTintMode != null) {
            int color2 = this.backgroundTint.getColorForState(this.getDrawableState(), this.backgroundTint.getDefaultColor());
            this.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, this.tintMode));
        } else {
            this.getBackground().setColorFilter(null);
        }
    }

    @Override
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        this.backgroundTintMode = mode;
        this.updateBackgroundTint();
    }

    @Override
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    @Override
    public boolean isAnimateColorChangesEnabled() {
        return this.animateColorChanges;
    }

    @Override
    public void setAnimateColorChangesEnabled(boolean animateColorChanges) {
        if (this.animateColorChanges == animateColorChanges) {
            return;
        }
        this.animateColorChanges = animateColorChanges;
        this.setTintList(this.tint);
        this.setBackgroundTintList(this.backgroundTint);
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.topGlow != null) {
            int width;
            int restoreCount;
            int scrollY = this.getScrollY();
            if (!this.topGlow.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                canvas.translate((float)this.getPaddingLeft(), (float)Math.min(0, scrollY));
                this.topGlow.setSize(width, this.getHeight());
                if (this.topGlow.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.bottomGlow.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                int height = this.getHeight();
                canvas.translate((float)(-width + this.getPaddingLeft()), (float)(Math.max(this.computeVerticalScrollRange() - this.getHeight(), scrollY) + height));
                canvas.rotate(180.0f, (float)width, 0.0f);
                this.bottomGlow.setSize(width, height);
                if (this.bottomGlow.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }
}

