/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import carbon.Carbon;
import carbon.R;
import carbon.internal.MathUtils;
import carbon.recycler.RowArrayAdapter;
import carbon.widget.DropDown;
import carbon.widget.MenuStrip;
import carbon.widget.PopupWindow;
import carbon.widget.RecyclerView;

public class PopupMenu
extends PopupWindow {
    protected MenuStrip menuStrip;
    private DropDown.PopupMode popupMode;

    public PopupMenu(Context context) {
        super(context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.carbon_popupmenu, (ViewGroup)this.getContentView(), false);
        this.menuStrip = (MenuStrip)view.findViewById(R.id.carbon_menuStrip);
        this.menuStrip.setOnKeyListener((v, keyCode, event) -> {
            if (event.getAction() == 1 && (keyCode == 82 || keyCode == 4)) {
                this.dismiss();
                return true;
            }
            return false;
        });
        this.setContentView(view);
    }

    @Override
    public void update() {
        if (this.getAnchorView() == null) {
            return;
        }
        this.setClippingEnabled(this.popupMode == DropDown.PopupMode.Fit);
        Resources res = this.getContentView().getContext().getResources();
        int margin = (int)res.getDimension(R.dimen.carbon_margin);
        int itemHeight = (int)res.getDimension(R.dimen.carbon_dropdownMenuItemHeight);
        int marginHalf = (int)res.getDimension(R.dimen.carbon_paddingHalf);
        int selectedItem = 0;
        RowArrayAdapter<MenuStrip.Item> adapter = this.menuStrip.getAdapter();
        if (this.getAnchorView() instanceof TextView) {
            TextView textView = (TextView)this.getAnchorView();
            String text = textView.getText().toString();
            for (int i = 0; i < adapter.getItemCount(); ++i) {
                if (!adapter.getItem(i).toString().equals(text)) continue;
                selectedItem = i;
                break;
            }
        }
        Rect windowRect = new Rect();
        this.getAnchorView().getWindowVisibleDisplayFrame(windowRect);
        int hWindow = windowRect.bottom - windowRect.top;
        int wWindow = windowRect.right - windowRect.left;
        int[] location = new int[2];
        this.getAnchorView().getLocationInWindow(location);
        if (this.popupMode == DropDown.PopupMode.Over) {
            int maxHeightAbove = location[1] - windowRect.top - marginHalf * 2;
            int maxItemsAbove = maxHeightAbove / itemHeight;
            int maxHeightBelow = hWindow - location[1] - marginHalf * 2;
            int maxItemsBelow = Math.max(1, maxHeightBelow / itemHeight);
            int itemsBelow = Math.min(adapter.getItemCount() - selectedItem, maxItemsBelow);
            int itemsAbove = Math.min(selectedItem, maxItemsAbove);
            int popupX = location[0] - margin - marginHalf;
            int popupY = location[1] - marginHalf * 2 - itemsAbove * itemHeight - (itemHeight - (this.getAnchorView().getHeight() - this.getAnchorView().getPaddingTop() - this.getAnchorView().getPaddingBottom())) / 2 + this.getAnchorView().getPaddingTop();
            int popupWidth = this.getAnchorView().getWidth() + margin * 2 + marginHalf * 2 - this.getAnchorView().getPaddingLeft() - this.getAnchorView().getPaddingRight();
            int popupHeight = marginHalf * 4 + Math.max(1, itemsAbove + itemsBelow) * itemHeight;
            popupWidth = Math.min(popupWidth, wWindow - marginHalf * 2);
            if (popupX < 0) {
                popupWidth -= Math.min(-popupX, margin);
                popupX = 0;
            }
            if (popupX + popupWidth > wWindow) {
                int diff = popupX + popupWidth - wWindow;
                diff = Math.min(margin, diff);
                popupX = wWindow - (popupWidth -= diff);
            }
            popupY = MathUtils.constrain(popupY, 0, hWindow - popupHeight);
            LinearLayoutManager manager = (LinearLayoutManager)this.menuStrip.getLayoutManager();
            manager.scrollToPositionWithOffset(selectedItem - itemsAbove, 0);
            this.update(popupX, popupY, popupWidth, popupHeight);
        } else {
            int maxItems = (hWindow - marginHalf * 2 - margin * 2) / itemHeight;
            int popupX = location[0] - margin - marginHalf;
            int popupY = location[1] - marginHalf * 2 - (itemHeight - (this.getAnchorView().getHeight() - this.getAnchorView().getPaddingTop() - this.getAnchorView().getPaddingBottom())) / 2 + this.getAnchorView().getPaddingTop();
            int popupWidth = this.getAnchorView().getWidth() + margin * 2 + marginHalf * 2 - this.getAnchorView().getPaddingLeft() - this.getAnchorView().getPaddingRight();
            int popupHeight = marginHalf * 4 + Math.min(this.menuStrip.getAdapter().getItemCount(), maxItems) * itemHeight;
            LinearLayoutManager manager = (LinearLayoutManager)this.menuStrip.getLayoutManager();
            manager.scrollToPosition(selectedItem);
            this.update(popupX, popupY, popupWidth, popupHeight);
        }
        this.menuStrip.layout(0, 0, this.getWidth(), this.getHeight());
        this.menuStrip.setAdapter(this.menuStrip.getAdapter());
        super.update();
    }

    public void setOnMenuItemClickListener(RecyclerView.OnItemClickedListener<MenuStrip.Item> listener) {
        this.menuStrip.setOnItemClickedListener(listener);
    }

    public void setMenu(int resId) {
        this.menuStrip.setMenu(Carbon.getMenu(this.getContentView().getContext(), resId));
    }

    public void setMenu(Menu baseMenu) {
        this.menuStrip.setMenu(baseMenu);
    }

    public DropDown.PopupMode getPopupMode() {
        return this.popupMode;
    }

    public void setPopupMode(DropDown.PopupMode popupMode) {
        this.popupMode = popupMode;
    }
}

