/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.drawable.CircularProgressDrawable;
import carbon.drawable.ProgressBarDrawable;
import carbon.drawable.ProgressDrawable;
import carbon.view.View;

public class ProgressView
extends View {
    private ProgressDrawable drawable;

    public ProgressView(Context context) {
        super(context);
        this.initProgressBar(null, R.attr.carbon_progressViewStyle, R.style.carbon_ProgressView);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_progressViewStyle);
        this.initProgressBar(attrs, R.attr.carbon_progressViewStyle, R.style.carbon_ProgressView);
    }

    public ProgressView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initProgressBar(attrs, defStyleAttr, R.style.carbon_ProgressView);
    }

    @TargetApi(value=21)
    public ProgressView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initProgressBar(attrs, defStyleAttr, defStyleRes);
    }

    private void initProgressBar(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyleAttr, defStyleRes);
        Style style2 = Style.values()[a.getInt(R.styleable.ProgressView_carbon_progressStyle, 0)];
        if (style2 == Style.BarDeterminate || style2 == Style.BarIndeterminate || style2 == Style.BarQuery) {
            this.setDrawable(new ProgressBarDrawable());
        } else {
            this.setDrawable(new CircularProgressDrawable());
        }
        this.updateTint();
        this.drawable.setStyle(style2);
        this.drawable.setBarWidth(a.getDimension(R.styleable.ProgressView_carbon_barWidth, 5.0f));
        this.setProgress(a.getFloat(R.styleable.ProgressView_carbon_progress, 0.0f));
        a.recycle();
        if (this.getVisibility() == 0) {
            this.setBarWidth(this.getBarWidth() + this.getBarPadding());
            this.setBarPadding(0.0f);
        } else {
            this.setBarPadding(this.getBarWidth() + this.getBarPadding());
            this.setBarWidth(0.0f);
        }
    }

    public void setProgress(float progress) {
        this.drawable.setProgress(progress);
    }

    public float getProgress() {
        return this.drawable.getProgress();
    }

    public float getBarWidth() {
        return this.drawable.getBarWidth();
    }

    public void setBarWidth(float arcWidth) {
        this.drawable.setBarWidth(arcWidth);
    }

    public void setBarPadding(float padding) {
        this.drawable.setBarPadding(padding);
    }

    public float getBarPadding() {
        return this.drawable.getBarPadding();
    }

    public void setDrawable(ProgressDrawable newDrawable) {
        this.drawable = newDrawable;
        if (this.drawable != null) {
            this.drawable.setCallback(null);
        }
        if (newDrawable != null) {
            newDrawable.setCallback((Drawable.Callback)this);
        }
    }

    public ProgressDrawable getDrawable() {
        return this.drawable;
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.drawable;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.drawable != null) {
            this.drawable.draw(canvas);
        }
    }

    @Override
    protected void onMeasureInternal(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            width = this.getSuggestedMinimumWidth();
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.getSuggestedMinimumHeight();
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!changed) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.drawable != null) {
            this.drawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void updateTint() {
        if (this.tint != null && this.tintMode != null) {
            int color2 = this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor());
            if (this.drawable != null) {
                this.drawable.setTint(color2);
                this.drawable.setTintMode(this.tintMode);
            }
        } else if (this.drawable != null) {
            this.drawable.setTintList(null);
        }
    }

    public static enum Style {
        BarDeterminate,
        BarIndeterminate,
        BarQuery,
        CircularDeterminate,
        CircularIndeterminate;

    }
}

