/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.drawable.ButtonGravity;
import carbon.drawable.ripple.RippleDrawable;
import carbon.widget.OnCheckedChangeListener;
import carbon.widget.TextView;

public class RadioButton
extends TextView
implements Checkable {
    private Drawable drawable;
    private float drawablePadding;
    private ButtonGravity buttonGravity;
    private boolean checked;
    private boolean mBroadcasting;
    private OnCheckedChangeListener onCheckedChangeListener;
    private OnCheckedChangeListener mOnCheckedChangeWidgetListener;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public RadioButton(Context context) {
        super(context, null, 16842878);
        this.initRadioButton(null, 16842878, R.style.carbon_RadioButton);
    }

    public RadioButton(Context context, AttributeSet attrs) {
        super(context, attrs, 16842878);
        this.initRadioButton(attrs, 16842878, R.style.carbon_RadioButton);
    }

    public RadioButton(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initRadioButton(attrs, defStyleAttr, R.style.carbon_RadioButton);
    }

    @TargetApi(value=21)
    public RadioButton(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initRadioButton(attrs, defStyleAttr, defStyleRes);
    }

    public void initRadioButton(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RadioButton, defStyleAttr, defStyleRes);
        this.setButtonDrawable(Carbon.getDrawable((View)this, a, R.styleable.RadioButton_android_button, R.drawable.carbon_radio_anim));
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.RadioButton_android_drawablePadding) {
                this.drawablePadding = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.RadioButton_android_checked) {
                this.setChecked(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 != R.styleable.RadioButton_carbon_buttonGravity) continue;
            this.buttonGravity = ButtonGravity.values()[a.getInt(attr2, 0)];
        }
        a.recycle();
    }

    private boolean isLayoutRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private boolean isButtonOnTheLeft() {
        return this.buttonGravity == ButtonGravity.LEFT || !this.isLayoutRtl() && this.buttonGravity == ButtonGravity.START || this.isLayoutRtl() && this.buttonGravity == ButtonGravity.END;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public boolean performClick() {
        boolean handled;
        this.setChecked(true);
        if (this.onCheckedChangeListener != null) {
            this.onCheckedChangeListener.onCheckedChanged(this, this.checked);
        }
        if (!(handled = super.performClick())) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (this.checked != checked) {
            this.checked = checked;
            this.refreshDrawableState();
            if (this.mBroadcasting) {
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeWidgetListener != null) {
                this.mOnCheckedChangeWidgetListener.onCheckedChanged(this, checked);
            }
            this.mBroadcasting = false;
        }
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    void setOnCheckedChangeWidgetListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeWidgetListener = listener;
    }

    public void setButtonDrawable(Drawable d) {
        if (this.drawable != d) {
            if (this.drawable != null) {
                this.drawable.setCallback(null);
                this.unscheduleDrawable(this.drawable);
            }
            this.drawable = d;
            if (d != null) {
                this.drawable = DrawableCompat.wrap((Drawable)d);
                d.setCallback((Drawable.Callback)this);
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                d.setVisible(this.getVisibility() == 0, false);
                this.setMinHeight(d.getIntrinsicHeight());
                this.applyTint();
            }
        }
    }

    public ButtonGravity getButtonGravity() {
        return this.buttonGravity;
    }

    public void setButtonGravity(ButtonGravity buttonGravity) {
        this.buttonGravity = buttonGravity;
    }

    @Override
    protected void updateTint() {
        super.updateTint();
        if (this.drawable != null && this.tint != null && this.tintMode != null) {
            this.drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()), this.tintMode));
        }
    }

    @Override
    protected void applyTint() {
        super.applyTint();
        if (this.drawable != null) {
            if (this.tint != null && this.tintMode != null) {
                Carbon.setTintListMode(this.drawable, this.tint, this.tintMode);
            } else {
                Carbon.clearTint(this.drawable);
            }
            if (this.drawable.isStateful()) {
                this.drawable.setState(this.getDrawableState());
            }
        }
    }

    public CharSequence getAccessibilityClassName() {
        return RadioButton.class.getSimpleName();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setChecked(this.isChecked());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setCheckable(true);
        info.setChecked(this.isChecked());
    }

    public int getCompoundPaddingLeft() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingLeft();
        if (this.isButtonOnTheLeft() && (buttonDrawable = this.drawable) != null) {
            padding = (int)((float)padding + ((float)buttonDrawable.getIntrinsicWidth() + this.drawablePadding));
        }
        return padding;
    }

    public int getCompoundPaddingRight() {
        Drawable buttonDrawable;
        int padding = super.getCompoundPaddingRight();
        if (!this.isButtonOnTheLeft() && (buttonDrawable = this.drawable) != null) {
            padding = (int)((float)padding + ((float)buttonDrawable.getIntrinsicWidth() + this.drawablePadding));
        }
        return padding;
    }

    protected void onDraw(Canvas canvas) {
        Drawable buttonDrawable = this.drawable;
        if (buttonDrawable != null) {
            int top;
            int verticalGravity = this.getGravity() & 0x70;
            int drawableHeight = buttonDrawable.getIntrinsicHeight();
            int drawableWidth = buttonDrawable.getIntrinsicWidth();
            switch (verticalGravity) {
                case 80: {
                    top = this.getHeight() - drawableHeight;
                    break;
                }
                case 16: {
                    top = (this.getHeight() - drawableHeight) / 2;
                    break;
                }
                default: {
                    top = 0;
                }
            }
            int bottom = top + drawableHeight;
            int left = this.isButtonOnTheLeft() ? this.getPaddingLeft() : this.getWidth() - drawableWidth - this.getPaddingRight();
            int right = this.isButtonOnTheLeft() ? drawableWidth + this.getPaddingLeft() : this.getWidth() - this.getPaddingRight();
            buttonDrawable.setBounds(left, top, right, bottom);
            Drawable background = this.getBackground();
            if (background == null || background instanceof RippleDrawable) {
                // empty if block
            }
        }
        super.onDraw(canvas);
        if (buttonDrawable != null) {
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            if (scrollX == 0 && scrollY == 0) {
                buttonDrawable.draw(canvas);
            } else {
                canvas.translate((float)scrollX, (float)scrollY);
                buttonDrawable.draw(canvas);
                canvas.translate((float)(-scrollX), (float)(-scrollY));
            }
        }
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace);
        if (this.isChecked()) {
            int[] state = new int[drawableState.length + 1];
            System.arraycopy(drawableState, 0, state, 0, drawableState.length);
            drawableState = state;
            RadioButton.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.drawable;
        if (d != null && d.isStateful() && d.setState(this.getDrawableState())) {
            this.invalidateDrawable(d);
        }
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.drawable;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.drawable != null) {
            this.drawable.jumpToCurrentState();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = (Boolean)in.readValue(((Object)((Object)this)).getClass().getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.checked);
        }

        public String toString() {
            return "RadioButton.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " checked=" + this.checked + "}";
        }
    }
}

