/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.drawable.ripple.RippleDrawable;
import carbon.internal.SeekBarPopup;

public class RangeSeekBar
extends carbon.view.View {
    private static float THUMB_RADIUS;
    private static float THUMB_RADIUS_DRAGGED;
    private static float STROKE_WIDTH;
    float value = 0.3f;
    float value2 = 0.7f;
    float min = 0.0f;
    float max = 1.0f;
    float step = 1.0f;
    float thumbRadius;
    float thumbRadius2;
    int tickStep = 1;
    boolean tick = true;
    int tickColor = 0;
    boolean showLabel;
    String labelFormat;
    SeekBarPopup popup;
    OnValueChangedListener onValueChangedListener;
    int draggedThumb = -1;
    Paint paint = new Paint(3);
    private int colorControl;
    private Style style;
    DecelerateInterpolator interpolator = new DecelerateInterpolator();
    private ValueAnimator radiusAnimator;
    private ValueAnimator valueAnimator;

    public RangeSeekBar(Context context) {
        super(context, null, 16842875);
        this.initSeekBar(null, 16842875, R.style.carbon_SeekBar);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs, 16842875);
        this.initSeekBar(attrs, 16842875, R.style.carbon_SeekBar);
    }

    public RangeSeekBar(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initSeekBar(attrs, defStyleAttr, R.style.carbon_SeekBar);
    }

    @TargetApi(value=21)
    public RangeSeekBar(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initSeekBar(attrs, defStyleAttr, defStyleRes);
    }

    private void initSeekBar(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        this.colorControl = Carbon.getThemeColor(this.getContext(), R.attr.colorControlNormal);
        this.thumbRadius2 = THUMB_RADIUS = Carbon.getDip(this.getContext()) * 8.0f;
        this.thumbRadius = THUMB_RADIUS;
        THUMB_RADIUS_DRAGGED = Carbon.getDip(this.getContext()) * 10.0f;
        STROKE_WIDTH = Carbon.getDip(this.getContext()) * 2.0f;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyleAttr, defStyleRes);
        this.setStyle(Style.values()[a.getInt(R.styleable.SeekBar_carbon_barStyle, 0)]);
        this.setMin(a.getFloat(R.styleable.SeekBar_carbon_min, 0.0f));
        this.setMax(a.getFloat(R.styleable.SeekBar_carbon_max, 0.0f));
        this.setStepSize(a.getFloat(R.styleable.SeekBar_carbon_stepSize, 0.0f));
        this.setValue(a.getFloat(R.styleable.SeekBar_carbon_value, 0.0f));
        this.setValue2(a.getFloat(R.styleable.SeekBar_carbon_value2, 0.0f));
        this.setTick(a.getBoolean(R.styleable.SeekBar_carbon_tick, true));
        this.setTickStep(a.getInt(R.styleable.SeekBar_carbon_tickStep, 1));
        this.setTickColor(a.getColor(R.styleable.SeekBar_carbon_tickColor, 0));
        this.setShowLabel(a.getBoolean(R.styleable.SeekBar_carbon_showLabel, false));
        this.setLabelFormat(a.getString(R.styleable.SeekBar_carbon_labelFormat));
        a.recycle();
        this.setFocusableInTouchMode(false);
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max((int)Math.ceil(THUMB_RADIUS_DRAGGED * 2.0f), super.getSuggestedMinimumWidth());
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max((int)Math.ceil(THUMB_RADIUS_DRAGGED * 2.0f), super.getSuggestedMinimumHeight());
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = this.getSuggestedMinimumWidth();
        int desiredHeight = this.getSuggestedMinimumHeight();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        boolean ltr = ViewCompat.getLayoutDirection((View)this) == 0;
        float v = (this.value - this.min) / (this.max - this.min);
        if (!ltr) {
            v = 1.0f - v;
        }
        float v2 = (this.value2 - this.min) / (this.max - this.min);
        if (!ltr) {
            v2 = 1.0f - v2;
        }
        int thumbX = (int)(v * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        int thumbY = this.getHeight() / 2;
        int thumbX2 = (int)(v2 * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        this.paint.setStrokeWidth(STROKE_WIDTH);
        this.paint.setColor(this.colorControl);
        if (ltr) {
            if ((float)this.getPaddingLeft() + this.thumbRadius < (float)thumbX - this.thumbRadius) {
                canvas.drawLine((float)this.getPaddingLeft(), (float)thumbY, (float)thumbX - this.thumbRadius, (float)thumbY, this.paint);
            }
            if ((float)thumbX2 + this.thumbRadius2 < (float)(this.getWidth() - this.getPaddingRight()) - this.thumbRadius2) {
                canvas.drawLine((float)thumbX2 + this.thumbRadius2, (float)thumbY, (float)(this.getWidth() - this.getPaddingRight()), (float)thumbY, this.paint);
            }
        } else {
            if ((float)this.getPaddingLeft() + this.thumbRadius2 < (float)thumbX2 - this.thumbRadius2) {
                canvas.drawLine((float)this.getPaddingLeft(), (float)thumbY, (float)thumbX2 - this.thumbRadius2, (float)thumbY, this.paint);
            }
            if ((float)thumbX + this.thumbRadius < (float)(this.getWidth() - this.getPaddingRight()) - this.thumbRadius) {
                canvas.drawLine((float)thumbX + this.thumbRadius, (float)thumbY, (float)(this.getWidth() - this.getPaddingRight()), (float)thumbY, this.paint);
            }
        }
        if (!this.isInEditMode()) {
            this.paint.setColor(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1);
        }
        canvas.drawLine((float)thumbX + this.thumbRadius, (float)thumbY, (float)thumbX2 - this.thumbRadius2, (float)thumbY, this.paint);
        if (this.style == Style.Discrete && this.tick) {
            this.paint.setColor(this.tickColor);
            float range = (this.max - this.min) / this.step;
            int i = 0;
            while ((float)i < range) {
                canvas.drawCircle((float)i / range * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft(), (float)this.getHeight() / 2.0f, STROKE_WIDTH / 2.0f, this.paint);
                i += this.tickStep;
            }
            canvas.drawCircle((float)(this.getWidth() - this.getPaddingRight()), (float)this.getHeight() / 2.0f, STROKE_WIDTH / 2.0f, this.paint);
        }
        if (!this.isInEditMode()) {
            this.paint.setColor(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1);
        }
        canvas.drawCircle((float)thumbX, (float)thumbY, this.thumbRadius, this.paint);
        canvas.drawCircle((float)thumbX2, (float)thumbY, this.thumbRadius2, this.paint);
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        if (showLabel) {
            this.popup = new SeekBarPopup(this.getContext());
        }
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    public void setLabelFormat(String format) {
        this.labelFormat = format;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style2) {
        this.style = style2;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max > this.min ? max : this.min + this.step;
        this.value = Math.max(this.min, Math.min(this.value, max));
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min < this.max ? min : (this.max > this.step ? this.max - this.step : 0.0f);
        this.value = Math.max(min, Math.min(this.value, this.max));
    }

    private int stepValue(float v) {
        return (int)(Math.floor((v - this.min + this.step / 2.0f) / this.step) * (double)this.step + (double)this.min);
    }

    public float getValue() {
        if (this.style == Style.Discrete) {
            return this.stepValue(this.value);
        }
        return this.value;
    }

    public void setValue(float value) {
        this.value = this.style == Style.Discrete ? (float)this.stepValue(Math.max(this.min, Math.min(value, this.max))) : Math.max(this.min, Math.min(value, this.max));
    }

    public float getValue2() {
        if (this.style == Style.Discrete) {
            return this.stepValue(this.value2);
        }
        return this.value2;
    }

    public void setValue2(float value2) {
        this.value2 = this.style == Style.Discrete ? (float)this.stepValue(Math.max(this.min, Math.min(value2, this.max))) : Math.max(this.min, Math.min(value2, this.max));
    }

    public float getStepSize() {
        return this.step;
    }

    public void setStepSize(float step) {
        this.step = step > 0.0f ? step : 1.0f;
    }

    public boolean hasTick() {
        return this.tick;
    }

    public void setTick(boolean tick) {
        this.tick = tick;
    }

    public int getTickStep() {
        return this.tickStep;
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    public int getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(int tickColor) {
        this.tickColor = tickColor;
    }

    public void setOnValueChangedListener(OnValueChangedListener onValueChangedListener) {
        this.onValueChangedListener = onValueChangedListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean ltr = ViewCompat.getLayoutDirection((View)this) == 0;
        float v = (this.value - this.min) / (this.max - this.min);
        float v2 = (this.value2 - this.min) / (this.max - this.min);
        if (event.getAction() == 0) {
            int thumbX = (int)(v * ((float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) - this.thumbRadius * 2.0f) + (float)this.getPaddingLeft() + this.thumbRadius);
            int thumbX2 = (int)(v2 * ((float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) - this.thumbRadius2 * 2.0f) + (float)this.getPaddingLeft() + this.thumbRadius2);
            if (!ltr) {
                int swap = thumbX2;
                thumbX2 = thumbX;
                thumbX = swap;
            }
            if (Math.abs(event.getX() - (float)thumbX) < Math.abs(event.getX() - (float)thumbX2)) {
                this.draggedThumb = 1;
                Log.e((String)"seekbar", (String)"dragged thumb 1");
                if (this.radiusAnimator != null) {
                    this.radiusAnimator.end();
                }
                this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius, THUMB_RADIUS_DRAGGED});
                this.radiusAnimator.setDuration(200L);
                this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                this.radiusAnimator.addUpdateListener(animation -> {
                    this.thumbRadius = ((Float)animation.getAnimatedValue()).floatValue();
                    this.postInvalidate();
                });
                this.radiusAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        RangeSeekBar.this.radiusAnimator = null;
                    }
                });
                this.radiusAnimator.start();
            } else {
                this.draggedThumb = 2;
                Log.e((String)"seekbar", (String)"dragged thumb 2");
                if (this.radiusAnimator != null) {
                    this.radiusAnimator.end();
                }
                this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius2, THUMB_RADIUS_DRAGGED});
                this.radiusAnimator.setDuration(200L);
                this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                this.radiusAnimator.addUpdateListener(animation -> {
                    this.thumbRadius2 = ((Float)animation.getAnimatedValue()).floatValue();
                    this.postInvalidate();
                });
                this.radiusAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        RangeSeekBar.this.radiusAnimator = null;
                    }
                });
                this.radiusAnimator.start();
            }
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            if (this.showLabel) {
                this.popup.show(this);
            }
        } else if (event.getAction() == 3 || event.getAction() == 1) {
            if (this.draggedThumb == 1) {
                if (this.style == Style.Discrete) {
                    float val = (float)Math.floor((this.value - this.min + this.step / 2.0f) / this.step) * this.step + this.min;
                    if (this.valueAnimator != null) {
                        this.valueAnimator.cancel();
                    }
                    this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.value, val});
                    this.valueAnimator.setDuration(200L);
                    this.valueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                    this.valueAnimator.addUpdateListener(animation -> {
                        this.value = ((Float)animation.getAnimatedValue()).floatValue();
                        float vNorm = (this.value - this.min) / (this.max - this.min);
                        int thumbX = ltr ? (int)(vNorm * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft()) : (int)((1.0f - vNorm) * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
                        int thumbY = this.getHeight() / 2;
                        int radius = this.rippleDrawable.getRadius();
                        this.rippleDrawable.setBounds(thumbX - radius, thumbY - radius, thumbX + radius, thumbY + radius);
                        this.postInvalidate();
                    });
                    this.valueAnimator.start();
                }
                if (this.radiusAnimator != null) {
                    this.radiusAnimator.end();
                }
                this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius, THUMB_RADIUS});
                this.radiusAnimator.setDuration(200L);
                this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                this.radiusAnimator.addUpdateListener(animation -> {
                    this.thumbRadius = ((Float)animation.getAnimatedValue()).floatValue();
                    this.postInvalidate();
                });
                this.radiusAnimator.start();
            } else {
                if (this.style == Style.Discrete) {
                    float val2 = (float)Math.floor((this.value2 - this.min + this.step / 2.0f) / this.step) * this.step + this.min;
                    if (this.valueAnimator != null) {
                        this.valueAnimator.cancel();
                    }
                    this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.value2, val2});
                    this.valueAnimator.setDuration(200L);
                    this.valueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                    this.valueAnimator.addUpdateListener(animation -> {
                        this.value2 = ((Float)animation.getAnimatedValue()).floatValue();
                        float vNorm = (this.value2 - this.min) / (this.max - this.min);
                        int thumbX = ltr ? (int)(vNorm * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft()) : (int)((1.0f - vNorm) * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
                        int thumbY = this.getHeight() / 2;
                        int radius = this.rippleDrawable.getRadius();
                        this.rippleDrawable.setBounds(thumbX - radius, thumbY - radius, thumbX + radius, thumbY + radius);
                        this.postInvalidate();
                    });
                    this.valueAnimator.start();
                }
                if (this.radiusAnimator != null) {
                    this.radiusAnimator.end();
                }
                this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius2, THUMB_RADIUS});
                this.radiusAnimator.setDuration(200L);
                this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                this.radiusAnimator.addUpdateListener(animation -> {
                    this.thumbRadius2 = ((Float)animation.getAnimatedValue()).floatValue();
                    this.postInvalidate();
                });
                this.radiusAnimator.start();
            }
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(false);
            }
            if (this.showLabel) {
                this.popup.dismiss();
            }
        }
        if (this.draggedThumb == 1) {
            v = (event.getX() - (float)this.getPaddingLeft()) / (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
            v = Math.max(0.0f, Math.min(v, 1.0f));
            if (!ltr) {
                v = 1.0f - v;
            }
        } else if (this.draggedThumb == 2) {
            v2 = (event.getX() - (float)this.getPaddingLeft()) / (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
            v2 = Math.max(0.0f, Math.min(v2, 1.0f));
            if (!ltr) {
                v2 = 1.0f - v2;
            }
        }
        if (v > v2) {
            this.draggedThumb = 3 - this.draggedThumb;
            float t = v;
            v = v2;
            v2 = t;
            t = this.thumbRadius;
            this.thumbRadius = this.thumbRadius2;
            this.thumbRadius2 = t;
        }
        float newValue = v * (this.max - this.min) + this.min;
        float newValue2 = v2 * (this.max - this.min) + this.min;
        int thumbX = 0;
        if (this.draggedThumb == 1) {
            thumbX = ltr ? (int)(v * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft()) : (int)((1.0f - v) * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        } else if (this.draggedThumb == 2) {
            thumbX = ltr ? (int)(v2 * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft()) : (int)((1.0f - v2) * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        }
        int thumbY = this.getHeight() / 2;
        int radius = this.rippleDrawable.getRadius();
        if (this.showLabel && this.draggedThumb > 0) {
            int[] location = new int[2];
            this.getLocationInWindow(location);
            this.popup.setText(String.format(this.labelFormat, Float.valueOf(this.draggedThumb == 1 ? newValue : newValue2)));
            this.popup.update(thumbX + location[0] - this.popup.getBubbleWidth() / 2, thumbY - radius + location[1] - this.popup.getHeight());
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setHotspot(event.getX(), event.getY());
            this.rippleDrawable.setBounds(thumbX - radius, thumbY - radius, thumbX + radius, thumbY + radius);
        }
        this.postInvalidate();
        if ((newValue != this.value || newValue2 != this.value2) && this.onValueChangedListener != null) {
            if (this.style == Style.Discrete) {
                int sv = this.stepValue(newValue);
                int sv2 = this.stepValue(newValue2);
                if (this.stepValue(this.value) != sv || this.stepValue(this.value2) != sv2) {
                    this.onValueChangedListener.onValueChanged(this, sv, sv2);
                }
            } else {
                this.onValueChangedListener.onValueChanged(this, newValue, newValue2);
            }
        }
        this.value = newValue;
        this.value2 = newValue2;
        super.onTouchEvent(event);
        return true;
    }

    public static interface OnValueChangedListener {
        public void onValueChanged(RangeSeekBar var1, float var2, float var3);
    }

    public static enum Style {
        Continuous,
        Discrete;

    }
}

