/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import androidx.annotation.AttrRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.animation.AnimatedView;
import carbon.animation.StateAnimator;
import carbon.drawable.EdgeEffect;
import carbon.drawable.ripple.RippleDrawable;
import carbon.drawable.ripple.RippleView;
import carbon.internal.ElevationComparator;
import carbon.internal.RevealAnimator;
import carbon.recycler.DividerItemDecoration;
import carbon.recycler.ViewItemDecoration;
import carbon.view.MarginView;
import carbon.view.MaxSizeView;
import carbon.view.RevealView;
import carbon.view.ShadowView;
import carbon.view.ShapeModelView;
import carbon.view.StateAnimatorView;
import carbon.view.StrokeView;
import carbon.view.TintedView;
import carbon.view.TouchMarginView;
import carbon.view.VisibleView;
import carbon.widget.OnTransformationChangedListener;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecyclerView
extends androidx.recyclerview.widget.RecyclerView
implements ShadowView,
RippleView,
TouchMarginView,
StateAnimatorView,
AnimatedView,
ShapeModelView,
TintedView,
StrokeView,
MaxSizeView,
RevealView,
VisibleView,
MarginView {
    private boolean childDrawingOrderCallbackSet = false;
    private int scrollX = 0;
    private int scrollY = 0;
    private EdgeEffect leftGlow;
    private EdgeEffect rightGlow;
    private EdgeEffect topGlow;
    private EdgeEffect bottomGlow;
    private DividerItemDecoration dividerItemDecoration;
    private View.OnTouchListener onDispatchTouchListener;
    private ArrayList<ViewItemDecoration> viewItemDecorations = new ArrayList();
    private static int[] animationIds = new int[]{R.styleable.RecyclerView_carbon_inAnimation, R.styleable.RecyclerView_carbon_outAnimation};
    private static int[] tintIds = new int[]{R.styleable.RecyclerView_carbon_tint, R.styleable.RecyclerView_carbon_tintMode, R.styleable.RecyclerView_carbon_backgroundTint, R.styleable.RecyclerView_carbon_backgroundTintMode, R.styleable.RecyclerView_carbon_animateColorChanges};
    private static int[] strokeIds = new int[]{R.styleable.RecyclerView_carbon_stroke, R.styleable.RecyclerView_carbon_strokeWidth};
    private static int[] cornerCutRadiusIds = new int[]{R.styleable.RecyclerView_carbon_cornerRadiusTopStart, R.styleable.RecyclerView_carbon_cornerRadiusTopEnd, R.styleable.RecyclerView_carbon_cornerRadiusBottomStart, R.styleable.RecyclerView_carbon_cornerRadiusBottomEnd, R.styleable.RecyclerView_carbon_cornerRadius, R.styleable.RecyclerView_carbon_cornerCutTopStart, R.styleable.RecyclerView_carbon_cornerCutTopEnd, R.styleable.RecyclerView_carbon_cornerCutBottomStart, R.styleable.RecyclerView_carbon_cornerCutBottomEnd, R.styleable.RecyclerView_carbon_cornerCut};
    private static int[] maxSizeIds = new int[]{R.styleable.RecyclerView_carbon_maxWidth, R.styleable.RecyclerView_carbon_maxHeight};
    private static int[] elevationIds = new int[]{R.styleable.RecyclerView_carbon_elevation, R.styleable.RecyclerView_carbon_elevationShadowColor, R.styleable.RecyclerView_carbon_elevationAmbientShadowColor, R.styleable.RecyclerView_carbon_elevationSpotShadowColor};
    Pagination pagination;
    private Paint paint = new Paint(3);
    private boolean drawCalled = false;
    RevealAnimator revealAnimator;
    private RectF boundsRect = new RectF();
    private Path cornersMask = new Path();
    private RippleDrawable rippleDrawable;
    private float elevation = 0.0f;
    private float translationZ = 0.0f;
    private ShapeAppearanceModel shapeModel = new ShapeAppearanceModel();
    private MaterialShapeDrawable shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
    private ColorStateList ambientShadowColor;
    private ColorStateList spotShadowColor;
    private Rect touchMargin = new Rect();
    final RectF tmpHitRect = new RectF();
    private StateAnimator stateAnimator = new StateAnimator(this);
    private Animator inAnim = null;
    private Animator outAnim = null;
    private Animator animator;
    List<View> views = new ArrayList<View>();
    ColorStateList tint;
    PorterDuff.Mode tintMode;
    ColorStateList backgroundTint;
    PorterDuff.Mode backgroundTintMode;
    boolean animateColorChanges;
    ValueAnimator.AnimatorUpdateListener tintAnimatorListener = animation -> {
        this.updateTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };
    ValueAnimator.AnimatorUpdateListener backgroundTintAnimatorListener = animation -> {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable) {
            background = ((RippleDrawable)background).getBackground();
        }
        if (background != null && this.backgroundTint != null && this.backgroundTintMode != null) {
            background.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.backgroundTint.getColorForState(background.getState(), this.backgroundTint.getDefaultColor()), this.backgroundTintMode));
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    };
    private ColorStateList stroke;
    private float strokeWidth;
    private Paint strokePaint;
    int maxWidth = Integer.MAX_VALUE;
    int maxHeight = Integer.MAX_VALUE;
    List<OnTransformationChangedListener> transformationChangedListeners = new ArrayList<OnTransformationChangedListener>();

    public RecyclerView(Context context) {
        super(context, null, R.attr.carbon_recyclerViewStyle);
        this.initRecycler(null, R.attr.carbon_recyclerViewStyle, R.style.carbon_RecyclerView);
    }

    public RecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_recyclerViewStyle);
        this.initRecycler(attrs, R.attr.carbon_recyclerViewStyle, R.style.carbon_RecyclerView);
    }

    public RecyclerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initRecycler(attrs, defStyleAttr, R.style.carbon_RecyclerView);
    }

    public RecyclerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.initRecycler(attrs, defStyleAttr, defStyleRes);
    }

    private void initRecycler(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.RecyclerView, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.RecyclerView_carbon_overScroll) {
                this.setOverScrollMode(a.getInt(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.RecyclerView_android_divider) continue;
            Drawable drawable2 = Carbon.getDefaultColorDrawable((View)this, a, attr2);
            float height = a.getDimension(R.styleable.RecyclerView_android_dividerHeight, 0.0f);
            if (drawable2 == null || !(height > 0.0f)) continue;
            this.setDivider(drawable2, (int)height);
        }
        Carbon.initDefaultBackground((View)this, a, R.styleable.RecyclerView_android_background);
        Carbon.initElevation(this, a, elevationIds);
        Carbon.initAnimations(this, a, animationIds);
        Carbon.initMaxSize(this, a, maxSizeIds);
        Carbon.initTint(this, a, tintIds);
        Carbon.initStroke(this, a, strokeIds);
        Carbon.initCornerCutRadius(this, a, cornerCutRadiusIds);
        a.recycle();
        this.setClipToPadding(false);
        this.setWillNotDraw(false);
        this.setEdgeEffectFactory(new EdgeEffectFactory());
    }

    public DividerItemDecoration setDivider(Drawable divider, int height) {
        if (divider == null && this.dividerItemDecoration != null) {
            this.removeItemDecoration(this.dividerItemDecoration);
            this.dividerItemDecoration = null;
        } else {
            this.dividerItemDecoration = new DividerItemDecoration(divider, height);
            this.dividerItemDecoration.setDrawBefore(position -> position > 0);
            this.addItemDecoration(this.dividerItemDecoration);
        }
        return this.dividerItemDecoration;
    }

    public void clearItemDecorations() {
        this.dividerItemDecoration = null;
        for (int i = 0; i < this.getItemDecorationCount(); ++i) {
            this.removeItemDecorationAt(i);
        }
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        super.addItemDecoration(decor, index);
        if (decor instanceof ViewItemDecoration) {
            this.viewItemDecorations.add((ViewItemDecoration)decor);
        }
    }

    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        super.removeItemDecoration(decor);
        if (decor instanceof ViewItemDecoration) {
            this.viewItemDecorations.remove(decor);
        }
    }

    public void offsetChildrenHorizontal(int dx) {
        super.offsetChildrenHorizontal(dx);
        this.scrollX -= dx;
    }

    public int getListScrollX() {
        return this.scrollX;
    }

    public int getMaxScrollX() {
        RecyclerView.Adapter adapter = this.getAdapter();
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (adapter == null || layoutManager == null || this.getChildCount() == 0 || adapter.getItemCount() == 0) {
            return 0;
        }
        View view = this.getChildAt(this.getChildCount() - 1);
        int position = this.getChildAdapterPosition(view);
        if (position == adapter.getItemCount()) {
            return Math.max(0, view.getRight() - this.getWidth());
        }
        return Integer.MAX_VALUE;
    }

    public void offsetChildrenVertical(int dy) {
        super.offsetChildrenVertical(dy);
        this.scrollY -= dy;
    }

    public int getListScrollY() {
        return this.scrollY;
    }

    public int getMaxScrollY() {
        RecyclerView.Adapter adapter = this.getAdapter();
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (adapter == null || layoutManager == null || this.getChildCount() == 0 || adapter.getItemCount() == 0) {
            return 0;
        }
        View view = this.getChildAt(this.getChildCount() - 1);
        int position = this.getChildAdapterPosition(view);
        if (position == adapter.getItemCount()) {
            return Math.max(0, view.getBottom() - this.getHeight());
        }
        return Integer.MAX_VALUE;
    }

    public void setPagination(Pagination pagination) {
        if (this.pagination != null) {
            this.removeOnScrollListener(this.pagination);
        }
        this.pagination = pagination;
        if (pagination != null) {
            this.addOnScrollListener(pagination);
        }
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setColorFilter(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1, this.tintMode);
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    public Point getLocationOnScreen() {
        int[] outLocation = new int[2];
        super.getLocationOnScreen(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    public Point getLocationInWindow() {
        int[] outLocation = new int[2];
        super.getLocationInWindow(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(View hotspot, float startRadius, float finishRadius) {
        int[] location = new int[2];
        hotspot.getLocationOnScreen(location);
        int[] myLocation = new int[2];
        this.getLocationOnScreen(myLocation);
        return this.createCircularReveal(location[0] - myLocation[0] + hotspot.getWidth() / 2, location[1] - myLocation[1] + hotspot.getHeight() / 2, startRadius, finishRadius);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(int x, int y, float startRadius, float finishRadius) {
        startRadius = Carbon.getRevealRadius((View)this, x, y, startRadius);
        finishRadius = Carbon.getRevealRadius((View)this, x, y, finishRadius);
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            Animator circularReveal = ViewAnimationUtils.createCircularReveal((View)this, (int)x, (int)y, (float)startRadius, (float)finishRadius);
            circularReveal.setDuration(Carbon.getDefaultRevealDuration());
            return circularReveal;
        }
        this.revealAnimator = new RevealAnimator(x, y, startRadius, finishRadius);
        this.revealAnimator.setDuration(Carbon.getDefaultRevealDuration());
        this.revealAnimator.addUpdateListener(animation -> {
            RevealAnimator reveal = (RevealAnimator)animation;
            reveal.radius = ((Float)reveal.getAnimatedValue()).floatValue();
            reveal.mask.reset();
            reveal.mask.addCircle(reveal.x, reveal.y, Math.max(((Float)reveal.getAnimatedValue()).floatValue(), 1.0f), Path.Direction.CW);
            this.postInvalidate();
        });
        this.revealAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                RecyclerView.this.revealAnimator = null;
            }

            public void onAnimationEnd(Animator animation) {
                RecyclerView.this.revealAnimator = null;
            }
        });
        return this.revealAnimator;
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        boolean c;
        boolean r = this.revealAnimator != null && this.revealAnimator.isRunning();
        boolean bl = c = !Carbon.isShapeRect(this.shapeModel, this.boundsRect);
        if (Carbon.IS_PIE_OR_HIGHER) {
            if (this.spotShadowColor != null) {
                super.setOutlineSpotShadowColor(this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()));
            }
            if (this.ambientShadowColor != null) {
                super.setOutlineAmbientShadowColor(this.ambientShadowColor.getColorForState(this.getDrawableState(), this.ambientShadowColor.getDefaultColor()));
            }
        }
        if (this.isInEditMode() && !this.drawCalled && (r || c) && this.getWidth() > 0 && this.getHeight() > 0) {
            Bitmap layer = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas layerCanvas = new Canvas(layer);
            this.dispatchDrawInternal(layerCanvas);
            Bitmap mask = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mask);
            Paint maskPaint = new Paint(-1);
            maskCanvas.drawPath(this.cornersMask, maskPaint);
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int maskPixel = mask.getPixel(x, y);
                    layer.setPixel(x, y, Color.alpha((int)maskPixel) > 0 ? layer.getPixel(x, y) : 0);
                }
            }
            canvas.drawBitmap(layer, 0.0f, 0.0f, this.paint);
        } else if (!this.drawCalled && (r || c) && this.getWidth() > 0 && this.getHeight() > 0 && !Carbon.IS_LOLLIPOP_OR_HIGHER) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            if (r) {
                int saveCount2 = canvas.save();
                canvas.clipRect(this.revealAnimator.x - this.revealAnimator.radius, this.revealAnimator.y - this.revealAnimator.radius, this.revealAnimator.x + this.revealAnimator.radius, this.revealAnimator.y + this.revealAnimator.radius);
                this.dispatchDrawInternal(canvas);
                canvas.restoreToCount(saveCount2);
            } else {
                this.dispatchDrawInternal(canvas);
            }
            this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
            if (c) {
                this.cornersMask.setFillType(Path.FillType.INVERSE_WINDING);
                canvas.drawPath(this.cornersMask, this.paint);
            }
            if (r) {
                canvas.drawPath(this.revealAnimator.mask, this.paint);
            }
            this.paint.setXfermode(null);
            canvas.restoreToCount(saveCount);
        } else {
            this.dispatchDrawInternal(canvas);
        }
        this.drawCalled = false;
    }

    private void dispatchDrawInternal(@NonNull Canvas canvas) {
        Collections.sort(this.getViews(), new ElevationComparator());
        super.dispatchDraw(canvas);
        if (this.stroke != null) {
            this.drawStroke(canvas);
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    public boolean drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        RippleView rippleView;
        RippleDrawable rippleDrawable;
        if (child instanceof ShadowView && (!Carbon.IS_LOLLIPOP_OR_HIGHER || ((ShadowView)child).getElevationShadowColor() != null && !Carbon.IS_PIE_OR_HIGHER)) {
            ShadowView shadowView = (ShadowView)child;
            shadowView.drawShadow(canvas);
        }
        if (child instanceof RippleView && (rippleDrawable = (rippleView = (RippleView)child).getRippleDrawable()) != null && rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            int saveCount = canvas.save();
            canvas.translate((float)child.getLeft(), (float)child.getTop());
            canvas.concat(child.getMatrix());
            rippleDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    protected int getChildDrawingOrder(int childCount, int child) {
        if (this.childDrawingOrderCallbackSet) {
            return super.getChildDrawingOrder(childCount, child);
        }
        if (this.views.size() != childCount) {
            this.getViews();
        }
        return this.indexOfChild(this.views.get(child));
    }

    public void setChildDrawingOrderCallback(RecyclerView.ChildDrawingOrderCallback childDrawingOrderCallback) {
        super.setChildDrawingOrderCallback(childDrawingOrderCallback);
        this.childDrawingOrderCallbackSet = childDrawingOrderCallback != null;
    }

    protected boolean isTransformedTouchPointInView(float x, float y, View child, PointF outLocalPoint) {
        Rect frame = new Rect();
        child.getHitRect(frame);
        return frame.contains((int)x, (int)y);
    }

    @Override
    @NotNull
    public ShapeAppearanceModel getShapeModel() {
        return this.shapeModel;
    }

    @Override
    public void setCornerRadius(float cornerRadius) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new RoundedCornerTreatment(cornerRadius)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setCornerCut(float cornerCut) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new CutCornerTreatment(cornerCut)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setShapeModel(@NotNull ShapeAppearanceModel model) {
        this.shapeModel = model;
        this.shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.updateCorners();
        }
        if (!Carbon.IS_LOLLIPOP_OR_HIGHER) {
            this.postInvalidate();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!changed) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.updateCorners();
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void updateCorners() {
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (!Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
                this.setClipToOutline(true);
            }
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (Carbon.isShapeRect(RecyclerView.this.shapeModel, RecyclerView.this.boundsRect)) {
                        outline.setRect(0, 0, RecyclerView.this.getWidth(), RecyclerView.this.getHeight());
                    } else {
                        RecyclerView.this.shadowDrawable.setBounds(0, 0, RecyclerView.this.getWidth(), RecyclerView.this.getHeight());
                        RecyclerView.this.shadowDrawable.setShadowCompatibilityMode(1);
                        RecyclerView.this.shadowDrawable.getOutline(outline);
                    }
                }
            });
        }
        this.boundsRect.set(this.shadowDrawable.getBounds());
        this.shadowDrawable.getPathForSize(this.getWidth(), this.getHeight(), this.cornersMask);
    }

    public void drawInternal(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.stroke != null) {
            this.drawStroke(canvas);
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(@NonNull Canvas canvas) {
        boolean c;
        this.drawCalled = true;
        boolean r = this.revealAnimator != null;
        boolean bl = c = !Carbon.isShapeRect(this.shapeModel, this.boundsRect);
        if (Carbon.IS_PIE_OR_HIGHER) {
            if (this.spotShadowColor != null) {
                super.setOutlineSpotShadowColor(this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()));
            }
            if (this.ambientShadowColor != null) {
                super.setOutlineAmbientShadowColor(this.ambientShadowColor.getColorForState(this.getDrawableState(), this.ambientShadowColor.getDefaultColor()));
            }
        }
        if (this.isInEditMode() && (r || c) && this.getWidth() > 0 && this.getHeight() > 0) {
            Bitmap layer = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas layerCanvas = new Canvas(layer);
            this.drawInternal(layerCanvas);
            Bitmap mask = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mask);
            Paint maskPaint = new Paint(-1);
            maskCanvas.drawPath(this.cornersMask, maskPaint);
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int maskPixel = mask.getPixel(x, y);
                    layer.setPixel(x, y, Color.alpha((int)maskPixel) > 0 ? layer.getPixel(x, y) : 0);
                }
            }
            canvas.drawBitmap(layer, 0.0f, 0.0f, this.paint);
        } else if (this.getWidth() > 0 && this.getHeight() > 0 && ((r || c) && !Carbon.IS_LOLLIPOP_OR_HIGHER || !this.shapeModel.isRoundRect(this.boundsRect))) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            if (r) {
                int saveCount2 = canvas.save();
                canvas.clipRect(this.revealAnimator.x - this.revealAnimator.radius, this.revealAnimator.y - this.revealAnimator.radius, this.revealAnimator.x + this.revealAnimator.radius, this.revealAnimator.y + this.revealAnimator.radius);
                this.drawInternal(canvas);
                canvas.restoreToCount(saveCount2);
            } else {
                this.drawInternal(canvas);
            }
            this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
            if (c) {
                this.cornersMask.setFillType(Path.FillType.INVERSE_WINDING);
                canvas.drawPath(this.cornersMask, this.paint);
            }
            if (r) {
                canvas.drawPath(this.revealAnimator.mask, this.paint);
            }
            this.paint.setXfermode(null);
            canvas.restoreToCount(saveCount);
            this.paint.setXfermode(null);
        } else {
            this.drawInternal(canvas);
        }
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (this.shadowDrawable.isPointInTransparentRegion((int)event.getX(), (int)event.getY())) {
            return false;
        }
        if (this.onDispatchTouchListener != null && this.onDispatchTouchListener.onTouch((View)this, event)) {
            return true;
        }
        if (this.rippleDrawable != null && event.getAction() == 0) {
            this.rippleDrawable.setHotspot(event.getX(), event.getY());
        }
        return super.dispatchTouchEvent(event);
    }

    @Override
    public RippleDrawable getRippleDrawable() {
        return this.rippleDrawable;
    }

    @Override
    public void setRippleDrawable(RippleDrawable newRipple) {
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setCallback(null);
            if (this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable(this.rippleDrawable.getBackground());
            }
        }
        if (newRipple != null) {
            newRipple.setCallback((Drawable.Callback)this);
            newRipple.setBounds(0, 0, this.getWidth(), this.getHeight());
            newRipple.setState(this.getDrawableState());
            ((Drawable)newRipple).setVisible(this.getVisibility() == 0, false);
            if (newRipple.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable((Drawable)newRipple);
            }
        }
        this.rippleDrawable = newRipple;
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || this.rippleDrawable == who;
    }

    public void invalidateDrawable(@NonNull Drawable drawable2) {
        super.invalidateDrawable(drawable2);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(@NonNull Rect dirty) {
        super.invalidate(dirty);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(int l, int t, int r, int b) {
        super.invalidate(l, t, r, b);
        this.invalidateParentIfNeeded();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateParentIfNeeded();
    }

    private void invalidateParentIfNeeded() {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).invalidate();
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).invalidate();
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        super.postInvalidateDelayed(delayMilliseconds);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        super.postInvalidateDelayed(delayMilliseconds, left, top, right, bottom);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    private void postInvalidateParentIfNeededDelayed(long delayMilliseconds) {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background instanceof RippleDrawable) {
            this.setRippleDrawable((RippleDrawable)background);
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
            this.rippleDrawable.setCallback(null);
            this.rippleDrawable = null;
        }
        super.setBackgroundDrawable(background);
        this.updateBackgroundTint();
    }

    @Override
    public float getElevation() {
        return this.elevation;
    }

    @Override
    public void setElevation(float elevation) {
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setElevation(elevation);
            super.setTranslationZ(this.translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setElevation(elevation);
                super.setTranslationZ(this.translationZ);
            } else {
                super.setElevation(0.0f);
                super.setTranslationZ(0.0f);
            }
        } else if (elevation != this.elevation && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.elevation = elevation;
    }

    @Override
    public float getTranslationZ() {
        return this.translationZ;
    }

    @Override
    public void setTranslationZ(float translationZ) {
        if (translationZ == this.translationZ) {
            return;
        }
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setTranslationZ(translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setTranslationZ(translationZ);
            } else {
                super.setTranslationZ(0.0f);
            }
        } else if (translationZ != this.translationZ && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.translationZ = translationZ;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public boolean hasShadow() {
        return this.getElevation() + this.getTranslationZ() >= 0.01f && this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public void drawShadow(@NotNull Canvas canvas) {
        int saveCount;
        boolean r;
        float alpha = this.getAlpha() * Carbon.getBackgroundTintAlpha((View)this) / 255.0f;
        if (alpha == 0.0f || !this.hasShadow()) {
            return;
        }
        float z = this.getElevation() + this.getTranslationZ();
        boolean maskShadow = this.getBackground() != null && alpha != 1.0f;
        boolean bl = r = this.revealAnimator != null && this.revealAnimator.isRunning();
        if (alpha != 1.0f) {
            this.paint.setAlpha((int)(255.0f * alpha));
            saveCount = canvas.saveLayer(-z, -z, (float)canvas.getWidth() + z, (float)canvas.getHeight() + z, this.paint, 31);
        } else {
            saveCount = canvas.save();
        }
        if (r) {
            canvas.clipRect((float)this.getLeft() + this.revealAnimator.x - this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y - this.revealAnimator.radius, (float)this.getLeft() + this.revealAnimator.x + this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y + this.revealAnimator.radius);
        }
        this.shadowDrawable.setFillColor(this.spotShadowColor);
        this.shadowDrawable.setShadowColor(this.spotShadowColor != null ? this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()) : -16777216);
        this.shadowDrawable.setShadowCompatibilityMode(2);
        this.shadowDrawable.setAlpha(68);
        this.shadowDrawable.setElevation(z);
        this.shadowDrawable.setShadowVerticalOffset(0);
        this.shadowDrawable.setBounds(this.getLeft(), (int)((float)this.getTop() + z / 4.0f), this.getRight(), (int)((float)this.getBottom() + z / 4.0f));
        this.shadowDrawable.draw(canvas);
        canvas.translate((float)this.getLeft(), (float)this.getTop());
        this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
        if (maskShadow) {
            this.cornersMask.setFillType(Path.FillType.WINDING);
            canvas.drawPath(this.cornersMask, this.paint);
        }
        if (r) {
            canvas.drawPath(this.revealAnimator.mask, this.paint);
        }
        canvas.restoreToCount(saveCount);
        this.paint.setXfermode(null);
        this.paint.setAlpha(255);
    }

    @Override
    public void setElevationShadowColor(ColorStateList shadowColor) {
        this.ambientShadowColor = this.spotShadowColor = shadowColor;
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public void setElevationShadowColor(int color2) {
        this.ambientShadowColor = this.spotShadowColor = ColorStateList.valueOf((int)color2);
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public ColorStateList getElevationShadowColor() {
        return this.ambientShadowColor;
    }

    @Override
    public void setOutlineAmbientShadowColor(int color2) {
        this.setOutlineAmbientShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineAmbientShadowColor(ColorStateList color2) {
        this.ambientShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineAmbientShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineAmbientShadowColor() {
        return this.ambientShadowColor.getDefaultColor();
    }

    @Override
    public void setOutlineSpotShadowColor(int color2) {
        this.setOutlineSpotShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineSpotShadowColor(ColorStateList color2) {
        this.spotShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineSpotShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineSpotShadowColor() {
        return this.spotShadowColor.getDefaultColor();
    }

    @Override
    public void setTouchMargin(int left, int top, int right, int bottom) {
        this.touchMargin.set(left, top, right, bottom);
    }

    @Override
    public void setTouchMarginLeft(int margin) {
        this.touchMargin.left = margin;
    }

    @Override
    public void setTouchMarginTop(int margin) {
        this.touchMargin.top = margin;
    }

    @Override
    public void setTouchMarginRight(int margin) {
        this.touchMargin.right = margin;
    }

    @Override
    public void setTouchMarginBottom(int margin) {
        this.touchMargin.bottom = margin;
    }

    @Override
    @NotNull
    public Rect getTouchMargin() {
        return this.touchMargin;
    }

    public void getHitRect(@NonNull Rect outRect) {
        Matrix matrix = this.getMatrix();
        if (matrix.isIdentity()) {
            outRect.set(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        } else {
            this.tmpHitRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            matrix.mapRect(this.tmpHitRect);
            outRect.set((int)this.tmpHitRect.left + this.getLeft(), (int)this.tmpHitRect.top + this.getTop(), (int)this.tmpHitRect.right + this.getLeft(), (int)this.tmpHitRect.bottom + this.getTop());
        }
        outRect.left -= this.touchMargin.left;
        outRect.top -= this.touchMargin.top;
        outRect.right += this.touchMargin.right;
        outRect.bottom += this.touchMargin.bottom;
    }

    @Override
    @NotNull
    public StateAnimator getStateAnimator() {
        return this.stateAnimator;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() != RippleDrawable.Style.Background) {
            this.rippleDrawable.setState(this.getDrawableState());
        }
        if (this.stateAnimator != null) {
            this.stateAnimator.setState(this.getDrawableState());
        }
        if (this.tint != null && this.tint instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.tint).setState(this.getDrawableState());
        }
        if (this.backgroundTint != null && this.backgroundTint instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.backgroundTint).setState(this.getDrawableState());
        }
    }

    @Override
    public Animator animateVisibility(final int visibility) {
        if (visibility == 0 && (this.getVisibility() != 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.inAnim != null) {
                this.animator = this.inAnim;
                this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        RecyclerView.this.animator = null;
                    }

                    public void onAnimationCancel(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        RecyclerView.this.animator = null;
                    }
                });
                this.animator.start();
            }
            this.setVisibility(visibility);
        } else if (visibility != 0 && (this.getVisibility() == 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.outAnim == null) {
                this.setVisibility(visibility);
                return null;
            }
            this.animator = this.outAnim;
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator a) {
                    if (((ValueAnimator)a).getAnimatedFraction() == 1.0f) {
                        RecyclerView.this.setVisibility(visibility);
                    }
                    a.removeListener((Animator.AnimatorListener)this);
                    RecyclerView.this.animator = null;
                }

                public void onAnimationCancel(Animator a) {
                    a.removeListener((Animator.AnimatorListener)this);
                    RecyclerView.this.animator = null;
                }
            });
            this.animator.start();
        } else {
            this.setVisibility(visibility);
        }
        return this.animator;
    }

    @Override
    public Animator getAnimator() {
        return this.animator;
    }

    @Override
    public Animator getOutAnimator() {
        return this.outAnim;
    }

    @Override
    public void setOutAnimator(Animator outAnim) {
        if (this.outAnim != null) {
            this.outAnim.setTarget(null);
        }
        this.outAnim = outAnim;
        if (outAnim != null) {
            outAnim.setTarget((Object)this);
        }
    }

    @Override
    public Animator getInAnimator() {
        return this.inAnim;
    }

    @Override
    public void setInAnimator(Animator inAnim) {
        if (this.inAnim != null) {
            this.inAnim.setTarget(null);
        }
        this.inAnim = inAnim;
        if (inAnim != null) {
            inAnim.setTarget((Object)this);
        }
    }

    public List<View> getViews() {
        this.views.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.views.add(this.getChildAt(i));
        }
        return this.views;
    }

    public void setOnDispatchTouchListener(View.OnTouchListener onDispatchTouchListener) {
        this.onDispatchTouchListener = onDispatchTouchListener;
    }

    @Override
    public void setTintList(ColorStateList list) {
        this.tint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.tintAnimatorListener) : list);
        this.updateTint();
    }

    @Override
    public void setTint(int color2) {
        this.setTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getTint() {
        return this.tint;
    }

    protected void updateTint() {
        if (this.tint == null) {
            return;
        }
        int color2 = this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor());
        if (this.leftGlow != null) {
            this.leftGlow.setColor(color2);
        }
        if (this.rightGlow != null) {
            this.rightGlow.setColor(color2);
        }
        if (this.topGlow != null) {
            this.topGlow.setColor(color2);
        }
        if (this.bottomGlow != null) {
            this.bottomGlow.setColor(color2);
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode mode) {
        this.tintMode = mode;
        this.updateTint();
    }

    @Override
    public PorterDuff.Mode getTintMode() {
        return this.tintMode;
    }

    @Override
    public void setBackgroundTintList(ColorStateList list) {
        this.backgroundTint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.backgroundTintAnimatorListener) : list);
        this.updateBackgroundTint();
    }

    @Override
    public void setBackgroundTint(int color2) {
        this.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getBackgroundTint() {
        return this.backgroundTint;
    }

    private void updateBackgroundTint() {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable) {
            background = ((RippleDrawable)background).getBackground();
        }
        if (background == null) {
            return;
        }
        if (this.backgroundTint != null && this.backgroundTintMode != null) {
            Carbon.setTintListMode(background, this.backgroundTint, this.backgroundTintMode);
        } else {
            Carbon.clearTint(background);
        }
        if (background.isStateful()) {
            background.setState(this.getDrawableState());
        }
    }

    @Override
    public void setBackgroundTintMode(@Nullable PorterDuff.Mode mode) {
        this.backgroundTintMode = mode;
        this.updateBackgroundTint();
    }

    @Override
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    @Override
    public boolean isAnimateColorChangesEnabled() {
        return this.animateColorChanges;
    }

    @Override
    public void setAnimateColorChangesEnabled(boolean animateColorChanges) {
        if (this.animateColorChanges == animateColorChanges) {
            return;
        }
        this.animateColorChanges = animateColorChanges;
        this.setTintList(this.tint);
        this.setBackgroundTintList(this.backgroundTint);
    }

    private void drawStroke(Canvas canvas) {
        this.strokePaint.setStrokeWidth(this.strokeWidth * 2.0f);
        this.strokePaint.setColor(this.stroke.getColorForState(this.getDrawableState(), this.stroke.getDefaultColor()));
        this.cornersMask.setFillType(Path.FillType.WINDING);
        canvas.drawPath(this.cornersMask, this.strokePaint);
    }

    @Override
    public void setStroke(ColorStateList colorStateList) {
        this.stroke = colorStateList;
        if (this.stroke == null) {
            return;
        }
        if (this.strokePaint == null) {
            this.strokePaint = new Paint(1);
            this.strokePaint.setStyle(Paint.Style.STROKE);
        }
    }

    @Override
    public void setStroke(int color2) {
        this.setStroke(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getStroke() {
        return this.stroke;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Override
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.requestLayout();
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getMeasuredWidth() > this.maxWidth || this.getMeasuredHeight() > this.maxHeight) {
            if (this.getMeasuredWidth() > this.maxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)0x40000000);
            }
            if (this.getMeasuredHeight() > this.maxHeight) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)0x40000000);
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void addOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.add(listener);
    }

    public void removeOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.remove(listener);
    }

    public void clearOnTransformationChangedListeners() {
        this.transformationChangedListeners.clear();
    }

    private void fireOnTransformationChangedListener() {
        if (this.transformationChangedListeners == null) {
            return;
        }
        for (OnTransformationChangedListener listener : this.transformationChangedListeners) {
            listener.onTransformationChanged();
        }
    }

    public void setRotation(float rotation) {
        super.setRotation(rotation);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationY(float rotationY) {
        super.setRotationY(rotationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationX(float rotationX) {
        super.setRotationX(rotationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleX(float scaleX) {
        super.setScaleX(scaleX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleY(float scaleY) {
        super.setScaleY(scaleY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotX(float pivotX) {
        super.setPivotX(pivotX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotY(float pivotY) {
        super.setPivotY(pivotY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        super.setAlpha(alpha);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, -2));
        } else {
            layoutParams.width = width;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, height));
        } else {
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        } else {
            layoutParams.width = width;
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setTranslationX(x);
        this.setTranslationY(y);
    }

    public static abstract class Pagination
    extends RecyclerView.OnScrollListener {
        private androidx.recyclerview.widget.LinearLayoutManager layoutManager;

        public Pagination(androidx.recyclerview.widget.LinearLayoutManager layoutManager) {
            this.layoutManager = layoutManager;
        }

        public void onScrolled(@NotNull androidx.recyclerview.widget.RecyclerView recyclerView, int dx, int dy) {
            int firstVisibleItemPosition = this.layoutManager.findFirstVisibleItemPosition();
            if (!this.isLoading() && !this.isLastPage() && this.layoutManager.getChildCount() + firstVisibleItemPosition >= this.layoutManager.getItemCount()) {
                this.loadNextPage();
            }
        }

        protected abstract boolean isLoading();

        protected abstract boolean isLastPage();

        protected abstract void loadNextPage();
    }

    public static class LinearLayoutManager
    extends androidx.recyclerview.widget.LinearLayoutManager {
        private int gravity;

        public LinearLayoutManager(Context context) {
            super(context);
        }

        public LinearLayoutManager(Context context, int orientation, boolean reverseLayout, int gravity) {
            super(context, orientation, reverseLayout);
            this.gravity = gravity;
        }

        public LinearLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
        }

        public int getGravity() {
            return this.gravity;
        }

        public void setGravity(int gravity) {
            this.gravity = gravity;
        }

        public void layoutDecoratedWithMargins(@NonNull View child, int left, int top, int right, int bottom) {
            if (this.getOrientation() == 1) {
                int absoluteGravity = GravityCompat.getAbsoluteGravity((int)this.gravity, (int)this.getLayoutDirection());
                if ((absoluteGravity & 1) != 0) {
                    int width = right - left;
                    right = (this.getWidth() + width) / 2;
                    left = (this.getWidth() - width) / 2;
                } else if ((absoluteGravity & 5) != 0) {
                    int width = right - left;
                    right = this.getWidth();
                    left = right - width;
                }
            } else {
                int absoluteGravity = GravityCompat.getAbsoluteGravity((int)this.gravity, (int)this.getLayoutDirection());
                if ((absoluteGravity & 0x10) != 0) {
                    int height = bottom - top;
                    bottom = (this.getHeight() + height) / 2;
                    top = (this.getHeight() - height) / 2;
                } else if ((absoluteGravity & 0x50) != 0) {
                    int height = bottom - top;
                    bottom = this.getHeight();
                    top = bottom - height;
                }
            }
            super.layoutDecoratedWithMargins(child, left, top, right, bottom);
        }

        public void layoutDecorated(@NonNull View child, int left, int top, int right, int bottom) {
            super.layoutDecorated(child, left, top, right, bottom);
        }
    }

    public class EdgeEffectFactory
    extends RecyclerView.EdgeEffectFactory {
        @NonNull
        protected android.widget.EdgeEffect createEdgeEffect(@NonNull androidx.recyclerview.widget.RecyclerView view, int direction) {
            EdgeEffect edgeEffect = new EdgeEffect(RecyclerView.this.getContext());
            if (direction == 1) {
                RecyclerView.this.topGlow = edgeEffect;
            } else if (direction == 3) {
                RecyclerView.this.bottomGlow = edgeEffect;
            } else if (direction == 0) {
                RecyclerView.this.leftGlow = edgeEffect;
            } else if (direction == 2) {
                RecyclerView.this.rightGlow = edgeEffect;
            }
            int color2 = RecyclerView.this.tint.getColorForState(RecyclerView.this.getDrawableState(), RecyclerView.this.tint.getDefaultColor());
            edgeEffect.setColor(color2);
            return edgeEffect;
        }
    }

    public static interface OnItemClickedListener2<Type> {
        public void onItemClicked(Type var1);
    }

    public static interface OnItemClickedListener<Type> {
        public void onItemClicked(View var1, Type var2, int var3);
    }
}

