/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleRes;
import carbon.R;
import carbon.view.SimpleTextWatcher;
import carbon.widget.EditText;
import carbon.widget.SearchAdapter;
import java.util.ArrayList;
import java.util.List;

public class SearchEditText
extends EditText {
    private OnFilterListener onFilterListener;
    private String prevText = "";
    protected TextWatcher searchTextWatcher;
    SearchAdapter dataProvider;
    SearchSettings settings = new SearchSettings();
    List filteredItems = new ArrayList();

    public SearchEditText(Context context) {
        super(context, null, R.attr.carbon_searchEditTextStyle);
        this.initSearchEditText();
    }

    public SearchEditText(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_searchEditTextStyle);
        this.initSearchEditText();
    }

    public SearchEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initSearchEditText();
    }

    @TargetApi(value=21)
    public SearchEditText(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initSearchEditText();
    }

    private void initSearchEditText() {
        this.searchTextWatcher = new SimpleTextWatcher(){

            @Override
            public void afterTextChanged(Editable text) {
                if (SearchEditText.this.settings.afterTextChanged && !SearchEditText.this.prevText.equals(text.toString())) {
                    SearchEditText.this.filter();
                }
                SearchEditText.this.prevText = text.toString();
            }
        };
        this.addTextChangedListener(this.searchTextWatcher);
    }

    public <Type> void setDataProvider(SearchAdapter<Type> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setMatchMode(MatchMode mode) {
        this.settings.matchMode = mode;
    }

    public MatchMode getMatchMode() {
        return this.settings.matchMode;
    }

    public void setSearchThreshold(int threshold) {
        this.settings.searchThreshold = threshold;
    }

    public int getSearchThreshold() {
        return this.settings.searchThreshold;
    }

    private void fireOnFilterEvent(List filteredItems) {
        if (this.onFilterListener != null) {
            this.onFilterListener.onFilter(filteredItems);
        }
    }

    @Override
    public void setText(CharSequence text, TextView.BufferType type) {
        this.prevText = this.getText().toString();
        super.setText(text, type);
    }

    public Editable getText() {
        try {
            return super.getText();
        }
        catch (ClassCastException e) {
            return new SpannableStringBuilder((CharSequence)"");
        }
    }

    public void filter() {
        this.filter(this.getText().toString());
    }

    public void filter(String query) {
        if (this.dataProvider == null) {
            return;
        }
        this.filteredItems.clear();
        if (query.length() < this.settings.searchThreshold) {
            this.fireOnFilterEvent(null);
            return;
        }
        for (int i = 0; i < this.dataProvider.getItemCount(); ++i) {
            Object item = this.dataProvider.getItem(i);
            if (!this.dataProvider.filterItem(this.settings, query, item)) continue;
            this.filteredItems.add(item);
        }
        this.fireOnFilterEvent(this.filteredItems);
    }

    public <Type> void setOnFilterListener(OnFilterListener<Type> onFilterListener) {
        this.onFilterListener = onFilterListener;
    }

    public <Type> List<Type> getFilteredItems() {
        return this.filteredItems;
    }

    public static interface OnFilterListener<Type> {
        public void onFilter(List<Type> var1);
    }

    public static class SearchSettings {
        public boolean afterTextChanged = true;
        public boolean matchCase = false;
        public int searchThreshold = 2;
        public MatchMode matchMode = MatchMode.ADJACENT;

        SearchSettings() {
        }
    }

    public static enum MatchMode {
        START,
        ADJACENT,
        NONADJACENT;

    }
}

