/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.drawable.ripple.RippleDrawable;
import carbon.internal.MathUtils;
import carbon.internal.SeekBarPopup;

public class SeekBar
extends carbon.view.View {
    private static float THUMB_RADIUS;
    private static float THUMB_RADIUS_DRAGGED;
    private static float STROKE_WIDTH;
    float value = 0.5f;
    float min = 0.0f;
    float max = 1.0f;
    float step = 1.0f;
    float thumbRadius;
    int tickStep = 1;
    boolean tick = true;
    int tickColor = 0;
    boolean showLabel;
    String labelFormat;
    SeekBarPopup popup;
    OnValueChangedListener onValueChangedListener;
    Paint paint = new Paint(3);
    private int colorControl;
    private Style style;
    DecelerateInterpolator interpolator = new DecelerateInterpolator();
    private ValueAnimator radiusAnimator;
    private ValueAnimator valueAnimator;

    public SeekBar(Context context) {
        super(context, null, 16842875);
        this.initSeekBar(null, 16842875, R.style.carbon_SeekBar);
    }

    public SeekBar(Context context, AttributeSet attrs) {
        super(context, attrs, 16842875);
        this.initSeekBar(attrs, 16842875, R.style.carbon_SeekBar);
    }

    public SeekBar(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initSeekBar(attrs, defStyleAttr, R.style.carbon_SeekBar);
    }

    @TargetApi(value=21)
    public SeekBar(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initSeekBar(attrs, defStyleAttr, defStyleRes);
    }

    private void initSeekBar(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        this.colorControl = Carbon.getThemeColor(this.getContext(), R.attr.colorControlNormal);
        this.thumbRadius = THUMB_RADIUS = Carbon.getDip(this.getContext()) * 8.0f;
        THUMB_RADIUS_DRAGGED = Carbon.getDip(this.getContext()) * 10.0f;
        STROKE_WIDTH = Carbon.getDip(this.getContext()) * 2.0f;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyleAttr, defStyleRes);
        this.setStyle(Style.values()[a.getInt(R.styleable.SeekBar_carbon_barStyle, 0)]);
        this.setMin(a.getFloat(R.styleable.SeekBar_carbon_min, 0.0f));
        this.setMax(a.getFloat(R.styleable.SeekBar_carbon_max, 0.0f));
        this.setStepSize(a.getFloat(R.styleable.SeekBar_carbon_stepSize, 0.0f));
        this.setValue(a.getFloat(R.styleable.SeekBar_carbon_value, 0.0f));
        this.setTick(a.getBoolean(R.styleable.SeekBar_carbon_tick, true));
        this.setTickStep(a.getInt(R.styleable.SeekBar_carbon_tickStep, 1));
        this.setTickColor(a.getColor(R.styleable.SeekBar_carbon_tickColor, 0));
        this.setShowLabel(a.getBoolean(R.styleable.SeekBar_carbon_showLabel, false));
        this.setLabelFormat(a.getString(R.styleable.SeekBar_carbon_labelFormat));
        a.recycle();
        this.setFocusableInTouchMode(false);
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max((int)Math.ceil(THUMB_RADIUS_DRAGGED * 2.0f), super.getSuggestedMinimumWidth());
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max((int)Math.ceil(THUMB_RADIUS_DRAGGED * 2.0f), super.getSuggestedMinimumHeight());
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = this.getSuggestedMinimumWidth();
        int desiredHeight = this.getSuggestedMinimumHeight();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        boolean ltr = ViewCompat.getLayoutDirection((View)this) == 0;
        float v = (this.value - this.min) / (this.max - this.min);
        if (!ltr) {
            v = 1.0f - v;
        }
        int thumbX = (int)(v * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        int thumbY = this.getHeight() / 2;
        this.paint.setStrokeWidth(STROKE_WIDTH);
        if (!this.isInEditMode()) {
            this.paint.setColor(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1);
        }
        if (ltr) {
            if ((float)this.getPaddingLeft() < (float)thumbX - this.thumbRadius) {
                canvas.drawLine((float)this.getPaddingLeft(), (float)thumbY, (float)thumbX - this.thumbRadius, (float)thumbY, this.paint);
            }
        } else if ((float)thumbX - this.thumbRadius < (float)(this.getWidth() - this.getPaddingRight())) {
            canvas.drawLine((float)thumbX - this.thumbRadius, (float)thumbY, (float)(this.getWidth() - this.getPaddingRight()), (float)thumbY, this.paint);
        }
        this.paint.setColor(this.colorControl);
        if (ltr) {
            if ((float)thumbX + this.thumbRadius < (float)(this.getWidth() - this.getPaddingRight())) {
                canvas.drawLine((float)thumbX + this.thumbRadius, (float)thumbY, (float)(this.getWidth() - this.getPaddingRight()), (float)thumbY, this.paint);
            }
        } else if ((float)this.getPaddingLeft() < (float)thumbX + this.thumbRadius) {
            canvas.drawLine((float)this.getPaddingLeft(), (float)thumbY, (float)thumbX + this.thumbRadius, (float)thumbY, this.paint);
        }
        if (this.style == Style.Discrete && this.tick) {
            this.paint.setColor(this.tickColor);
            float range = (this.max - this.min) / this.step;
            int i = 0;
            while ((float)i < range) {
                canvas.drawCircle((float)i / range * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft(), (float)this.getHeight() / 2.0f, STROKE_WIDTH / 2.0f, this.paint);
                i += this.tickStep;
            }
            canvas.drawCircle((float)(this.getWidth() - this.getPaddingRight()), (float)this.getHeight() / 2.0f, STROKE_WIDTH / 2.0f, this.paint);
        }
        if (!this.isInEditMode()) {
            this.paint.setColor(this.tint != null ? this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()) : -1);
        }
        canvas.drawCircle((float)thumbX, (float)thumbY, this.thumbRadius, this.paint);
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        if (showLabel) {
            this.popup = new SeekBarPopup(this.getContext());
        }
    }

    public boolean getShowLabel() {
        return this.showLabel;
    }

    public void setLabelFormat(String format) {
        this.labelFormat = format;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style2) {
        this.style = style2;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max > this.min ? max : this.min + this.step;
        this.value = MathUtils.constrain(this.value, this.min, max);
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min < this.max ? min : (this.max > this.step ? this.max - this.step : 0.0f);
        this.value = MathUtils.constrain(this.value, min, this.max);
    }

    private int stepValue(float v) {
        return (int)(Math.floor((v - this.min + this.step / 2.0f) / this.step) * (double)this.step + (double)this.min);
    }

    public float getValue() {
        if (this.style == Style.Discrete) {
            return this.stepValue(this.value);
        }
        return this.value;
    }

    public void setValue(float value) {
        this.value = this.style == Style.Discrete ? (float)this.stepValue(MathUtils.constrain(value, this.min, this.max)) : MathUtils.constrain(value, this.min, this.max);
    }

    public float getStepSize() {
        return this.step;
    }

    public void setStepSize(float step) {
        this.step = step > 0.0f ? step : 1.0f;
    }

    public boolean hasTick() {
        return this.tick;
    }

    public void setTick(boolean tick) {
        this.tick = tick;
    }

    public int getTickStep() {
        return this.tickStep;
    }

    public void setTickStep(int tickStep) {
        this.tickStep = tickStep;
    }

    public int getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(int tickColor) {
        this.tickColor = tickColor;
    }

    public void setOnValueChangedListener(OnValueChangedListener onValueChangedListener) {
        this.onValueChangedListener = onValueChangedListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        ViewParent parent;
        boolean ltr;
        if (!this.isEnabled()) {
            return false;
        }
        boolean bl = ltr = ViewCompat.getLayoutDirection((View)this) == 0;
        if (event.getAction() == 0) {
            if (this.radiusAnimator != null) {
                this.radiusAnimator.end();
            }
            this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius, THUMB_RADIUS_DRAGGED});
            this.radiusAnimator.setDuration(200L);
            this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            this.radiusAnimator.addUpdateListener(animation -> {
                this.thumbRadius = ((Float)animation.getAnimatedValue()).floatValue();
                this.postInvalidate();
            });
            this.radiusAnimator.start();
            parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            if (this.showLabel) {
                this.popup.show(this);
            }
        } else if (event.getAction() == 3 || event.getAction() == 1) {
            if (this.style == Style.Discrete) {
                float val = (float)Math.floor((this.value - this.min + this.step / 2.0f) / this.step) * this.step + this.min;
                if (this.valueAnimator != null) {
                    this.valueAnimator.cancel();
                }
                this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.value, val});
                this.valueAnimator.setDuration(200L);
                this.valueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
                this.valueAnimator.addUpdateListener(animation -> {
                    this.value = ((Float)animation.getAnimatedValue()).floatValue();
                    float v = (this.value - this.min) / (this.max - this.min);
                    int thumbX = ltr ? (int)(v * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft()) : (int)((1.0f - v) * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
                    int thumbY = this.getHeight() / 2;
                    int radius = this.rippleDrawable.getRadius();
                    this.rippleDrawable.setBounds(thumbX - radius, thumbY - radius, thumbX + radius, thumbY + radius);
                    this.postInvalidate();
                });
                this.valueAnimator.start();
            }
            if (this.radiusAnimator != null) {
                this.radiusAnimator.end();
            }
            this.radiusAnimator = ValueAnimator.ofFloat((float[])new float[]{this.thumbRadius, THUMB_RADIUS});
            this.radiusAnimator.setDuration(200L);
            this.radiusAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            this.radiusAnimator.addUpdateListener(animation -> {
                this.thumbRadius = ((Float)animation.getAnimatedValue()).floatValue();
                this.postInvalidate();
            });
            this.radiusAnimator.start();
            parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(false);
            }
            if (this.showLabel) {
                this.popup.dismiss();
            }
        }
        float v = (event.getX() - (float)this.getPaddingLeft()) / (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
        v = Math.max(0.0f, Math.min(v, 1.0f));
        float newValue = ltr ? v * (this.max - this.min) + this.min : (1.0f - v) * (this.max - this.min) + this.min;
        int thumbX = (int)(v * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) + (float)this.getPaddingLeft());
        int thumbY = this.getHeight() / 2;
        int radius = this.rippleDrawable.getRadius();
        if (this.showLabel) {
            int[] location = new int[2];
            this.getLocationInWindow(location);
            this.popup.setText(String.format(this.labelFormat, Float.valueOf(newValue)));
            this.popup.update(thumbX + location[0] - this.popup.getBubbleWidth() / 2, thumbY - radius + location[1] - this.popup.getHeight());
        }
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setHotspot(event.getX(), event.getY());
            this.rippleDrawable.setBounds(thumbX - radius, thumbY - radius, thumbX + radius, thumbY + radius);
        }
        this.postInvalidate();
        if (newValue != this.value && this.onValueChangedListener != null) {
            if (this.style == Style.Discrete) {
                int sv = this.stepValue(newValue);
                if (this.stepValue(this.value) != sv) {
                    this.onValueChangedListener.onValueChanged(this, sv);
                }
            } else {
                this.onValueChangedListener.onValueChanged(this, newValue);
            }
        }
        this.value = newValue;
        super.onTouchEvent(event);
        return true;
    }

    public static interface OnValueChangedListener {
        public void onValueChanged(SeekBar var1, float var2);
    }

    public static enum Style {
        Continuous,
        Discrete;

    }
}

