/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import carbon.R;
import carbon.animation.AnimUtils;
import carbon.widget.FrameLayout;
import carbon.widget.SnackbarView;
import java.util.ArrayList;
import java.util.List;

public class Snackbar {
    public static int INFINITE = -1;
    private Context context;
    private ViewGroup container;
    private Style style = null;
    private long duration;
    private Runnable hideRunnable = this::dismiss;
    private Handler handler;
    private OnDismissedListener onDismissedListener;
    private boolean swipeToDismiss = true;
    private boolean tapOutsideToDismiss;
    private int gravity = 8388691;
    private SnackbarLayout snackbarLayout;
    private SnackbarView snackbarView;
    private static List<Snackbar> next = new ArrayList<Snackbar>();

    public Snackbar(Context context, String message, int duration) {
        this.context = context;
        this.handler = new Handler();
        this.snackbarLayout = new SnackbarLayout(context);
        this.snackbarView = this.snackbarLayout.getView();
        this.snackbarView.setMessage(message);
        this.snackbarView.setInAnimator((Animator)AnimUtils.getSlideInAnimator());
        this.snackbarView.setOutAnimator((Animator)AnimUtils.getSlideOutAnimator(this.gravity));
        this.setDuration(duration);
        this.setTapOutsideToDismissEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(ViewGroup container) {
        Class<SnackbarLayout> clazz = SnackbarLayout.class;
        synchronized (SnackbarLayout.class) {
            this.container = container;
            if (!next.contains(this)) {
                next.add(this);
            }
            if (next.indexOf(this) == 0) {
                Rect windowFrame = new Rect();
                container.getWindowVisibleDisplayFrame(windowFrame);
                Rect drawingRect = new Rect();
                container.getDrawingRect(drawingRect);
                if (this.style == null) {
                    this.setStyle(Style.Auto);
                }
                container.addView((View)this.snackbarLayout, new ViewGroup.LayoutParams(-1, -1));
                this.snackbarView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.snackbarView.getLayoutParams();
                if ((this.gravity & 0x50) == 80) {
                    this.snackbarView.setTranslationY(this.snackbarView.getMeasuredHeight() + layoutParams.bottomMargin);
                } else {
                    this.snackbarView.setTranslationY(-this.snackbarView.getMeasuredHeight() - layoutParams.topMargin);
                }
                this.snackbarView.setVisibility(4);
                this.snackbarView.animateVisibility(0);
                if (this.duration != (long)INFINITE) {
                    this.handler.postDelayed(this.hideRunnable, this.duration);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void show() {
        this.show(this.container);
    }

    public static void clearQueue() {
        next.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        Class<SnackbarLayout> clazz = SnackbarLayout.class;
        synchronized (SnackbarLayout.class) {
            this.handler.removeCallbacks(this.hideRunnable);
            this.snackbarView.getOutAnimator().addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    Snackbar.this.fireOnDismissedListener();
                    Snackbar.this.hideInternal();
                }
            });
            this.snackbarView.animateVisibility(8);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void fireOnDismissedListener() {
        if (this.onDismissedListener != null) {
            this.onDismissedListener.onDismiss();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideInternal() {
        Class<SnackbarLayout> clazz = SnackbarLayout.class;
        synchronized (SnackbarLayout.class) {
            if (this.snackbarLayout.getParent() == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ((ViewGroup)this.snackbarLayout.getParent()).removeView((View)this.snackbarLayout);
            next.remove(this);
            if (next.size() != 0) {
                next.get(0).show();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style2) {
        FrameLayout.LayoutParams layoutParams;
        this.style = style2;
        if (style2 == Style.Auto) {
            Style style3 = this.style = this.context.getResources().getBoolean(R.bool.carbon_isPhone) ? Style.Docked : Style.Floating;
        }
        if ((layoutParams = (FrameLayout.LayoutParams)this.snackbarView.getLayoutParams()) == null) {
            layoutParams = this.snackbarLayout.generateDefaultLayoutParams();
        }
        if (this.style == Style.Floating) {
            layoutParams.width = -2;
            layoutParams.height = -2;
            int margin = (int)this.context.getResources().getDimension(R.dimen.carbon_margin);
            layoutParams.setMargins(margin, margin, margin, margin);
            layoutParams.gravity = this.gravity;
            this.snackbarView.setCornerRadius((int)this.context.getResources().getDimension(R.dimen.carbon_cornerRadiusButton));
        } else {
            layoutParams.width = -1;
            layoutParams.height = -2;
            layoutParams.setMargins(0, 0, 0, 0);
            layoutParams.gravity = this.gravity;
            this.snackbarView.setCornerRadius(0.0f);
        }
        this.snackbarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isSwipeToDismissEnabled() {
        return this.swipeToDismiss;
    }

    public void setSwipeToDismissEnabled(boolean swipeToDismiss) {
        this.swipeToDismiss = swipeToDismiss;
        this.snackbarLayout.initSwipeToDismissEnabled();
    }

    public boolean isTapOutsideToDismissEnabled() {
        return this.tapOutsideToDismiss;
    }

    public void setTapOutsideToDismissEnabled(boolean tapOutsideToDismiss) {
        this.tapOutsideToDismiss = tapOutsideToDismiss;
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        this.onDismissedListener = onDismissedListener;
    }

    public void setInAnimator(Animator inAnim) {
        this.snackbarView.setInAnimator(inAnim);
    }

    public Animator getInAnimator() {
        return this.snackbarView.getInAnimator();
    }

    public void setOutAnimator(Animator outAnim) {
        this.snackbarView.setOutAnimator(outAnim);
    }

    public Animator getOutAnimator() {
        return this.snackbarView.getOutAnimator();
    }

    public View getView() {
        return this.snackbarView;
    }

    public void setAction(String text, OnActionListener listener) {
        this.snackbarView.setAction(text, listener);
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.snackbarView.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.snackbarLayout.generateDefaultLayoutParams();
        }
        layoutParams.gravity = gravity;
        this.snackbarView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public int getGravity() {
        return this.gravity;
    }

    class SnackbarLayout
    extends FrameLayout {
        private float swipe;
        private ValueAnimator animator;
        private SnackbarView snackbarView;
        private Rect rect;
        private Handler handler;
        GestureDetector gestureDetector;
        @SuppressLint(value={"ClickableViewAccessibility"})
        private View.OnTouchListener listener;

        public SnackbarLayout(Context context) {
            super(context);
            this.rect = new Rect();
            this.gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                    if (Snackbar.this.swipeToDismiss && SnackbarLayout.this.animator == null && SnackbarLayout.this.getParent() != null) {
                        SnackbarLayout.this.swipe = e2.getX() - e1.getX();
                        SnackbarLayout.this.snackbarView.setTranslationX(SnackbarLayout.this.swipe);
                        SnackbarLayout.this.snackbarView.setAlpha(Math.max(0.0f, 1.0f - 2.0f * Math.abs(SnackbarLayout.this.swipe) / (float)SnackbarLayout.this.snackbarView.getMeasuredWidth()));
                        SnackbarLayout.this.postInvalidate();
                        if (Math.abs(SnackbarLayout.this.swipe) > (float)(SnackbarLayout.this.snackbarView.getMeasuredWidth() / 4)) {
                            SnackbarLayout.this.handler.removeCallbacks(Snackbar.this.hideRunnable);
                            SnackbarLayout.this.animator = ObjectAnimator.ofFloat((float[])new float[]{SnackbarLayout.this.swipe, (float)SnackbarLayout.this.snackbarView.getMeasuredWidth() / 2.0f * Math.signum(SnackbarLayout.this.swipe)});
                            SnackbarLayout.this.animator.setDuration(200L);
                            SnackbarLayout.this.animator.addUpdateListener(valueAnimator -> {
                                float s = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                                SnackbarLayout.this.snackbarView.setTranslationX(s);
                                float alpha = Math.max(0.0f, 1.0f - 2.0f * Math.abs(((Float)valueAnimator.getAnimatedValue()).floatValue()) / (float)SnackbarLayout.this.snackbarView.getMeasuredWidth());
                                SnackbarLayout.this.snackbarView.setAlpha(alpha);
                                SnackbarLayout.this.postInvalidate();
                            });
                            SnackbarLayout.this.animator.start();
                            SnackbarLayout.this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    Snackbar.this.hideInternal();
                                    SnackbarLayout.this.animator = null;
                                }
                            });
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.listener = (v, event) -> {
                if (Snackbar.this.isSwipeToDismissEnabled()) {
                    if (event.getAction() == 0) {
                        this.swipe = 0.0f;
                        this.handler.removeCallbacks(Snackbar.this.hideRunnable);
                        if (this.animator != null) {
                            this.animator.cancel();
                            this.animator = null;
                            this.swipe = this.snackbarView.getTranslationX();
                        }
                        return true;
                    }
                    if ((event.getAction() == 1 || event.getAction() == 3) && this.animator == null) {
                        this.animator = ObjectAnimator.ofFloat((float[])new float[]{this.swipe, 0.0f});
                        this.animator.setDuration(200L);
                        this.animator.addUpdateListener(animation -> {
                            float s = ((Float)animation.getAnimatedValue()).floatValue();
                            this.snackbarView.setTranslationX(s);
                            this.snackbarView.setAlpha(Math.max(0.0f, 1.0f - 2.0f * Math.abs(s) / (float)this.snackbarView.getWidth()));
                            this.postInvalidate();
                        });
                        this.animator.start();
                        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                SnackbarLayout.this.animator.cancel();
                                SnackbarLayout.this.animator = null;
                                if (Snackbar.this.duration != (long)INFINITE) {
                                    SnackbarLayout.this.handler.postDelayed(Snackbar.this.hideRunnable, Snackbar.this.duration);
                                }
                            }
                        });
                        return true;
                    }
                }
                return false;
            };
            this.handler = new Handler();
            this.snackbarView = new SnackbarView(context);
            this.addView((View)this.snackbarView);
        }

        @Override
        public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
            this.snackbarView.getHitRect(this.rect);
            if (this.rect.contains((int)event.getX(), (int)event.getY())) {
                if (this.gestureDetector.onTouchEvent(event)) {
                    return true;
                }
            } else if (Snackbar.this.isTapOutsideToDismissEnabled()) {
                Snackbar.this.dismiss();
            }
            return super.dispatchTouchEvent(event);
        }

        public void initSwipeToDismissEnabled() {
            this.snackbarView.setOnTouchListener(Snackbar.this.swipeToDismiss ? this.listener : null);
        }

        public SnackbarView getView() {
            return this.snackbarView;
        }
    }

    public static enum Style {
        Floating,
        Docked,
        Auto;

    }

    public static interface OnDismissedListener {
        public void onDismiss();
    }

    public static interface OnActionListener {
        public void onAction();
    }
}

