/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.content.Context;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import carbon.R;
import carbon.widget.Button;
import carbon.widget.LinearLayout;
import carbon.widget.Snackbar;
import carbon.widget.TextView;

class SnackbarView
extends LinearLayout {
    private TextView message;
    private Button button;

    public SnackbarView(Context context) {
        super(SnackbarView.getThemedContext(context), null, R.attr.carbon_snackbarStyle);
        this.initSnackbar();
    }

    static Context getThemedContext(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.carbon_snackbarTheme, outValue, true);
        int theme = outValue.resourceId;
        return new ContextThemeWrapper(context, theme);
    }

    private void initSnackbar() {
        View.inflate((Context)this.getContext(), (int)R.layout.carbon_snackbar, (ViewGroup)this);
        this.message = (TextView)this.findViewById(R.id.carbon_messageText);
        this.button = (Button)this.findViewById(R.id.carbon_actionButton);
    }

    public void setAction(String text, @Nullable Snackbar.OnActionListener listener) {
        if (text != null) {
            this.button.setText(text);
            this.button.setVisibility(0);
            this.setPadding(this.getPaddingLeft(), 0, (int)this.getResources().getDimension(R.dimen.carbon_paddingHalf), 0);
            this.button.setOnClickListener(v -> {
                if (listener != null) {
                    listener.onAction();
                }
            });
        } else {
            this.setPadding(this.getPaddingLeft(), 0, this.getPaddingLeft(), 0);
            this.button.setVisibility(8);
        }
    }

    public String getAction() {
        return this.button.getText().toString();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public String getMessage() {
        return this.message.getText().toString();
    }
}

