/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import carbon.R;
import carbon.component.Component;
import carbon.component.LayoutComponent;
import carbon.databinding.CarbonTablayoutTabBinding;
import carbon.recycler.RowFactory;
import carbon.widget.HorizontalScrollView;
import carbon.widget.ViewPager;
import com.annimon.stream.Stream;

public class TabLayout
extends HorizontalScrollView {
    ViewPager viewPager;
    private Paint paint = new Paint(1);
    LinearLayout content;
    private float indicatorPos = 0.0f;
    private int selectedPage = 0;
    private float indicatorPos2 = 0.0f;
    float indicatorHeight;
    DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
    boolean fixed = false;
    Item[] items;
    private RowFactory<Item> itemFactory;
    private ValueAnimator animator;
    private ValueAnimator animator2;
    private ViewPager.OnPageChangeListener pageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if ((position = Math.round((float)position + positionOffset)) != TabLayout.this.selectedPage) {
                View view = TabLayout.this.content.getChildAt(position);
                if (view == null) {
                    return;
                }
                if (TabLayout.this.animator != null) {
                    TabLayout.this.animator.cancel();
                }
                if (TabLayout.this.animator2 != null) {
                    TabLayout.this.animator2.cancel();
                }
                TabLayout.this.animator = ValueAnimator.ofFloat((float[])new float[]{TabLayout.this.indicatorPos, view.getLeft()});
                TabLayout.this.animator.setDuration(200L);
                if (position > TabLayout.this.selectedPage) {
                    TabLayout.this.animator.setStartDelay(100L);
                }
                TabLayout.this.animator.setInterpolator((TimeInterpolator)TabLayout.this.decelerateInterpolator);
                TabLayout.this.animator.addUpdateListener(animation -> {
                    TabLayout.this.indicatorPos = ((Float)animation.getAnimatedValue()).floatValue();
                    TabLayout.this.postInvalidate();
                });
                TabLayout.this.animator.start();
                TabLayout.this.animator2 = ValueAnimator.ofFloat((float[])new float[]{TabLayout.this.indicatorPos2, view.getRight()});
                TabLayout.this.animator2.setDuration(200L);
                if (position < TabLayout.this.selectedPage) {
                    TabLayout.this.animator2.setStartDelay(100L);
                }
                TabLayout.this.animator2.setInterpolator((TimeInterpolator)TabLayout.this.decelerateInterpolator);
                TabLayout.this.animator2.addUpdateListener(animation -> {
                    TabLayout.this.indicatorPos2 = ((Float)animation.getAnimatedValue()).floatValue();
                    TabLayout.this.postInvalidate();
                });
                TabLayout.this.animator2.start();
                TabLayout.this.setSelectedPage(position);
                if (TabLayout.this.content.getChildAt(TabLayout.this.selectedPage).getLeft() - TabLayout.this.getScrollX() < 0) {
                    TabLayout.this.smoothScrollTo(TabLayout.this.content.getChildAt(TabLayout.this.selectedPage).getLeft(), 0);
                } else if (TabLayout.this.content.getChildAt(TabLayout.this.selectedPage).getRight() - TabLayout.this.getScrollX() > TabLayout.this.getWidth()) {
                    TabLayout.this.smoothScrollTo(TabLayout.this.content.getChildAt(TabLayout.this.selectedPage).getRight() - TabLayout.this.getWidth() + TabLayout.this.getPaddingLeft(), 0);
                }
            }
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public TabLayout(Context context) {
        super(context, null, R.attr.carbon_tabLayoutStyle);
        this.initPagerTabStrip(null, R.attr.carbon_tabLayoutStyle, R.style.carbon_TabLayout);
    }

    public TabLayout(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_tabLayoutStyle);
        this.initPagerTabStrip(attrs, R.attr.carbon_tabLayoutStyle, R.style.carbon_TabLayout);
    }

    public TabLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPagerTabStrip(attrs, defStyleAttr, R.style.carbon_TabLayout);
    }

    @TargetApi(value=21)
    public TabLayout(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initPagerTabStrip(attrs, defStyleAttr, defStyleRes);
    }

    private void initPagerTabStrip(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        ViewCompat.setLayoutDirection((View)this, (int)0);
        this.content = new LinearLayout(this.getContext());
        ViewCompat.setLayoutDirection((View)this.content, (int)layoutDirection);
        this.addView((View)this.content, -1, -2);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TabLayout, defStyleAttr, defStyleRes);
        this.setIndicatorHeight(a.getDimension(R.styleable.TabLayout_carbon_indicatorWidth, 2.0f));
        this.setFixed(a.getBoolean(R.styleable.TabLayout_carbon_fixedTabs, true));
        this.itemFactory = ItemComponent::new;
        a.recycle();
        this.setHorizontalFadingEdgeEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.initTabs();
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager != null) {
            viewPager.removeOnPageChangeListener(this.pageChangeListener);
        }
        this.viewPager = viewPager;
        if (viewPager != null) {
            viewPager.addOnPageChangeListener(this.pageChangeListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null && this.items == null) {
                this.items = (Item[])Stream.range((int)0, (int)adapter.getCount()).map(it -> new Item(adapter.getPageTitle(it.intValue()))).toArray(Item[]::new);
            }
        }
        this.initTabs();
    }

    @Deprecated
    public void setItemLayout(int itemLayoutId) {
    }

    public void setItemFactory(RowFactory<Item> factory) {
        this.itemFactory = factory;
        this.initTabs();
    }

    public void setItems(Item[] items) {
        this.items = items;
        this.initTabs();
    }

    private void initTabs() {
        this.content.removeAllViews();
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            Component<Item> component = this.itemFactory.create((ViewGroup)this);
            component.setData(this.items[i]);
            this.content.addView(component.getView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.fixed ? 0 : -2, -2, 1.0f));
            component.getView().setSelected(i == 0);
            int finalI = i++;
            component.getView().setOnClickListener(__ -> {
                if (this.viewPager != null) {
                    this.viewPager.setCurrentItem(finalI);
                } else {
                    this.pageChangeListener.onPageScrolled(finalI, 0.0f, 0);
                }
            });
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.content.getChildCount() == 0) {
            return;
        }
        if (this.indicatorPos == this.indicatorPos2) {
            this.indicatorPos2 = this.content.getChildAt(this.selectedPage).getWidth();
        }
        this.paint.setColor(this.getTint().getColorForState(this.getDrawableState(), this.getTint().getDefaultColor()));
        canvas.drawRect(this.indicatorPos + (float)this.getPaddingLeft(), (float)this.getHeight() - this.indicatorHeight - (float)this.getPaddingBottom(), this.indicatorPos2 + (float)this.getPaddingLeft(), (float)this.getHeight(), this.paint);
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        this.setFillViewport(fixed);
        this.initTabs();
    }

    public float getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setIndicatorHeight(float indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
        this.postInvalidate();
    }

    public void setSelectedPage(int position) {
        if (this.content.getChildCount() > this.selectedPage) {
            this.content.getChildAt(this.selectedPage).setSelected(false);
        }
        this.selectedPage = position;
        if (this.content.getChildCount() > this.selectedPage) {
            this.content.getChildAt(this.selectedPage).setSelected(true);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.selectedPage, this.getScrollX(), this.indicatorPos, this.indicatorPos2);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        final SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setSelectedPage(savedState.getSelectedPage());
        this.indicatorPos = savedState.getIndicatorPos();
        this.indicatorPos2 = savedState.getIndicatorPos2();
        this.post(new Runnable(){

            @Override
            public void run() {
                TabLayout.this.setScrollX(savedState.getScroll());
            }
        });
    }

    protected void dispatchSaveInstanceState(@NonNull SparseArray<Parcelable> container) {
        super.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(@NonNull SparseArray<Parcelable> container) {
        super.dispatchThawSelfOnly(container);
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private final int selectedPage;
        private final int scroll;
        private final float indicatorPos;
        private final float indicatorPos2;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int selectedPage, int scrollX, float indicatorPos, float indicatorPos2) {
            super(superState);
            this.selectedPage = selectedPage;
            this.scroll = scrollX;
            this.indicatorPos = indicatorPos;
            this.indicatorPos2 = indicatorPos2;
        }

        private SavedState(Parcel in) {
            super(in);
            this.selectedPage = in.readInt();
            this.scroll = in.readInt();
            this.indicatorPos = in.readFloat();
            this.indicatorPos2 = in.readFloat();
        }

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public int getScroll() {
            return this.scroll;
        }

        public float getIndicatorPos() {
            return this.indicatorPos;
        }

        public float getIndicatorPos2() {
            return this.indicatorPos2;
        }

        public void writeToParcel(@NonNull Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeInt(this.selectedPage);
            destination.writeInt(this.scroll);
            destination.writeFloat(this.indicatorPos);
            destination.writeFloat(this.indicatorPos2);
        }
    }

    private static class ItemComponent
    extends LayoutComponent<Item> {
        private CarbonTablayoutTabBinding binding = CarbonTablayoutTabBinding.bind(this.getView());

        ItemComponent(ViewGroup parent) {
            super(parent, R.layout.carbon_tablayout_tab);
        }

        @Override
        public void bind(Item data) {
            this.binding.carbonTabText.setText(data.title);
        }
    }

    public static class Item {
        private CharSequence title;

        public Item(CharSequence title) {
            this.title = title;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }
}

